/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.abstracts;

import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;

public abstract class BiomeNMS {
    public String name;
    public World world;

    public BiomeNMS(World world, String name) {
        this.world = world;
        this.name = CoreUtilities.toLowerCase(name);
    }

    public abstract DownfallType getDownfallType();

    public String getName() {
        return this.name;
    }

    public abstract float getHumidity();

    public abstract float getTemperature();

    public List<EntityType> getAllEntities() {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        entityTypes.addAll(this.getAmbientEntities());
        entityTypes.addAll(this.getCreatureEntities());
        entityTypes.addAll(this.getMonsterEntities());
        entityTypes.addAll(this.getWaterEntities());
        return entityTypes;
    }

    public abstract List<EntityType> getAmbientEntities();

    public abstract List<EntityType> getCreatureEntities();

    public abstract List<EntityType> getMonsterEntities();

    public abstract List<EntityType> getWaterEntities();

    public abstract int getFoliageColor();

    public abstract void setHumidity(float var1);

    public abstract void setTemperature(float var1);

    public void setPrecipitation(DownfallType type) {
        throw new UnsupportedOperationException();
    }

    public abstract void setFoliageColor(int var1);

    public abstract void setTo(Block var1);

    public ColorTag getColor(int x, int y) {
        ColorTag topLeft = new ColorTag(26, 191, 0);
        ColorTag topRight = new ColorTag(28, 164, 73);
        ColorTag bottomLeft = new ColorTag(174, 164, 42);
        ColorTag bottomRight = new ColorTag(96, 161, 123);
        float normalizedX = (float)x / 255.0f;
        float normalizedY = (float)y / 255.0f;
        ColorTag lu = this.scaleColor(topLeft, (1.0f - normalizedX) * (1.0f - normalizedY));
        ColorTag ru = this.scaleColor(topRight, normalizedX * (1.0f - normalizedY));
        ColorTag ld = this.scaleColor(bottomLeft, (1.0f - normalizedX) * normalizedY);
        ColorTag rd = this.scaleColor(bottomRight, normalizedX * normalizedY);
        int r = lu.red + ld.red + rd.red + ru.red;
        int g = lu.green + ld.green + rd.green + ru.green;
        int b = lu.blue + ld.blue + rd.blue + ru.blue;
        return new ColorTag(r, g, b);
    }

    public float clampColor(float n) {
        if (n < 0.0f) {
            return 0.0f;
        }
        if (n > 1.0f) {
            return 1.0f;
        }
        return n;
    }

    private ColorTag scaleColor(ColorTag color, float scale) {
        float r = (float)color.red * scale;
        float g = (float)color.green * scale;
        float b = (float)color.blue * scale;
        return new ColorTag((int)r, (int)g, (int)b);
    }

    public static enum DownfallType {
        RAIN,
        SNOW,
        NONE;

    }
}

