/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;

public class EntityHasNectar
implements Property {
    public static final String[] handledTags = new String[]{"has_nectar"};
    public static final String[] handledMechs = new String[]{"has_nectar"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        Entity bukkitEntity = ((EntityTag)entity).getBukkitEntity();
        return bukkitEntity instanceof Bee;
    }

    public static EntityHasNectar getFrom(ObjectTag entity) {
        if (!EntityHasNectar.describes(entity)) {
            return null;
        }
        return new EntityHasNectar((EntityTag)entity);
    }

    public EntityHasNectar(EntityTag entity) {
        this.entity = entity;
    }

    public Bee getBee() {
        return (Bee)this.entity.getBukkitEntity();
    }

    @Override
    public String getPropertyString() {
        return this.getBee().hasNectar() ? "true" : "false";
    }

    @Override
    public String getPropertyId() {
        return "has_nectar";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("has_nectar")) {
            return new ElementTag(this.getBee().hasNectar()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("has_nectar") && mechanism.requireBoolean()) {
            this.getBee().setHasNectar(mechanism.getValue().asBoolean());
        }
    }
}

