/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;

public class ItemInstrument
extends ItemProperty<ElementTag> {
    public static boolean describes(ItemTag item) {
        return item.getBukkitMaterial() == Material.GOAT_HORN;
    }

    @Override
    public ElementTag getPropertyValue() {
        MusicInstrument instrument = this.getMusicInstrument();
        if (instrument != null) {
            return new ElementTag(Utilities.namespacedKeyToString(instrument.getKey()));
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag param, Mechanism mechanism) {
        MusicInstrument instrument = MusicInstrument.getByKey((NamespacedKey)Utilities.parseNamespacedKey(param.asString()));
        if (instrument == null) {
            mechanism.echoError("Invalid horn instrument: '" + param.asString() + "'!");
            return;
        }
        this.setMusicInstrument(instrument);
    }

    @Override
    public String getPropertyId() {
        return "instrument";
    }

    public MusicInstrument getMusicInstrument() {
        MusicInstrumentMeta itemMeta = (MusicInstrumentMeta)this.getItemMeta();
        return itemMeta.getInstrument();
    }

    public void setMusicInstrument(MusicInstrument instrument) {
        MusicInstrumentMeta itemMeta = (MusicInstrumentMeta)this.getItemMeta();
        itemMeta.setInstrument(instrument);
        this.setItemMeta((ItemMeta)itemMeta);
    }

    public static void register() {
        ItemInstrument.autoRegister("instrument", ItemInstrument.class, ElementTag.class, false, new String[0]);
    }
}

