/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;

public class MaterialFaces
implements Property {
    public static final String[] handledMechs = new String[]{"faces"};
    MaterialTag material;

    public static boolean describes(ObjectTag material) {
        return material instanceof MaterialTag && ((MaterialTag)material).hasModernData() && ((MaterialTag)material).getModernData() instanceof MultipleFacing;
    }

    public static MaterialFaces getFrom(ObjectTag _material) {
        if (!MaterialFaces.describes(_material)) {
            return null;
        }
        return new MaterialFaces((MaterialTag)_material);
    }

    public MaterialFaces(MaterialTag _material) {
        this.material = _material;
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialFaces.class, ListTag.class, "valid_faces", (attribute, material) -> {
            ListTag toReturn = new ListTag();
            for (BlockFace face : material.getFaces().getAllowedFaces()) {
                toReturn.add(face.name());
            }
            return toReturn;
        }, new String[0]);
        PropertyParser.registerStaticTag(MaterialFaces.class, ListTag.class, "faces", (attribute, material) -> material.getFaceList(), new String[0]);
    }

    public ListTag getFaceList() {
        ListTag toReturn = new ListTag();
        for (BlockFace face : this.getFaces().getFaces()) {
            toReturn.add(face.name());
        }
        return toReturn;
    }

    public MultipleFacing getFaces() {
        return (MultipleFacing)this.material.getModernData();
    }

    @Override
    public String getPropertyString() {
        return this.getFaceList().identify();
    }

    @Override
    public String getPropertyId() {
        return "faces";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("faces")) {
            MultipleFacing facing = this.getFaces();
            for (BlockFace face : facing.getAllowedFaces()) {
                facing.setFace(face, false);
            }
            for (String faceName : mechanism.valueAsType(ListTag.class)) {
                facing.setFace(BlockFace.valueOf((String)faceName.toUpperCase()), true);
            }
        }
    }
}

