/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.entity;

import java.util.List;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;

public class AreaEffectCloudHelper {
    private AreaEffectCloud entity;

    public AreaEffectCloudHelper(Entity entity) {
        this.entity = (AreaEffectCloud)entity;
    }

    private PotionData getBPData() {
        return this.entity.getBasePotionData();
    }

    public String getBPName() {
        return this.getBPData().getType().name();
    }

    public boolean getBPUpgraded() {
        return this.getBPData().isUpgraded();
    }

    public boolean getBPExtended() {
        return this.getBPData().isExtended();
    }

    public void setBP(PotionType type, boolean extended, boolean upgraded) {
        this.entity.setBasePotionData(new PotionData(type, extended, upgraded));
    }

    public Color getColor() {
        return this.entity.getColor();
    }

    public void setColor(Color color) {
        this.entity.setColor(color);
    }

    public String getParticle() {
        return this.entity.getParticle().name();
    }

    public void setParticle(String name) {
        Particle particle = Particle.valueOf((String)name);
        if (particle != null) {
            this.entity.setParticle(particle);
        }
    }

    public float getRadius() {
        return this.entity.getRadius();
    }

    public float getRadiusOnUse() {
        return this.entity.getRadiusOnUse();
    }

    public float getRadiusPerTick() {
        return this.entity.getRadiusPerTick();
    }

    public void setRadius(float radius) {
        this.entity.setRadius(radius);
    }

    public void setRadiusOnUse(float radius) {
        this.entity.setRadiusOnUse(radius);
    }

    public void setRadiusPerTick(float radius) {
        this.entity.setRadiusPerTick(radius);
    }

    public long getDuration() {
        return this.entity.getDuration();
    }

    public long getDurationOnUse() {
        return this.entity.getDurationOnUse();
    }

    public long getReappDelay() {
        return this.entity.getReapplicationDelay();
    }

    public long getWaitTime() {
        return this.entity.getWaitTime();
    }

    public void setDuration(int ticks) {
        this.entity.setDuration(ticks);
    }

    public void setDurationOnUse(int ticks) {
        this.entity.setDurationOnUse(ticks);
    }

    public void setReappDelay(int ticks) {
        this.entity.setReapplicationDelay(ticks);
    }

    public void setWaitTime(int ticks) {
        this.entity.setWaitTime(ticks);
    }

    public List<PotionEffect> getCustomEffects() {
        return this.entity.getCustomEffects();
    }

    public boolean hasCustomEffects() {
        return this.entity.hasCustomEffects();
    }

    public void clearEffects() {
        this.entity.clearCustomEffects();
    }

    public void removeEffect(PotionEffectType type) {
        this.entity.removeCustomEffect(type);
    }

    public void addEffect(PotionEffect effect, boolean override) {
        this.entity.addCustomEffect(effect, override);
    }

    public ProjectileSource getSource() {
        return this.entity.getSource();
    }

    public void setSource(ProjectileSource source) {
        this.entity.setSource(source);
    }
}

