/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class EntityPotion
implements Property {
    public static final String[] handledTags = new String[]{"potion"};
    public static final String[] handledMechs = new String[]{"potion"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).getBukkitEntity() instanceof ThrownPotion || ((EntityTag)entity).getBukkitEntity() instanceof Arrow;
    }

    public static EntityPotion getFrom(ObjectTag entity) {
        if (!EntityPotion.describes(entity)) {
            return null;
        }
        return new EntityPotion((EntityTag)entity);
    }

    public EntityPotion(EntityTag entity) {
        this.entity = entity;
    }

    public ItemStack getPotion() {
        if (this.entity.getBukkitEntity() instanceof ThrownPotion) {
            return ((ThrownPotion)this.entity.getBukkitEntity()).getItem();
        }
        ItemStack refItem = new ItemStack(Material.POTION);
        PotionMeta meta = (PotionMeta)refItem.getItemMeta();
        meta.setBasePotionData(((Arrow)this.entity.getBukkitEntity()).getBasePotionData());
        refItem.setItemMeta((ItemMeta)meta);
        return refItem;
    }

    public void setPotion(ItemStack item) {
        if (this.entity.getBukkitEntity() instanceof ThrownPotion) {
            ((ThrownPotion)this.entity.getBukkitEntity()).setItem(item);
        } else {
            ((Arrow)this.entity.getBukkitEntity()).setBasePotionData(((PotionMeta)item.getItemMeta()).getBasePotionData());
        }
    }

    @Override
    public String getPropertyString() {
        return new ItemTag(this.getPotion()).identify();
    }

    @Override
    public String getPropertyId() {
        return "potion";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("potion")) {
            return new ItemTag(this.getPotion()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("potion") && mechanism.requireObject(ItemTag.class)) {
            this.setPotion(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
    }
}

