/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.RedisHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class RedisCommand
extends AbstractCommand
implements Holdable {
    public static volatile boolean everUsed = false;

    public RedisCommand() {
        this.setName("redis");
        this.setSyntax("redis [id:<ID>] [connect:<host> (auth:<secret>) (port:<port>/{6379}) (ssl:true/{false})/disconnect/subscribe:<channel>|.../unsubscribe/publish:<channel> message:<message>/command:<command> (args:<arg>|...)]");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
        this.setPrefixesHandled("auth", "port", "id", "message", "args");
        this.setBooleansHandled("ssl");
    }

    @Override
    public void onDisable() {
        if (everUsed) {
            RedisHelper.onDisable();
        }
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("connect")) {
                scriptEntry.addObject("action", new ElementTag("connect"));
                scriptEntry.addObject("host", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("disconnect")) {
                scriptEntry.addObject("action", new ElementTag("disconnect"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("subscribe")) {
                scriptEntry.addObject("action", new ElementTag("subscribe"));
                scriptEntry.addObject("channels", arg.asType(ListTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matches("unsubscribe")) {
                scriptEntry.addObject("action", new ElementTag("unsubscribe"));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("publish")) {
                scriptEntry.addObject("action", new ElementTag("publish"));
                scriptEntry.addObject("channel", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesPrefix("command")) {
                scriptEntry.addObject("action", new ElementTag("command"));
                scriptEntry.addObject("command", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid redis action!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        if (!CoreConfiguration.allowRedis) {
            Debug.echoError(scriptEntry, "Redis disabled by config!");
            return;
        }
        everUsed = true;
        RedisHelper.executeCommand(scriptEntry);
    }
}

