/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;

public class ProjectileHitScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ProjectileHitEvent event;
    public LocationTag hitBlock;
    public EntityTag hitEntity;
    public EntityTag projectile;
    public EntityTag shooter;

    public ProjectileHitScriptEvent() {
        this.registerCouldMatcher("<projectile> hits (<block>)");
        this.registerCouldMatcher("<projectile> hits <entity>");
        this.registerCouldMatcher("<entity> shoots <block> (with <projectile>)");
        this.registerSwitches("entity", "block", "shooter", "with");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        if (path.eventArgLowerAt(1).equals("shoots")) {
            BukkitImplDeprecations.entityShootsMaterialEvent.warn(path.container);
        } else {
            if (path.switches.containsKey("with")) {
                ProjectileHitScriptEvent.addPossibleCouldMatchFailReason("unrecognized switch name", "with");
                return false;
            }
            if (path.eventArgs.length > 2) {
                BukkitImplDeprecations.projectileHitsEventMatchers.warn(path.container);
            }
        }
        return true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryObjectSwitch("entity", this.hitEntity)) {
            return false;
        }
        if (!path.tryObjectSwitch("block", this.hitBlock)) {
            return false;
        }
        if (!path.tryObjectSwitch("shooter", this.shooter)) {
            return false;
        }
        if (path.eventArgLowerAt(1).equals("hits")) {
            if (!path.tryArgObject(0, this.projectile)) {
                return false;
            }
            if (path.eventArgs.length > 2 && !path.tryArgObject(2, this.hitEntity) && !path.tryArgObject(2, this.hitBlock)) {
                return false;
            }
        } else {
            if (this.event.getHitBlock() == null || !path.tryArgObject(2, new MaterialTag(this.event.getHitBlock()))) {
                return false;
            }
            if (!path.tryArgObject(0, this.shooter)) {
                return false;
            }
            if (!path.tryObjectSwitch("with", this.projectile)) {
                return false;
            }
            if (path.eventArgLowerAt(3).equals("with") && !path.tryArgObject(4, this.projectile)) {
                return false;
            }
        }
        if (!this.runInCheck(path, this.hitEntity != null ? this.hitEntity.getLocation() : this.hitBlock)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "projectile" -> this.projectile.getDenizenObject();
            case "hit_entity" -> {
                if (this.hitEntity != null) {
                    yield this.hitEntity.getDenizenObject();
                }
                yield null;
            }
            case "hit_block" -> this.hitBlock;
            case "hit_face" -> {
                if (this.event.getHitBlockFace() != null) {
                    yield new LocationTag(this.event.getHitBlockFace().getDirection());
                }
                yield null;
            }
            case "shooter" -> {
                if (this.shooter != null) {
                    yield this.shooter.getDenizenObject();
                }
                yield null;
            }
            case "location" -> {
                BukkitImplDeprecations.projectileHitsBlockLocationContext.warn();
                yield this.hitBlock;
            }
            default -> super.getContext(name);
        };
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.hitEntity != null ? this.hitEntity : this.shooter);
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        this.event = event;
        this.projectile = new EntityTag((Entity)event.getEntity());
        if (this.projectile.getLocation() == null) {
            return;
        }
        if (Double.isNaN(this.projectile.getLocation().getDirection().normalize().getX())) {
            return;
        }
        this.hitBlock = event.getHitBlock() != null ? new LocationTag(event.getHitBlock().getLocation()) : null;
        this.hitEntity = event.getHitEntity() != null ? new EntityTag(event.getHitEntity()) : null;
        this.shooter = this.projectile.getShooter();
        this.fire((Event)event);
    }
}

