/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.npc;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import java.util.List;
import net.citizensnpcs.trait.versioned.BossBarTrait;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;

public class NPCBossBarCommand
extends AbstractCommand {
    public NPCBossBarCommand() {
        this.setName("npcbossbar");
        this.setSyntax("npcbossbar (remove) (color:<color>) (options:<option>|...) (range:<#>) (style:<style>) (title:<title>) (progress:<progress>) (view_permission:<permission>) (visible:<true/false>)");
        this.setRequiredArguments(1, 8);
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("color:", (Enum<?>[])BarColor.values());
        tab.addWithPrefix("options:", (Enum<?>[])BarFlag.values());
        tab.addWithPrefix("style:", (Enum<?>[])BarStyle.values());
        tab.add("progress:health");
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="remove") boolean remove, @ArgName(value="color") @ArgPrefixed @ArgDefaultNull BarColor color, @ArgName(value="options") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=BarFlag.class) List<BarFlag> options, @ArgName(value="range") @ArgPrefixed @ArgDefaultNull ElementTag range, @ArgName(value="style") @ArgPrefixed @ArgDefaultNull BarStyle style, @ArgName(value="title") @ArgPrefixed @ArgDefaultNull String title, @ArgName(value="progress") @ArgPrefixed @ArgDefaultNull String progress, @ArgName(value="view_permission") @ArgPrefixed @ArgDefaultNull String viewPermission, @ArgName(value="visible") @ArgPrefixed @ArgDefaultNull ElementTag visible) {
        NPCTag npc = Utilities.getEntryNPC(scriptEntry);
        if (npc == null) {
            throw new InvalidArgumentsRuntimeException("Must have a linked NPC.");
        }
        if (remove) {
            npc.getCitizen().removeTrait(BossBarTrait.class);
            return;
        }
        BossBarTrait trait = (BossBarTrait)npc.getCitizen().getOrAddTrait(BossBarTrait.class);
        if (color != null) {
            trait.setColor(color);
        }
        if (range != null) {
            if (!range.isInt()) {
                throw new InvalidArgumentsRuntimeException("Invalid number '" + range + "' specified for 'range'.");
            }
            trait.setRange(range.asInt());
        }
        if (options != null) {
            trait.setFlags(options);
        }
        if (style != null) {
            trait.setStyle(style);
        }
        if (title != null) {
            trait.setTitle(title);
        }
        if (progress != null) {
            trait.setTrackVariable(progress);
        }
        if (viewPermission != null) {
            trait.setViewPermission(viewPermission.isEmpty() ? null : viewPermission);
        }
        if (visible != null) {
            if (!visible.isBoolean()) {
                throw new InvalidArgumentsRuntimeException("Invalid boolean '" + visible + "' specified for 'visible'.");
            }
            trait.setVisible(visible.asBoolean());
        }
    }
}

