/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.commands.core.ImageCommand;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;

public class ImageTag
implements Adjustable {
    public BufferedImage image;
    public String id;
    public static final ObjectTagProcessor<ImageTag> tagProcessor = new ObjectTagProcessor();
    String hexEncodedBytesCache;
    String prefix = "Image";

    @Fetchable(value="image")
    public static ImageTag valueOf(String string, TagContext context) {
        ImageTag imageById;
        if (string.startsWith("image@")) {
            string = string.substring("image@".length());
        }
        String stringLower = CoreUtilities.toLowerCase(string);
        if (!TagManager.isStaticParsing && (imageById = ImageCommand.loadedImages.get(stringLower)) != null) {
            return imageById;
        }
        if (!BinaryTag.isValidHex(stringLower)) {
            MapTag map = MapTag.valueOf(string, CoreUtilities.noDebugContext);
            if (map != null) {
                ElementTag width = map.getElement("width");
                ElementTag height = map.getElement("height");
                if (width == null || height == null || !width.isInt() || !height.isInt()) {
                    if ((context == null || context.showErrors()) && !TagManager.isStaticParsing) {
                        Debug.echoError("valueOf ImageTag returning null: must specify valid width/height.");
                    }
                    return null;
                }
                ImageTag image = new ImageTag(new BufferedImage(width.asInt(), height.asInt(), 2));
                ColorTag background = map.getObjectAs("background", ColorTag.class, context);
                if (background != null) {
                    int[] data = ((DataBufferInt)image.image.getRaster().getDataBuffer()).getData();
                    Arrays.fill(data, background.asARGB());
                }
                return image;
            }
            if ((context == null || context.showErrors()) && !TagManager.isStaticParsing) {
                Debug.echoError("valueOf ImageTag returning null: invalid binary data: " + string);
            }
            return null;
        }
        byte[] rawBytes = CoreUtilities.hexDecode(stringLower);
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(rawBytes));
            if (image == null) {
                if (context == null || context.showErrors()) {
                    Debug.echoError("valueOf ImageTag returning null: could not recognize image format for binary: " + string);
                }
                return null;
            }
            ImageTag imageTag = new ImageTag(image);
            imageTag.setHexEncodedBytesCache(stringLower);
            return imageTag;
        }
        catch (IOException e) {
            if (context == null || context.showErrors()) {
                Debug.echoError("valueOf ImageTag returning null: invalid binary data '" + string + "' (see stacktrace below)");
                Debug.echoError(e);
            }
            return null;
        }
    }

    public static boolean matches(String string) {
        if (string.startsWith("image@")) {
            return true;
        }
        return ImageTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public ImageTag(BufferedImage image) {
        this.image = image;
    }

    public static void register() {
        tagProcessor.registerTag(ColorTag.class, MapTag.class, "pixel_at", (attribute, object, param) -> {
            ElementTag x = param.getRequiredObjectAs("x", ElementTag.class, attribute);
            ElementTag y = param.getRequiredObjectAs("y", ElementTag.class, attribute);
            if (x == null || y == null) {
                return null;
            }
            if (!x.isInt() || !y.isInt()) {
                attribute.echoError("Invalid x/y '" + x + "/" + y + "' specified: must be valid numbers.");
                return null;
            }
            return ColorTag.fromARGB(object.image.getRGB(x.asInt(), y.asInt()));
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "width", (attribute, object) -> new ElementTag(object.image.getWidth()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "height", (attribute, object) -> new ElementTag(object.image.getHeight()), new String[0]);
        tagProcessor.registerTag(BinaryTag.class, ElementTag.class, "to_binary", (attribute, object, imageFormat) -> {
            ImageTag corrected = object.correctType(imageFormat.asString());
            if (corrected == null) {
                attribute.echoError("Invalid/unfitting image format specified: " + imageFormat + ".");
                return null;
            }
            return new BinaryTag(corrected.getRawBytes(imageFormat.asString()));
        }, new String[0]);
        tagProcessor.registerTag(ImageTag.class, "copy", (attribute, object) -> object.duplicateIgnoreId(), new String[0]);
        tagProcessor.registerTag(ImageTag.class, MapTag.class, "sub_image", (attribute, object, param) -> {
            ElementTag x = param.getRequiredObjectAs("x", ElementTag.class, attribute);
            ElementTag y = param.getRequiredObjectAs("y", ElementTag.class, attribute);
            ElementTag width = param.getRequiredObjectAs("width", ElementTag.class, attribute);
            ElementTag height = param.getRequiredObjectAs("height", ElementTag.class, attribute);
            if (x == null || y == null || width == null || height == null) {
                return null;
            }
            if (!(x.isInt() && y.isInt() && width.isInt() && height.isInt())) {
                attribute.echoError("Invalid x/y/width/height '" + x + "/" + y + "/" + width + "/" + height + "' specified: must be valid numbers.");
                return null;
            }
            return new ImageTag(object.image.getSubimage(x.asInt(), y.asInt(), width.asInt(), height.asInt())).duplicate();
        }, new String[0]);
        tagProcessor.registerMechanism("scale", false, MapTag.class, (object, mechanism, input) -> {
            ElementTag widthElement = input.getElement("width");
            ElementTag heightElement = input.getElement("height");
            if (widthElement != null && !widthElement.isInt() || heightElement != null && !heightElement.isInt()) {
                mechanism.echoError("Invalid width/height '" + widthElement + "/" + heightElement + "' specified: must be valid numbers.");
                return;
            }
            int width = widthElement != null ? widthElement.asInt() : object.image.getWidth();
            int height = heightElement != null ? heightElement.asInt() : object.image.getHeight();
            BufferedImage rescaled = new BufferedImage(width, height, object.image.getType());
            Graphics2D graphics = rescaled.createGraphics();
            graphics.setComposite(AlphaComposite.Src);
            graphics.drawImage(object.image, 0, 0, width, height, null);
            graphics.dispose();
            object.image = rescaled;
            object.markChanged();
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        tagProcessor.processMechanism(this, mechanism);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        mechanism.echoError("Cannot apply properties to an ImageTag.");
    }

    public byte[] getRawBytes(String imageFormat) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.image, imageFormat, outputStream);
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            Debug.echoError("Exception when converting image to bytes:");
            throw new RuntimeException(e);
        }
    }

    public ImageTag correctType(String imageFormat) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(imageFormat);
        if (!iter.hasNext()) {
            return null;
        }
        ImageWriterSpi imageWriterSpi = iter.next().getOriginatingProvider();
        if (imageWriterSpi.canEncodeImage(this.image)) {
            return this;
        }
        int correctType = -1;
        if (ImageTag.isSupportedType(imageWriterSpi, 2)) {
            correctType = 2;
        } else if (ImageTag.isSupportedType(imageWriterSpi, 1)) {
            correctType = 1;
        } else {
            for (int type = 3; type <= 13; ++type) {
                if (!ImageTag.isSupportedType(imageWriterSpi, type)) continue;
                correctType = type;
                break;
            }
        }
        if (correctType == -1) {
            Debug.echoError("Image format '" + imageFormat + "' doesn't allow any type?");
            return null;
        }
        BufferedImage correctedImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), correctType);
        Graphics2D graphics = correctedImage.createGraphics();
        graphics.setComposite(AlphaComposite.Src);
        graphics.drawImage((Image)this.image, 0, 0, null);
        graphics.dispose();
        return new ImageTag(correctedImage);
    }

    private static boolean isSupportedType(ImageWriterSpi imageWriterSpi, int type) {
        return imageWriterSpi.canEncodeImage(ImageTypeSpecifier.createFromBufferedImageType(type));
    }

    public void setHexEncodedBytesCache(String hexEncodedBytes) {
        this.hexEncodedBytesCache = "image@" + hexEncodedBytes;
    }

    public void markChanged() {
        this.hexEncodedBytesCache = null;
    }

    @Override
    public String identify() {
        if (this.id != null) {
            return "image@" + this.id;
        }
        if (this.hexEncodedBytesCache == null) {
            this.setHexEncodedBytesCache(BinaryTag.hexEncode(this.getRawBytes("png"), false));
        }
        return this.hexEncodedBytesCache;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    @Override
    public String debuggable() {
        if (this.id != null) {
            return "<LG>image@<Y>" + this.id;
        }
        MapTag imageData = new MapTag();
        imageData.putObject("width", (ObjectTag)new ElementTag(this.image.getWidth()));
        imageData.putObject("height", (ObjectTag)new ElementTag(this.image.getHeight()));
        return "<LG>image@<Y>" + imageData.debuggable().substring("<LG>map@".length());
    }

    @Override
    public boolean isUnique() {
        return this.id != null;
    }

    @Override
    public BufferedImage getJavaObject() {
        return this.image;
    }

    @Override
    public ImageTag duplicate() {
        if (this.isUnique()) {
            return this;
        }
        return this.duplicateIgnoreId();
    }

    public ImageTag duplicateIgnoreId() {
        BufferedImage clone = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
        Graphics2D graphics = clone.createGraphics();
        graphics.setComposite(AlphaComposite.Src);
        graphics.drawImage((Image)this.image, 0, 0, null);
        graphics.dispose();
        ImageTag duplicate = new ImageTag(clone);
        duplicate.hexEncodedBytesCache = this.hexEncodedBytesCache;
        return duplicate;
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ImageTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

