/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.interfaces.EntityAnimation;
import com.denizenscript.denizen.nms.interfaces.FakePlayer;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.npc.traits.MirrorTrait;
import com.denizenscript.denizen.objects.EntityFormObject;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAge;
import com.denizenscript.denizen.objects.properties.entity.EntityColor;
import com.denizenscript.denizen.objects.properties.entity.EntityTame;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.MultiVersionHelper1_19;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.entity.HideEntitiesHelper;
import com.denizenscript.denizen.utilities.flags.DataPersistenceFlagTracker;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.ChiseledBookshelf;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class EntityTag
implements ObjectTag,
Adjustable,
EntityFormObject,
FlaggableObject,
Cloneable {
    public static HashSet<String> earlyValidMechanisms = new HashSet<String>(Arrays.asList("max_health", "health_data", "health", "visible", "armor_pose", "arms", "base_plate", "is_small", "marker", "velocity", "age", "is_using_riptide", "size", "item", "scale", "translation", "left_rotation", "right_rotation", "brightness", "display", "pivot", "shadow_radius", "shadow_strength"));
    private static final Map<UUID, Entity> rememberedEntities = new HashMap<UUID, Entity>();
    public static boolean allowDespawnedNpcs = false;
    public Entity entity = null;
    public long cleanRateProtect = -60000L;
    public DenizenEntityType entity_type = null;
    private String data1 = null;
    private NPCTag npc = null;
    public UUID uuid = null;
    private String entityScript = null;
    public boolean isFake = false;
    public boolean isFakeValid = false;
    private String prefix = "Entity";
    public static ObjectTagProcessor<EntityTag> tagProcessor = new ObjectTagProcessor();
    public ArrayList<Mechanism> mechanisms = new ArrayList();
    public static HashSet<String> specialEntityMatchables = new HashSet<String>(Arrays.asList("entity", "npc", "player", "living", "vehicle", "fish", "projectile", "hanging", "monster", "mob", "animal"));

    public static void rememberEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.put(entity.getUniqueId(), entity);
    }

    public static void forgetEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        rememberedEntities.remove(entity.getUniqueId());
    }

    public static boolean isNPC(Entity entity) {
        return entity != null && entity.hasMetadata("NPC") && ((MetadataValue)entity.getMetadata("NPC").get(0)).asBoolean();
    }

    public static boolean isCitizensNPC(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (Depends.citizens == null) {
            return false;
        }
        if (!CitizensAPI.hasImplementation()) {
            return false;
        }
        if (!(entity instanceof NPCHolder)) {
            return false;
        }
        NPC npc = ((NPCHolder)entity).getNPC();
        return npc != null;
    }

    public static NPCTag getNPCFrom(Entity entity) {
        if (EntityTag.isCitizensNPC(entity)) {
            return NPCTag.fromEntity(entity);
        }
        return null;
    }

    public static boolean isPlayer(Entity entity) {
        return entity instanceof Player && !EntityTag.isNPC(entity);
    }

    public static PlayerTag getPlayerFrom(Entity entity) {
        if (EntityTag.isPlayer(entity)) {
            return PlayerTag.mirrorBukkitPlayer((OfflinePlayer)((Player)entity));
        }
        return null;
    }

    public ItemTag getItemInHand() {
        if (this.isLivingEntity() && this.getLivingEntity().getEquipment() != null) {
            ItemStack its = this.getLivingEntity().getEquipment().getItemInMainHand();
            if (its == null) {
                return null;
            }
            return new ItemTag(its.clone());
        }
        return null;
    }

    @Fetchable(value="e")
    public static EntityTag valueOf(String string, TagContext context) {
        FakeEntity entity;
        int slash;
        if (string == null) {
            return null;
        }
        UUID id = null;
        if (string.startsWith("e@") && !string.startsWith("e@fake") && (slash = string.indexOf(47)) != -1) {
            try {
                id = UUID.fromString(string.substring(2, slash));
                string = string.substring(slash + 1);
                entity = EntityTag.getEntityForID(id);
                if (entity != null) {
                    EntityTag result = new EntityTag((Entity)entity);
                    if (string.equalsIgnoreCase(result.getEntityScript()) || string.equalsIgnoreCase(result.getBukkitEntityType().name())) {
                        return result;
                    }
                    if (context == null || context.showErrors()) {
                        Debug.echoError("Invalid EntityTag! ID '" + id + "' is valid, but '" + string + "' does not match its type data.");
                    }
                }
            }
            catch (Exception entity2) {
                // empty catch block
            }
        }
        if (ObjectFetcher.isObjectWithProperties(string)) {
            return ObjectFetcher.getObjectFromWithProperties(EntityTag.class, string, context);
        }
        if ((string = CoreUtilities.toLowerCase(string)).startsWith("e@")) {
            if (string.startsWith("e@fake:")) {
                try {
                    UUID entityID = UUID.fromString(string.substring("e@fake:".length()));
                    entity = FakeEntity.idsToEntities.get(entityID);
                    if (entity != null) {
                        return entity.entity;
                    }
                    return null;
                }
                catch (Exception entityID) {
                    // empty catch block
                }
            }
            string = string.substring("e@".length());
        }
        if (string.equals("random")) {
            EntityType randomType = null;
            while (randomType == null || randomType.name().matches("^(COMPLEX_PART|DROPPED_ITEM|ENDER_CRYSTAL|ENDER_DRAGON|FISHING_HOOK|ITEM_FRAME|LEASH_HITCH|LIGHTNING|PAINTING|PLAYER|UNKNOWN|WEATHER|WITHER|WITHER_SKULL)$")) {
                randomType = EntityType.values()[CoreUtilities.getRandom().nextInt(EntityType.values().length)];
            }
            return new EntityTag(randomType, "RANDOM");
        }
        if (string.startsWith("n@")) {
            NPCTag npc = NPCTag.valueOf(string, context);
            if (npc != null) {
                if (npc.isSpawned()) {
                    return new EntityTag(npc);
                }
                if (!allowDespawnedNpcs && context != null && context.showErrors()) {
                    Debug.echoDebug((Debuggable)context, "NPC '" + string + "' is not spawned, errors may follow!");
                }
                return new EntityTag(npc);
            }
            if (context == null || context.debug || CoreConfiguration.debugOverride) {
                Debug.echoError("NPC '" + string + "' does not exist!");
            }
        } else if (string.startsWith("p@")) {
            PlayerTag returnable = PlayerTag.valueOf(string, context);
            if (returnable != null && returnable.isOnline()) {
                return new EntityTag((Entity)returnable.getPlayerEntity());
            }
            if (context == null || context.showErrors()) {
                Debug.echoError("Invalid Player! '" + string + "' could not be found. Has the player logged off?");
            }
        }
        if (ScriptRegistry.containsScript(string, EntityScriptContainer.class)) {
            EntityTag entity3 = ScriptRegistry.getScriptContainerAs(string, EntityScriptContainer.class).getEntityFrom();
            entity3.uuid = id;
            return entity3;
        }
        List<String> data = CoreUtilities.split(string, ',');
        DenizenEntityType type = DenizenEntityType.getByName(data.get(0));
        if (type != null && type.getBukkitEntityType() != EntityType.UNKNOWN) {
            EntityTag entity4 = new EntityTag(type, data.size() > 1 ? data.get(1) : null);
            entity4.uuid = id;
            return entity4;
        }
        try {
            UUID entityID = id != null ? id : UUID.fromString(string);
            Entity entity5 = EntityTag.getEntityForID(entityID);
            if (entity5 != null) {
                return new EntityTag(entity5);
            }
            return null;
        }
        catch (Exception exception) {
            if (context == null || context.showErrors()) {
                Debug.log("valueOf EntityTag returning null: " + string);
            }
            return null;
        }
    }

    public static Entity getEntityForID(UUID id) {
        if (rememberedEntities.containsKey(id)) {
            return rememberedEntities.get(id);
        }
        for (World world : Bukkit.getWorlds()) {
            Entity entity = NMSHandler.entityHelper.getEntity(world, id);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("n@") || arg.startsWith("e@") || arg.startsWith("p@")) {
            return true;
        }
        if ((arg = CoreUtilities.toUpperCase(arg.replace("e@", ""))).equals("RANDOM")) {
            return true;
        }
        if (ScriptRegistry.containsScript(arg, EntityScriptContainer.class)) {
            return true;
        }
        return DenizenEntityType.isRegistered(CoreUtilities.split(arg, ',').get(0));
    }

    public EntityTag(Entity entity) {
        if (entity != null) {
            this.entity = entity;
            this.entityScript = EntityScriptHelper.getEntityScript(entity);
            this.uuid = entity.getUniqueId();
            this.entity_type = DenizenEntityType.getByEntity(entity);
            if (EntityTag.isCitizensNPC(entity)) {
                this.npc = EntityTag.getNPCFrom(entity);
            }
        } else {
            Debug.echoError("Entity referenced is null!");
        }
    }

    public EntityTag(EntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    public EntityTag(EntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public EntityTag(EntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = DenizenEntityType.getByName(entityType.name());
            this.data1 = data1;
        } else {
            Debug.echoError("Entity_type referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(DenizenEntityType entityType, ArrayList<Mechanism> mechanisms) {
        this(entityType);
        this.mechanisms = mechanisms;
    }

    public EntityTag(DenizenEntityType entityType, String data1) {
        if (entityType != null) {
            this.entity = null;
            this.entity_type = entityType;
            this.data1 = data1;
        } else {
            Debug.echoError("DenizenEntityType referenced is null!");
        }
    }

    public EntityTag(NPCTag npc) {
        if (Depends.citizens == null) {
            return;
        }
        if (npc != null) {
            this.npc = npc;
            if (npc.isSpawned()) {
                this.entity = npc.getEntity();
                this.entity_type = DenizenEntityType.getByName(npc.getEntityType().name());
                this.uuid = this.entity.getUniqueId();
            }
        } else {
            Debug.echoError("NPC referenced is null!");
        }
    }

    @Override
    public EntityTag duplicate() {
        if (this.isUnique()) {
            return this;
        }
        try {
            EntityTag copy = (EntityTag)this.clone();
            if (copy.mechanisms != null) {
                copy.mechanisms = new ArrayList<Mechanism>(copy.mechanisms);
            }
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public AbstractFlagTracker getFlagTracker() {
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getFlagTracker();
        }
        if (this.isPlayer()) {
            return this.getDenizenPlayer().getFlagTracker();
        }
        Entity ent = this.getBukkitEntity();
        if (ent != null) {
            return new DataPersistenceFlagTracker((PersistentDataHolder)ent);
        }
        return null;
    }

    @Override
    public String getReasonNotFlaggable() {
        if (!this.isSpawned() || this.getBukkitEntity() == null) {
            return "the entity is not spawned";
        }
        return "unknown reason - something went wrong";
    }

    @Override
    public void reapplyTracker(AbstractFlagTracker tracker) {
        if (CoreConfiguration.skipAllFlagCleanings) {
            return;
        }
        if (this.cleanRateProtect + 60000L > DenizenCore.serverTimeMillis) {
            tracker.doTotalClean();
            this.cleanRateProtect = DenizenCore.serverTimeMillis;
        }
    }

    @Override
    public boolean isTruthy() {
        return this.isSpawnedOrValidForTag();
    }

    public DenizenEntityType getEntityType() {
        return this.entity_type;
    }

    public EntityType getBukkitEntityType() {
        return this.entity_type.getBukkitEntityType();
    }

    public void setEntityScript(String entityScript) {
        this.entityScript = entityScript;
    }

    public String getEntityScript() {
        return this.entityScript;
    }

    public UUID getUUID() {
        if (this.uuid == null && this.entity != null) {
            this.uuid = this.entity.getUniqueId();
        }
        return this.uuid;
    }

    @Override
    public EntityTag getDenizenEntity() {
        return this;
    }

    public EntityFormObject getDenizenObject() {
        if (this.entity == null && this.npc == null) {
            return this;
        }
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC();
        }
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return this;
    }

    public Entity getBukkitEntity() {
        Entity backup;
        if (!(this.uuid == null || this.entity != null && this.entity.isValid() || this.isFake || (backup = Bukkit.getEntity((UUID)this.uuid)) == null)) {
            this.entity = backup;
        }
        return this.entity;
    }

    public LivingEntity getLivingEntity() {
        if (this.entity instanceof LivingEntity) {
            return (LivingEntity)this.entity;
        }
        return null;
    }

    public boolean isLivingEntity() {
        return this.entity instanceof LivingEntity;
    }

    public boolean isLivingEntityType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return this.entity_type.getBukkitEntityType().isAlive();
        }
        return this.entity instanceof LivingEntity;
    }

    public boolean isMonsterType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return Monster.class.isAssignableFrom(this.entity_type.getBukkitEntityType().getEntityClass());
        }
        return this.getBukkitEntity() instanceof Monster;
    }

    public boolean isMobType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return Mob.class.isAssignableFrom(this.entity_type.getBukkitEntityType().getEntityClass());
        }
        return this.getBukkitEntity() instanceof Mob;
    }

    public boolean isAnimalType() {
        if (this.getBukkitEntity() == null && this.entity_type != null) {
            return Animals.class.isAssignableFrom(this.entity_type.getBukkitEntityType().getEntityClass());
        }
        return this.getBukkitEntity() instanceof Animals;
    }

    public boolean hasInventory() {
        return this.getBukkitEntity() instanceof InventoryHolder || this.isCitizensNPC();
    }

    public NPCTag getDenizenNPC() {
        if (this.npc != null) {
            return this.npc;
        }
        return EntityTag.getNPCFrom(this.entity);
    }

    public boolean isNPC() {
        return this.npc != null || EntityTag.isNPC(this.entity);
    }

    public boolean isCitizensNPC() {
        return this.npc != null || EntityTag.isCitizensNPC(this.entity);
    }

    public Player getPlayer() {
        if (this.isPlayer()) {
            return (Player)this.entity;
        }
        return null;
    }

    public PlayerTag getDenizenPlayer() {
        if (this.isPlayer()) {
            return new PlayerTag(this.getPlayer());
        }
        return null;
    }

    public boolean isPlayer() {
        if (this.entity == null) {
            return this.entity_type.getBukkitEntityType() == EntityType.PLAYER && this.npc == null;
        }
        return this.entity instanceof Player && !this.isNPC();
    }

    public <T extends Entity> T as(Class<T> entityClass) {
        return (T)this.getBukkitEntity();
    }

    public Projectile getProjectile() {
        return (Projectile)this.entity;
    }

    public boolean isProjectile() {
        return this.entity instanceof Projectile;
    }

    public EntityTag getShooter() {
        ProjectileSource shooter;
        if (this.getBukkitEntity() instanceof TNTPrimed) {
            Entity source = ((TNTPrimed)this.getBukkitEntity()).getSource();
            if (source != null) {
                return new EntityTag(source);
            }
        } else if (this.isProjectile() && (shooter = this.getProjectile().getShooter()) instanceof Entity) {
            return new EntityTag((Entity)shooter);
        }
        return null;
    }

    public void setShooter(EntityTag shooter) {
        if (this.getBukkitEntity() instanceof TNTPrimed) {
            ((TNTPrimed)this.getBukkitEntity()).setSource(shooter.getBukkitEntity());
        } else if (this.isProjectile() && shooter.isLivingEntity()) {
            this.getProjectile().setShooter((ProjectileSource)shooter.getLivingEntity());
        }
    }

    public boolean hasShooter() {
        return this.getShooter() != null;
    }

    public Inventory getBukkitInventory() {
        if (this.hasInventory() && !this.isCitizensNPC()) {
            return ((InventoryHolder)this.getBukkitEntity()).getInventory();
        }
        return null;
    }

    public InventoryTag getInventory() {
        return this.hasInventory() ? (this.isCitizensNPC() ? this.getDenizenNPC().getDenizenInventory() : InventoryTag.mirrorBukkitInventory(this.getBukkitInventory())) : null;
    }

    public String getName() {
        String customName;
        if (this.isCitizensNPC()) {
            return this.getDenizenNPC().getCitizen().getName();
        }
        if (this.entity instanceof FakePlayer) {
            return ((FakePlayer)this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return this.entity.getName();
        }
        String string = customName = this.entity == null ? null : this.entity.getCustomName();
        if (customName != null) {
            return customName;
        }
        return this.entity_type.getName();
    }

    public ListTag getEquipment() {
        ItemStack[] equipment = this.getLivingEntity().getEquipment().getArmorContents();
        ListTag equipmentList = new ListTag();
        for (ItemStack item : equipment) {
            equipmentList.addObject(new ItemTag(item));
        }
        return equipmentList;
    }

    public boolean isGeneric() {
        return !this.isUnique();
    }

    @Override
    public LocationTag getLocation() {
        Entity entity = this.getBukkitEntity();
        if (entity != null) {
            return new LocationTag(entity.getLocation());
        }
        return null;
    }

    public LocationTag getEyeLocation() {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return null;
        }
        if (this.isPlayer()) {
            return new LocationTag(this.getPlayer().getEyeLocation());
        }
        if (!this.isGeneric() && this.isLivingEntity()) {
            return new LocationTag(this.getLivingEntity().getEyeLocation());
        }
        if (!this.isGeneric()) {
            return new LocationTag(entity.getLocation());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getTargetBlockSafe(Set<Material> mats, int range) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(this.getWorld());
            Location location = this.getLivingEntity().getTargetBlock(mats, range).getLocation();
            return location;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.getWorld());
        }
    }

    public Vector getVelocity() {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return null;
        }
        return entity.getVelocity();
    }

    public void setVelocity(Vector vector) {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return;
        }
        entity.setVelocity(vector);
    }

    public World getWorld() {
        Entity entity = this.getBukkitEntity();
        if (entity == null) {
            return null;
        }
        return entity.getWorld();
    }

    public void spawnAt(Location location) {
        this.spawnAt(location, PlayerTeleportEvent.TeleportCause.PLUGIN, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public void spawnAt(Location location, PlayerTeleportEvent.TeleportCause cause, CreatureSpawnEvent.SpawnReason reason) {
        if (location.getWorld() == null) {
            Debug.echoError("Cannot teleport or spawn entity at location '" + new LocationTag(location) + "' because it is missing a world.");
            return;
        }
        if (this.isCitizensNPC() || this.isUnique() && this.entity != null) {
            this.teleport(location, cause);
            return;
        }
        if (this.entity_type == null) {
            Debug.echoError("Cannot spawn a null EntityTag!");
            return;
        }
        if (this.entity_type.getBukkitEntityType() == EntityType.PLAYER && !this.entity_type.isCustom()) {
            if (Depends.citizens == null) {
                Debug.echoError("Cannot spawn entity of type PLAYER!");
                return;
            }
            NPCTag npc = new NPCTag(CitizensAPI.getNPCRegistry().createNPC(EntityType.PLAYER, this.data1));
            npc.getCitizen().spawn(location);
            this.entity = npc.getEntity();
        } else if (this.entity_type.getBukkitEntityType() == EntityType.FALLING_BLOCK) {
            MaterialTag material = null;
            if (this.data1 != null && MaterialTag.matches(this.data1)) {
                material = MaterialTag.valueOf(this.data1, CoreUtilities.basicContext);
                while (this.data1.equalsIgnoreCase("RANDOM") && (!material.getMaterial().isBlock() || material.getMaterial() == Material.AIR || material.getMaterial() == Material.NETHER_PORTAL || material.getMaterial() == Material.END_PORTAL)) {
                    material = MaterialTag.valueOf(this.data1, CoreUtilities.basicContext);
                }
            } else {
                for (Mechanism mech : this.mechanisms) {
                    if (!mech.getName().equals("fallingblock_type")) continue;
                    material = mech.valueAsType(MaterialTag.class);
                    this.mechanisms.remove(mech);
                    break;
                }
            }
            if (material == null || !material.getMaterial().isBlock() || !material.hasModernData()) {
                material = new MaterialTag(Material.SAND);
            }
            this.entity = location.getWorld().spawnFallingBlock(location, material.getModernData());
        } else if (this.entity_type.getBukkitEntityType() == EntityType.PAINTING) {
            this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript, reason);
            location = location.clone();
            Painting painting = (Painting)this.entity;
            Art art = null;
            BlockFace face = null;
            try {
                for (Mechanism mech : this.mechanisms) {
                    if (mech.getName().equals("painting")) {
                        art = Art.valueOf((String)mech.getValue().asString().toUpperCase());
                        continue;
                    }
                    if (!mech.getName().equals("rotation")) continue;
                    face = BlockFace.valueOf((String)mech.getValue().asString().toUpperCase());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (art != null && face != null) {
                if (art.getBlockHeight() % 2 == 0) {
                    location.subtract(0.0, 1.0, 0.0);
                }
                if (art.getBlockWidth() % 2 == 0) {
                    if (face == BlockFace.WEST) {
                        location.subtract(0.0, 0.0, 1.0);
                    } else if (face == BlockFace.SOUTH) {
                        location.subtract(1.0, 0.0, 0.0);
                    }
                }
                painting.teleport(location);
                painting.setFacingDirection(face, true);
                painting.setArt(art, true);
            }
        } else {
            this.entity = this.entity_type.spawnNewEntity(location, this.mechanisms, this.entityScript, reason);
        }
        if (this.entity == null) {
            if (!new LocationTag(location).isChunkLoaded()) {
                Debug.echoError("Error spawning entity - tried to spawn in an unloaded chunk.");
            } else {
                Debug.echoError("Error spawning entity - bad entity type, or blocked by another plugin?");
            }
            return;
        }
        this.uuid = this.entity.getUniqueId();
        if (this.entityScript != null) {
            EntityScriptHelper.setEntityScript(this.entity, this.entityScript);
        }
        for (Mechanism mechanism : this.mechanisms) {
            this.safeAdjust(new Mechanism(mechanism.getName(), mechanism.value, mechanism.context));
        }
        this.mechanisms.clear();
    }

    public boolean isSpawnedOrValidForTag() {
        if (this.isFake) {
            return true;
        }
        if (this.entity == null) {
            if (this.uuid == null) {
                return false;
            }
            return this.isValid() || rememberedEntities.containsKey(this.uuid);
        }
        NMSHandler.chunkHelper.changeChunkServerThread(this.entity.getWorld());
        try {
            boolean bl = this.isValid() || rememberedEntities.containsKey(this.entity.getUniqueId());
            return bl;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(this.entity.getWorld());
        }
    }

    public boolean isSpawned() {
        return this.isValid();
    }

    public boolean isValid() {
        Entity entity = this.getBukkitEntity();
        return entity != null && (entity.isValid() || this.isFake && this.isFakeValid);
    }

    public void remove() {
        this.entity.remove();
    }

    public void teleport(Location location) {
        this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (location.getWorld() == null) {
            Debug.echoError("Cannot teleport or spawn entity at location '" + new LocationTag(location) + "' because it is missing a world.");
            return;
        }
        if (this.isCitizensNPC()) {
            if (this.getDenizenNPC().getCitizen().isSpawned()) {
                this.getDenizenNPC().getCitizen().teleport(location, cause);
            } else if (this.getDenizenNPC().getCitizen().spawn(location)) {
                this.entity = this.getDenizenNPC().getCitizen().getEntity();
                this.uuid = this.getDenizenNPC().getCitizen().getEntity().getUniqueId();
            } else if (new LocationTag(location).isChunkLoaded()) {
                Debug.echoError("Error spawning NPC - tried to spawn in an unloaded chunk.");
            } else {
                Debug.echoError("Error spawning NPC - blocked by plugin");
            }
        } else if (this.isFake) {
            NMSHandler.entityHelper.snapPositionTo(this.entity, location.toVector());
            NMSHandler.entityHelper.look(this.entity, location.getYaw(), location.getPitch());
        } else {
            this.getBukkitEntity().teleport(location, cause);
            if (this.entity.getWorld().equals(location.getWorld())) {
                NMSHandler.entityHelper.teleport(this.entity, location);
            }
        }
    }

    public void target(LivingEntity target) {
        if (!this.isSpawned()) {
            return;
        }
        if (this.entity instanceof Mob) {
            ((Mob)this.entity).setTarget(target);
        } else if (this.entity instanceof ShulkerBullet) {
            ((ShulkerBullet)this.entity).setTarget((Entity)target);
        } else {
            Debug.echoError(this.identify() + " is not an entity type that can hold a target!");
        }
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public int comparesTo(EntityTag entity) {
        if (entity == null) {
            return 0;
        }
        if (entity.isUnique() && entity.identify().equals(this.identify())) {
            return 1;
        }
        if (!entity.isUnique()) {
            if (!this.isUnique() && entity.identify().equals(this.identify())) {
                return 1;
            }
            if (this.entity_type == entity.entity_type) {
                return 1;
            }
        }
        return 0;
    }

    public boolean comparedTo(String compare) {
        if ((compare = CoreUtilities.toLowerCase(compare)).equals("entity")) {
            return true;
        }
        if (compare.equals("player")) {
            return this.isPlayer();
        }
        if (compare.equals("npc")) {
            return this.isCitizensNPC() || this.isNPC();
        }
        if (this.getEntityScript() != null && compare.equals(CoreUtilities.toLowerCase(this.getEntityScript()))) {
            return true;
        }
        return compare.equals(this.getEntityType().getLowercaseName());
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public EntityTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        if (this.npc != null) {
            return this.npc.debuggable();
        }
        if (this.entity != null) {
            if (this.isPlayer()) {
                return this.getDenizenPlayer().debuggable();
            }
            if (this.isFake) {
                return "<LG>e@<Y>FAKE: " + this.getUUID() + "<GR>(FAKE-" + this.entity.getType().name() + "/" + this.entity.getName() + ")";
            }
            if (this.isSpawnedOrValidForTag()) {
                return "<LG>e@<Y> " + this.getUUID() + "<GR>(" + this.entity.getType().name() + "/" + this.entity.getName() + ")";
            }
        }
        return this.identify(this::getWaitingMechanismsDebuggable);
    }

    @Override
    public String savable() {
        if (this.npc != null) {
            return this.npc.savable();
        }
        if (this.isPlayer()) {
            return this.getDenizenPlayer().savable();
        }
        if (this.isFake) {
            return "e@fake:" + this.getUUID();
        }
        return this.identify();
    }

    @Override
    public String identify() {
        return this.identify(this::getWaitingMechanismsString);
    }

    public String identify(Supplier<String> mechsHandler) {
        if (this.npc != null) {
            return this.npc.identify();
        }
        if (this.isFake) {
            return "e@fake:" + this.getUUID();
        }
        if (this.getUUID() != null) {
            if (this.isPlayer()) {
                return this.getDenizenPlayer().identify();
            }
            if (this.entityScript != null) {
                return "e@" + this.getUUID() + "/" + this.entityScript;
            }
            if (this.entity_type != null) {
                return "e@" + this.getUUID() + "/" + this.entity_type.getLowercaseName();
            }
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript + mechsHandler.get();
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName() + mechsHandler.get();
        }
        return "null";
    }

    public String getWaitingMechanismsDebuggable() {
        StringBuilder properties = new StringBuilder();
        for (Mechanism mechanism : this.mechanisms) {
            properties.append(mechanism.getName()).append(" <LG>=<Y> ").append(mechanism.getValue().asString()).append("<LG>; <Y>");
        }
        if (properties.length() > 0) {
            return "<LG>[<Y>" + properties.substring(0, properties.length() - "; <Y>".length()) + " <LG>]";
        }
        return "";
    }

    public String getWaitingMechanismsString() {
        StringBuilder properties = new StringBuilder();
        for (Mechanism mechanism : this.mechanisms) {
            properties.append(PropertyParser.escapePropertyKey(mechanism.getName())).append("=").append(PropertyParser.escapePropertyValue(mechanism.getValue().asString())).append(";");
        }
        if (properties.length() > 0) {
            return "[" + properties.substring(0, properties.length() - 1) + "]";
        }
        return "";
    }

    @Override
    public String identifySimple() {
        if (this.npc != null && this.npc.isValid()) {
            return "n@" + this.npc.getId();
        }
        if (this.isPlayer()) {
            return "p@" + this.getPlayer().getName();
        }
        if (this.entityScript != null) {
            return "e@" + this.entityScript;
        }
        if (this.entity_type != null) {
            return "e@" + this.entity_type.getLowercaseName();
        }
        return "null";
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public Object getJavaObject() {
        return this.entity == null ? this.getBukkitEntityType() : this.entity;
    }

    @Override
    public boolean isUnique() {
        return this.entity != null || this.uuid != null || this.isFake || this.npc != null;
    }

    public LocationTag doLocationTag(Attribute attribute) {
        if (attribute.startsWith("cursor_on", 2)) {
            BukkitImplDeprecations.entityLocationCursorOnTag.warn(attribute.context);
            int range = attribute.getIntContext(2);
            if (range < 1) {
                range = 50;
            }
            HashSet<Material> set = new HashSet<Material>();
            set.add(Material.AIR);
            if (attribute.startsWith("ignore", 3) && attribute.hasContext(3)) {
                List<MaterialTag> ignoreList = attribute.contextAsType(3, ListTag.class).filter(MaterialTag.class, attribute.context);
                for (MaterialTag material : ignoreList) {
                    set.add(material.getMaterial());
                }
                attribute.fulfill(1);
            }
            attribute.fulfill(1);
            return new LocationTag(this.getTargetBlockSafe(set, range));
        }
        if (attribute.startsWith("standing_on", 2)) {
            BukkitImplDeprecations.entityStandingOn.warn(attribute.context);
            attribute.fulfill(1);
            return new LocationTag(this.getBukkitEntity().getLocation().clone().add(0.0, -0.5, 0.0));
        }
        return new LocationTag(this.getBukkitEntity().getLocation());
    }

    public static void register() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        PropertyParser.registerPropertyTagHandlers(EntityTag.class, tagProcessor);
        tagProcessor.registerTag(ElementTag.class, "entity_type", (attribute, object) -> new ElementTag(object.entity_type.getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "translated_name", (attribute, object) -> {
            String key = object.getEntityType().getBukkitEntityType().getKey().getKey();
            return new ElementTag("\u00a7[translate=entity.minecraft." + key + "]");
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "vanilla_tags", (attribute, object) -> {
            HashSet<String> tags = VanillaTagHelper.tagsByEntity.get(object.getBukkitEntityType());
            if (tags == null) {
                return new ListTag();
            }
            return new ListTag((Set<?>)tags);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_spawned", (attribute, object) -> new ElementTag(object.isSpawned()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "eid", (attribute, object) -> new ElementTag(object.getBukkitEntity().getEntityId()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "uuid", (attribute, object) -> new ElementTag(object.getUUID().toString()), new String[0]);
        tagProcessor.registerTag(ScriptTag.class, "script", (attribute, object) -> {
            if (object.entityScript == null) {
                return null;
            }
            return ScriptTag.valueOf(object.entityScript, CoreUtilities.noDebugContext);
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "scriptname", (attribute, object) -> {
            BukkitImplDeprecations.hasScriptTags.warn(attribute.context);
            if (object.entityScript == null) {
                return null;
            }
            return new ElementTag(object.entityScript);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.getName(), true), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "monster_type", (attribute, object) -> {
            EntityCategory category = object.getLivingEntity().getCategory();
            if (category == EntityCategory.NONE) {
                return null;
            }
            return new ElementTag((Enum<?>)category);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ItemTag.class, "saddle", (attribute, object) -> {
            if (object.getLivingEntity() instanceof AbstractHorse) {
                return new ItemTag(((AbstractHorse)object.getLivingEntity()).getInventory().getSaddle());
            }
            if (object.getLivingEntity() instanceof Steerable) {
                return new ItemTag(((Steerable)object.getLivingEntity()).hasSaddle() ? Material.SADDLE : Material.AIR);
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ItemTag.class, "horse_armor", (attribute, object) -> {
            if (object.getLivingEntity() instanceof Horse) {
                return new ItemTag(((Horse)object.getLivingEntity()).getInventory().getArmor());
            }
            return null;
        }, "horse_armour");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "has_saddle", (attribute, object) -> {
            if (object.getLivingEntity() instanceof AbstractHorse) {
                return new ElementTag(((AbstractHorse)object.getLivingEntity()).getInventory().getSaddle().getType() == Material.SADDLE);
            }
            if (object.getLivingEntity() instanceof Steerable) {
                return new ElementTag(((Steerable)object.getLivingEntity()).hasSaddle());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_trading", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Merchant) {
                return new ElementTag(((Merchant)object.getBukkitEntity()).isTrading());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "trading_with", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Merchant && ((Merchant)object.getBukkitEntity()).getTrader() != null) {
                return new EntityTag((Entity)((Merchant)object.getBukkitEntity()).getTrader()).getDenizenObject();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(MapTag.class, "trace_framed_map", (attribute, object) -> NMSHandler.entityHelper.mapTrace(object.getLivingEntity()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "map_trace", (attribute, object) -> {
            BukkitImplDeprecations.entityMapTraceTag.warn(attribute.context);
            MapTag result = NMSHandler.entityHelper.mapTrace(object.getLivingEntity());
            if (result == null) {
                return null;
            }
            return new LocationTag(null, result.getElement("x").asDouble(), result.getElement("y").asDouble());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "can_see", (attribute, object) -> {
            EntityTag toEntity;
            if (object.isLivingEntity() && attribute.hasParam() && EntityTag.matches(attribute.getParam()) && (toEntity = attribute.paramAsType(EntityTag.class)) != null && toEntity.isSpawnedOrValidForTag()) {
                return new ElementTag(object.getLivingEntity().hasLineOfSight(toEntity.getBukkitEntity()));
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "eye_location", (attribute, object) -> new LocationTag(object.getEyeLocation()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "eye_height", (attribute, object) -> {
            if (object.isLivingEntity()) {
                return new ElementTag(object.getLivingEntity().getEyeHeight());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "cursor_on_solid", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), range, FluidCollisionMode.NEVER, true)) != null && traced.getHitBlock() != null) {
                return new LocationTag(traced.getHitBlock().getLocation());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "cursor_on", (attribute, object) -> {
            RayTraceResult traced;
            double range = attribute.getDoubleParam();
            if (range <= 0.0) {
                range = 200.0;
            }
            if ((traced = object.getWorld().rayTraceBlocks((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), range, FluidCollisionMode.ALWAYS, false)) != null && traced.getHitBlock() != null) {
                return new LocationTag(traced.getHitBlock().getLocation());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "location", (attribute, object) -> object.doLocationTag(attribute), new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "standing_on", (attribute, object) -> {
            if (!object.getBukkitEntity().isOnGround()) {
                return null;
            }
            Location loc = object.getBukkitEntity().getLocation().clone().subtract(0.0, 0.05, 0.0);
            return new LocationTag(loc.getWorld(), (double)loc.getBlockX(), (double)loc.getBlockY(), loc.getBlockZ());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "body_yaw", (attribute, object) -> new ElementTag(NMSHandler.entityHelper.getBaseYaw(object.getLivingEntity())), new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "velocity", (attribute, object) -> new LocationTag(object.getBukkitEntity().getVelocity().toLocation(object.getBukkitEntity().getWorld())), new String[0]);
        EntityTag.registerSpawnedOnlyTag(WorldTag.class, "world", (attribute, object) -> new WorldTag(object.getBukkitEntity().getWorld()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "can_pickup_items", (attribute, object) -> {
            if (object.isLivingEntity()) {
                return new ElementTag(object.getLivingEntity().getCanPickupItems());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(MaterialTag.class, "fallingblock_material", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof FallingBlock)) {
                return null;
            }
            return new MaterialTag(((FallingBlock)object.getBukkitEntity()).getBlockData());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fall_distance", (attribute, object) -> new ElementTag(object.getBukkitEntity().getFallDistance()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fire_time", (attribute, object) -> new DurationTag(object.getBukkitEntity().getFireTicks() / 20), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "on_fire", (attribute, object) -> new ElementTag(object.getBukkitEntity().getFireTicks() > 0), new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "leash_holder", (attribute, object) -> {
            if (object.isLivingEntity() && object.getLivingEntity().isLeashed()) {
                return new EntityTag(object.getLivingEntity().getLeashHolder()).getDenizenObject();
            }
            return null;
        }, "get_leash_holder");
        EntityTag.registerSpawnedOnlyTag(ListTag.class, "passengers", (attribute, object) -> {
            ArrayList<EntityTag> passengers = new ArrayList<EntityTag>();
            for (Entity ent : object.getBukkitEntity().getPassengers()) {
                passengers.add(new EntityTag(ent));
            }
            return new ListTag((Collection<? extends ObjectTag>)passengers);
        }, "get_passengers");
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "passenger", (attribute, object) -> {
            if (!object.getBukkitEntity().isEmpty()) {
                return new EntityTag(object.getBukkitEntity().getPassenger()).getDenizenObject();
            }
            return null;
        }, "get_passenger");
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "shooter", (attribute, object) -> {
            EntityTag shooter = object.getShooter();
            if (shooter == null) {
                return null;
            }
            return shooter.getDenizenObject();
        }, "get_shooter");
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "left_shoulder", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof HumanEntity)) {
                return null;
            }
            Entity e = ((HumanEntity)object.getLivingEntity()).getShoulderEntityLeft();
            if (e == null) {
                return null;
            }
            return new EntityTag(e).getDenizenObject();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "right_shoulder", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof HumanEntity)) {
                return null;
            }
            Entity e = ((HumanEntity)object.getLivingEntity()).getShoulderEntityRight();
            if (e == null) {
                return null;
            }
            return new EntityTag(e).getDenizenObject();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "vehicle", (attribute, object) -> {
            if (object.getBukkitEntity().isInsideVehicle()) {
                return new EntityTag(object.getBukkitEntity().getVehicle()).getDenizenObject();
            }
            return null;
        }, "get_vehicle");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "can_breed", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof Breedable)) {
                return new ElementTag(false);
            }
            return new ElementTag(((Breedable)object.getLivingEntity()).canBreed());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "breeding", (attribute, object) -> {
            if (!(object.getLivingEntity() instanceof Animals)) {
                return null;
            }
            return new ElementTag(((Animals)object.getLivingEntity()).getLoveModeTicks() > 0);
        }, "is_breeding");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "has_passenger", (attribute, object) -> new ElementTag(!object.getBukkitEntity().isEmpty()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_empty", (attribute, object) -> new ElementTag(object.getBukkitEntity().isEmpty()), "empty");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_inside_vehicle", (attribute, object) -> new ElementTag(object.getBukkitEntity().isInsideVehicle()), "inside_vehicle");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_leashed", (attribute, object) -> new ElementTag(object.isLivingEntity() && object.getLivingEntity().isLeashed()), "leashed");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_sheared", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Sheep)) {
                return null;
            }
            return new ElementTag(((Sheep)object.getBukkitEntity()).isSheared());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_on_ground", (attribute, object) -> new ElementTag(object.getBukkitEntity().isOnGround()), "on_ground");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_persistent", (attribute, object) -> new ElementTag(object.isLivingEntity() && !object.getLivingEntity().getRemoveWhenFarAway()), "persistent");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "forced_no_persist", (attribute, object) -> new ElementTag(object.getBukkitEntity().isPersistent()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_collidable", (attribute, object) -> {
            if (object.isCitizensNPC()) {
                return new ElementTag((Boolean)object.getDenizenNPC().getCitizen().data().get(NPC.Metadata.COLLIDABLE, (Object)true));
            }
            return new ElementTag(object.getLivingEntity().isCollidable());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_sleeping", (attribute, object) -> {
            if (object.getBukkitEntity() instanceof Player) {
                return new ElementTag(((Player)object.getBukkitEntity()).isSleeping());
            }
            if (object.getBukkitEntity() instanceof Villager) {
                return new ElementTag(((Villager)object.getBukkitEntity()).isSleeping());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(PlayerTag.class, "killer", (attribute, object) -> EntityTag.getPlayerFrom((Entity)object.getLivingEntity().getKiller()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ObjectTag.class, "last_damage", (attribute, object) -> {
            if (attribute.startsWith("amount", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getLivingEntity().getLastDamage());
            }
            if (attribute.startsWith("cause", 2)) {
                attribute.fulfill(1);
                if (object.getBukkitEntity().getLastDamageCause() == null) {
                    return null;
                }
                return new ElementTag((Enum<?>)object.getBukkitEntity().getLastDamageCause().getCause());
            }
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getNoDamageTicks());
            }
            if (attribute.startsWith("max_duration", 2)) {
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getMaximumNoDamageTicks());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "absorption_health", (attribute, object) -> new ElementTag(object.getLivingEntity().getAbsorptionAmount()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "max_oxygen", (attribute, object) -> new DurationTag((long)object.getLivingEntity().getMaximumAir()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "oxygen", (attribute, object) -> {
            if (attribute.startsWith("max", 2)) {
                BukkitImplDeprecations.entityMaxOxygenTag.warn(attribute.context);
                attribute.fulfill(1);
                return new DurationTag((long)object.getLivingEntity().getMaximumAir());
            }
            return new DurationTag((long)object.getLivingEntity().getRemainingAir());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "remove_when_far", (attribute, object) -> {
            BukkitImplDeprecations.entityRemoveWhenFar.warn(attribute.context);
            return new ElementTag(object.getLivingEntity().getRemoveWhenFarAway());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "target", (attribute, object) -> {
            Entity target;
            if (object.getBukkitEntity() instanceof Creature) {
                LivingEntity target2 = ((Creature)object.getLivingEntity()).getTarget();
                if (target2 != null) {
                    return new EntityTag((Entity)target2).getDenizenObject();
                }
            } else if (object.getBukkitEntity() instanceof ShulkerBullet && (target = ((ShulkerBullet)object.getLivingEntity()).getTarget()) != null) {
                return new EntityTag(target).getDenizenObject();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityFormObject.class, "precise_target", (attribute, object) -> {
            Predicate<Entity> requirement;
            int range = attribute.getIntParam();
            if (range < 1) {
                range = 200;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                String matcher = attribute.getParam();
                requirement = e -> !e.equals(object.getBukkitEntity()) && new EntityTag((Entity)e).tryAdvancedMatcher(matcher);
            } else {
                requirement = e -> !e.equals(object.getBukkitEntity());
            }
            RayTraceResult result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, requirement);
            if (result != null && result.getHitEntity() != null) {
                return new EntityTag(result.getHitEntity()).getDenizenObject();
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "precise_target_position", (attribute, object) -> {
            Predicate<Entity> requirement;
            int range = attribute.getIntParam();
            if (range < 1) {
                range = 200;
            }
            if (attribute.startsWith("type", 2) && attribute.hasContext(2)) {
                attribute.fulfill(1);
                String matcher = attribute.getParam();
                requirement = e -> !e.equals(object.getBukkitEntity()) && new EntityTag((Entity)e).tryAdvancedMatcher(matcher);
            } else {
                requirement = e -> !e.equals(object.getBukkitEntity());
            }
            RayTraceResult result = object.getWorld().rayTrace((Location)object.getEyeLocation(), object.getEyeLocation().getDirection(), (double)range, FluidCollisionMode.NEVER, true, 0.0, requirement);
            if (result != null) {
                return new LocationTag(object.getWorld(), result.getHitPosition());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "time_lived", (attribute, object) -> new DurationTag(object.getBukkitEntity().getTicksLived() / 20), new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "pickup_delay", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof Item)) {
                return null;
            }
            return new DurationTag(((Item)object.getBukkitEntity()).getPickupDelay() * 20);
        }, "pickupdelay");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_in_block", (attribute, object) -> {
            ElementTag elementTag;
            Entity patt88220$temp = object.getBukkitEntity();
            if (patt88220$temp instanceof AbstractArrow) {
                AbstractArrow abstractArrow = (AbstractArrow)patt88220$temp;
                elementTag = new ElementTag(abstractArrow.isInBlock());
            } else {
                elementTag = null;
            }
            return elementTag;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "attached_block", (attribute, object) -> {
            Entity patt88740$temp = object.getBukkitEntity();
            if (patt88740$temp instanceof AbstractArrow) {
                AbstractArrow abstractArrow = (AbstractArrow)patt88740$temp;
                Block attachedBlock = abstractArrow.getAttachedBlock();
                if (attachedBlock != null) {
                    return new LocationTag(attachedBlock.getLocation());
                }
            } else {
                Entity patt89056$temp = object.getBukkitEntity();
                if (patt89056$temp instanceof Hanging) {
                    Hanging hanging = (Hanging)patt89056$temp;
                    Vector dir = hanging.getAttachedFace().getDirection();
                    return new LocationTag(object.getLocation().clone().add(dir.multiply(0.5))).getBlockLocation();
                }
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "gliding", (attribute, object) -> new ElementTag(object.getLivingEntity().isGliding()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "swimming", (attribute, object) -> new ElementTag(object.getLivingEntity().isSwimming()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "visual_pose", (attribute, object) -> new ElementTag((Enum<?>)object.getBukkitEntity().getPose()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "glowing", (attribute, object) -> new ElementTag(object.getBukkitEntity().isGlowing()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_living", (attribute, object) -> new ElementTag(object.isLivingEntityType()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_monster", (attribute, object) -> new ElementTag(object.isMonsterType()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_mob", (attribute, object) -> new ElementTag(object.isMobType()), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_npc", (attribute, object) -> new ElementTag(object.isCitizensNPC()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_player", (attribute, object) -> new ElementTag(object.isPlayer()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_projectile", (attribute, object) -> {
            if (object.getBukkitEntity() == null && object.entity_type != null) {
                return new ElementTag(Projectile.class.isAssignableFrom(object.entity_type.getBukkitEntityType().getEntityClass()));
            }
            return new ElementTag(object.isProjectile());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "tameable", (attribute, object) -> new ElementTag(EntityTame.describes(object)), "is_tameable");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "ageable", (attribute, object) -> new ElementTag(EntityAge.describes(object)), "is_ageable");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "colorable", (attribute, object) -> new ElementTag(EntityColor.describes(object)), "is_colorable");
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "experience", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof ExperienceOrb)) {
                return null;
            }
            return new ElementTag(((ExperienceOrb)object.getBukkitEntity()).getExperience());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fuse_ticks", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof TNTPrimed)) {
                return null;
            }
            return new ElementTag(((TNTPrimed)object.getBukkitEntity()).getFuseTicks());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "dragon_phase", (attribute, object) -> {
            if (!(object.getBukkitEntity() instanceof EnderDragon)) {
                return null;
            }
            return new ElementTag((Enum<?>)((EnderDragon)object.getLivingEntity()).getPhase());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "weapon_damage", (attribute, object) -> {
            Entity target = null;
            if (attribute.hasParam()) {
                target = attribute.paramAsType(EntityTag.class).getBukkitEntity();
            }
            return new ElementTag(NMSHandler.entityHelper.getDamageTo(object.getLivingEntity(), target));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ListTag.class, "skin_layers", (attribute, object) -> {
            byte flags = NMSHandler.playerHelper.getSkinLayers((Player)object.getBukkitEntity());
            ListTag result = new ListTag();
            for (PlayerHelper.SkinLayer layer : PlayerHelper.SkinLayer.values()) {
                if ((flags & layer.flag) == 0) continue;
                result.add(layer.name());
            }
            return result;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_disguised", (attribute, object) -> {
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return new ElementTag(false);
            }
            if (attribute.hasParam()) {
                PlayerTag player = attribute.paramAsType(PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                return new ElementTag(map.containsKey(player.getUUID()) || map.containsKey(null));
            }
            return new ElementTag(map.containsKey(null));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "disguised_type", (attribute, object) -> {
            DisguiseCommand.TrackedDisguise disguise;
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return null;
            }
            if (attribute.hasParam()) {
                PlayerTag player = attribute.paramAsType(PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                disguise = map.get(player.getUUID());
                if (disguise == null) {
                    disguise = map.get(null);
                }
            } else {
                disguise = map.get(null);
            }
            if (disguise == null) {
                return null;
            }
            return disguise.as.duplicate();
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "disguise_to_others", (attribute, object) -> {
            DisguiseCommand.TrackedDisguise disguise;
            HashMap<UUID, DisguiseCommand.TrackedDisguise> map = DisguiseCommand.disguises.get(object.getUUID());
            if (map == null) {
                return null;
            }
            if (attribute.hasParam()) {
                PlayerTag player = attribute.paramAsType(PlayerTag.class);
                if (player == null) {
                    attribute.echoError("Invalid player for is_disguised tag.");
                    return null;
                }
                disguise = map.get(player.getUUID());
                if (disguise == null) {
                    disguise = map.get(null);
                }
            } else {
                disguise = map.get(null);
            }
            if (disguise == null) {
                return null;
            }
            if (disguise.toOthers == null) {
                return null;
            }
            return disguise.toOthers.entity;
        }, new String[0]);
        tagProcessor.registerTag(EntityTag.class, "describe", (attribute, object) -> object.describe(attribute.context), new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "has_equipped", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            if (!object.isLivingEntity()) {
                return null;
            }
            String matcher = attribute.getParam();
            for (ItemStack item : object.getLivingEntity().getEquipment().getArmorContents()) {
                if (!new ItemTag(item).tryAdvancedMatcher(matcher)) continue;
                return new ElementTag(true);
            }
            return new ElementTag(false);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "loot_table_id", (attribute, object) -> {
            Lootable lootable;
            LootTable table;
            Entity patt106030$temp = object.getBukkitEntity();
            if (patt106030$temp instanceof Lootable && (table = (lootable = (Lootable)patt106030$temp).getLootTable()) != null) {
                return new ElementTag(table.getKey().toString());
            }
            return null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fish_hook_state", (attribute, object) -> {
            Entity patt106751$temp = object.getBukkitEntity();
            if (!(patt106751$temp instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_state is only valid for fish hooks.");
                return null;
            }
            FishHook fishHook = (FishHook)patt106751$temp;
            return new ElementTag((Enum<?>)fishHook.getState());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fish_hook_lure_time", (attribute, object) -> {
            Entity patt107423$temp = object.getBukkitEntity();
            if (!(patt107423$temp instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_lure_time is only valid for fish hooks.");
                return null;
            }
            FishHook fishHook = (FishHook)patt107423$temp;
            return new DurationTag((long)NMSHandler.fishingHelper.getLureTime(fishHook));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fish_hook_min_lure_time", (attribute, object) -> {
            Entity patt108152$temp = object.getBukkitEntity();
            if (!(patt108152$temp instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_min_lure_time is only valid for fish hooks.");
                return null;
            }
            FishHook fishHook = (FishHook)patt108152$temp;
            return new DurationTag((long)fishHook.getMinWaitTime());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "fish_hook_max_lure_time", (attribute, object) -> {
            Entity patt108865$temp = object.getBukkitEntity();
            if (!(patt108865$temp instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_max_lure_time is only valid for fish hooks.");
                return null;
            }
            FishHook fishHook = (FishHook)patt108865$temp;
            return new DurationTag((long)fishHook.getMaxWaitTime());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "fish_hook_hooked_entity", (attribute, object) -> {
            Entity patt109550$temp = object.getBukkitEntity();
            if (!(patt109550$temp instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_hooked_entity is only valid for fish hooks.");
                return null;
            }
            FishHook fishHook = (FishHook)patt109550$temp;
            Entity entity = fishHook.getHookedEntity();
            return entity != null ? new EntityTag(entity) : null;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fish_hook_apply_lure", (attribute, object) -> {
            Entity patt110384$temp = object.getBukkitEntity();
            if (!(patt110384$temp instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_apply_lure is only valid for fish hooks.");
                return null;
            }
            FishHook fishHook = (FishHook)patt110384$temp;
            return new ElementTag(fishHook.getApplyLure());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "fish_hook_in_open_water", (attribute, object) -> {
            Entity patt111130$temp = object.getBukkitEntity();
            if (!(patt111130$temp instanceof FishHook)) {
                attribute.echoError("EntityTag.fish_hook_in_open_water is only valid for fish hooks.");
                return null;
            }
            FishHook fishHook = (FishHook)patt111130$temp;
            return new ElementTag(fishHook.isInOpenWater());
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ListTag.class, "attached_entities", (attribute, object) -> {
            PlayerTag player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : null;
            EntityAttachmentHelper.EntityAttachedToMap data = EntityAttachmentHelper.toEntityToData.get(object.getUUID());
            ListTag result = new ListTag();
            if (data == null) {
                return result;
            }
            for (EntityAttachmentHelper.PlayerAttachMap map : data.attachedToMap.values()) {
                if (player != null && map.getAttachment(player.getUUID()) == null) continue;
                result.addObject(map.attached);
            }
            return result;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(EntityTag.class, "attached_to", (attribute, object) -> {
            PlayerTag player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : null;
            EntityAttachmentHelper.PlayerAttachMap data = EntityAttachmentHelper.attachedEntityToData.get(object.getUUID());
            if (data == null) {
                return null;
            }
            EntityAttachmentHelper.AttachmentData attached = data.getAttachment(player == null ? null : player.getUUID());
            if (attached == null) {
                return null;
            }
            return attached.to;
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(LocationTag.class, "attached_offset", (attribute, object) -> {
            PlayerTag player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : null;
            EntityAttachmentHelper.PlayerAttachMap data = EntityAttachmentHelper.attachedEntityToData.get(object.getUUID());
            if (data == null) {
                return null;
            }
            EntityAttachmentHelper.AttachmentData attached = data.getAttachment(player == null ? null : player.getUUID());
            if (attached == null) {
                return null;
            }
            return attached.positionalOffset == null ? null : new LocationTag(attached.positionalOffset);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "attack_cooldown_duration", (attribute, object) -> {
            Entity patt115233$temp = object.getBukkitEntity();
            if (!(patt115233$temp instanceof Player)) {
                attribute.echoError("Only player-type entities can have attack_cooldowns!");
                return null;
            }
            Player player = (Player)patt115233$temp;
            return new DurationTag((long)NMSHandler.playerHelper.ticksPassedDuringCooldown(player));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(DurationTag.class, "attack_cooldown_max_duration", (attribute, object) -> {
            Entity patt116177$temp = object.getBukkitEntity();
            if (!(patt116177$temp instanceof Player)) {
                attribute.echoError("Only player-type entities can have attack_cooldowns!");
                return null;
            }
            Player player = (Player)patt116177$temp;
            return new DurationTag((long)NMSHandler.playerHelper.getMaxAttackCooldownTicks(player));
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "attack_cooldown_percent", (attribute, object) -> {
            Entity patt117095$temp = object.getBukkitEntity();
            if (!(patt117095$temp instanceof Player)) {
                attribute.echoError("Only player-type entities can have attack_cooldowns!");
                return null;
            }
            Player player = (Player)patt117095$temp;
            return new ElementTag(player.getAttackCooldown() * 100.0f);
        }, new String[0]);
        EntityTag.registerSpawnedOnlyTag(ElementTag.class, "is_hand_raised", (attribute, object) -> {
            Entity patt117873$temp = object.getBukkitEntity();
            if (!(patt117873$temp instanceof HumanEntity)) {
                attribute.echoError("Only player-type entities can have is_hand_raised!");
                return null;
            }
            HumanEntity humanEntity = (HumanEntity)patt117873$temp;
            return new ElementTag(humanEntity.isHandRaised());
        }, new String[0]);
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
            EntityTag.registerSpawnedOnlyTag(MapTag.class, "last_attack", (attribute, object) -> {
                Entity patt119053$temp = object.getBukkitEntity();
                if (!(patt119053$temp instanceof Interaction)) {
                    attribute.echoError("'EntityTag.last_attack' is only valid for interaction entities.");
                    return null;
                }
                Interaction interaction = (Interaction)patt119053$temp;
                return MultiVersionHelper1_19.interactionToMap(interaction.getLastAttack(), interaction.getWorld());
            }, new String[0]);
            EntityTag.registerSpawnedOnlyTag(MapTag.class, "last_interaction", (attribute, object) -> {
                Entity patt120261$temp = object.getBukkitEntity();
                if (!(patt120261$temp instanceof Interaction)) {
                    attribute.echoError("'EntityTag.last_interaction' is only valid for interaction entities.");
                    return null;
                }
                Interaction interaction = (Interaction)patt120261$temp;
                return MultiVersionHelper1_19.interactionToMap(interaction.getLastInteraction(), interaction.getWorld());
            }, new String[0]);
        }
        EntityTag.registerSpawnedOnlyMechanism("alter_uuid", false, ElementTag.class, (object, mechanism, new_id) -> {
            try {
                UUID id = UUID.fromString(new_id.asString());
                NMSHandler.entityHelper.setUUID(object.getBukkitEntity(), id);
            }
            catch (IllegalArgumentException ex) {
                mechanism.echoError("Cannot parse UUID input '" + new_id + "': " + ex.getMessage());
            }
        });
        EntityTag.registerSpawnedOnlyMechanism("visual_pose", false, ElementTag.class, (object, mechanism, input) -> {
            if (mechanism.requireEnum(Pose.class)) {
                NMSHandler.entityHelper.setPose(object.getBukkitEntity(), input.asEnum(Pose.class));
            }
        });
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
            tagProcessor.registerMechanism("start_using_hand", false, (object, mechanism) -> {
                EquipmentSlot hand;
                if (!object.isLivingEntity()) {
                    mechanism.echoError("The 'start_using_hand' mechanism only works for living entities!");
                    return;
                }
                EquipmentSlot equipmentSlot = hand = mechanism.hasValue() ? mechanism.getValue().asEnum(EquipmentSlot.class) : EquipmentSlot.HAND;
                if (hand != EquipmentSlot.HAND && hand != EquipmentSlot.OFF_HAND) {
                    mechanism.echoError("Invalid equipment slot '" + mechanism.getValue() + "' specified: must be HAND or OFF_HAND.");
                    return;
                }
                NMSHandler.entityHelper.startUsingItem(object.getLivingEntity(), hand);
            }, new String[0]);
            tagProcessor.registerMechanism("stop_using_hand", false, (object, mechanism) -> {
                if (!object.isLivingEntity()) {
                    mechanism.echoError("The 'stop_using_hand' mechanism only works for living entities!");
                    return;
                }
                NMSHandler.entityHelper.stopUsingItem(object.getLivingEntity());
            }, new String[0]);
            EntityTag.registerSpawnedOnlyMechanism("play_hurt_animation", false, ElementTag.class, (object, mechanism, value) -> {
                if (mechanism.requireFloat()) {
                    if (!object.isLivingEntity()) {
                        mechanism.echoError("The 'play_hurt_animation' mechanism only works for living entities!");
                        return;
                    }
                    object.getLivingEntity().playHurtAnimation(value.asFloat());
                }
            });
            tagProcessor.registerMechanism("internal_data", false, MapTag.class, (object, mechanism, input) -> NMSHandler.entityHelper.modifyInternalEntityData(object.getBukkitEntity(), (MapTag)input), new String[0]);
            EntityTag.registerSpawnedOnlyTag(ElementTag.class, "bookshelf_slot", (attribute, object) -> {
                RayTraceResult result = object.getLivingEntity().rayTraceBlocks(4.5);
                if (result == null || result.getHitBlock().getType() != Material.CHISELED_BOOKSHELF) {
                    attribute.echoError("'EntityTag.bookshelf_slot' requires the entity to look at a Chiseled Bookshelf block.");
                    return null;
                }
                ChiseledBookshelf bookshelfState = (ChiseledBookshelf)result.getHitBlock().getState();
                Vector vector = result.getHitPosition().subtract(result.getHitBlock().getLocation().toVector());
                return new ElementTag(bookshelfState.getSlot(vector) + 1);
            }, new String[0]);
        }
    }

    public EntityTag describe(TagContext context) {
        ArrayList<Mechanism> waitingMechs;
        if (this.isSpawnedOrValidForTag()) {
            waitingMechs = new ArrayList();
            for (Map.Entry<StringHolder, ObjectTag> property : PropertyParser.getPropertiesMap(this).entrySet()) {
                waitingMechs.add(new Mechanism(property.getKey().str, property.getValue(), context));
            }
        } else {
            waitingMechs = new ArrayList<Mechanism>(this.getWaitingMechanisms());
        }
        EntityTag entity = new EntityTag(this.entity_type, waitingMechs);
        entity.entityScript = this.entityScript;
        return entity;
    }

    public static <R extends ObjectTag> void registerSpawnedOnlyTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<EntityTag, R> runnable, String ... variants) {
        tagProcessor.registerTag(returnType, name, (attribute, object) -> {
            if (!object.isSpawnedOrValidForTag()) {
                if (!attribute.hasAlternative()) {
                    attribute.echoError("Entity is not spawned, but tag '" + name + "' requires the entity be spawned, for entity: " + object.debuggable());
                }
                return null;
            }
            return runnable.run(attribute, (EntityTag)object);
        }, variants);
    }

    public static <P extends ObjectTag> void registerSpawnedOnlyMechanism(String name, boolean allowProperty, Class<P> paramType, Mechanism.ObjectInputMechRunnerInterface<EntityTag, P> runner) {
        tagProcessor.registerMechanism(name, allowProperty, paramType, (entity, mechanism, param) -> {
            if (!entity.isSpawned()) {
                mechanism.echoError("Entity is not spawned, but mechanism '" + name + "' requires the entity be spawned, for entity: " + entity.debuggable());
                return;
            }
            runner.run((EntityTag)entity, mechanism, (Object)param);
        }, new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    public ArrayList<Mechanism> getWaitingMechanisms() {
        return this.mechanisms;
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
        } else {
            mechanism.echoError("Cannot apply properties to an already-spawned entity!");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void adjust(Mechanism mechanism) {
        Entity bukkitEnt;
        if (this.isGeneric()) {
            this.mechanisms.add(mechanism);
            mechanism.fulfill();
            return;
        }
        if (this.getBukkitEntity() == null) {
            if (this.isCitizensNPC()) {
                mechanism.echoError("Cannot adjust not-spawned NPC " + this.getDenizenNPC());
            } else {
                mechanism.echoError("Cannot adjust entity " + this);
            }
            return;
        }
        if (mechanism.matches("attach_to")) {
            BukkitImplDeprecations.attachToMech.warn(mechanism.context);
            if (mechanism.hasValue()) {
                void var3_11;
                ListTag list = mechanism.valueAsType(ListTag.class);
                Object var3_9 = null;
                boolean rotateWith = true;
                if (list.size() > 1) {
                    Vector vector = LocationTag.valueOf(list.get(1), mechanism.context).toVector();
                    if (list.size() > 2) {
                        rotateWith = new ElementTag(list.get(2)).asBoolean();
                    }
                }
                EntityAttachmentHelper.forceAttachMove(this, EntityTag.valueOf(list.get(0), mechanism.context), (Vector)var3_11, rotateWith);
            } else {
                EntityAttachmentHelper.forceAttachMove(this, null, null, false);
            }
        }
        if (mechanism.matches("shooter")) {
            this.setShooter(mechanism.valueAsType(EntityTag.class));
        }
        if (mechanism.matches("can_pickup_items") && mechanism.requireBoolean()) {
            this.getLivingEntity().setCanPickupItems(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fall_distance") && mechanism.requireFloat()) {
            this.entity.setFallDistance(mechanism.getValue().asFloat());
        }
        if (mechanism.matches("fallingblock_drop_item") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setDropItem(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fallingblock_hurt_entities") && mechanism.requireBoolean() && this.entity instanceof FallingBlock) {
            ((FallingBlock)this.entity).setHurtEntities(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fire_time") && mechanism.requireObject(DurationTag.class)) {
            this.entity.setFireTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("leash_holder") && mechanism.requireObject(EntityTag.class)) {
            this.getLivingEntity().setLeashHolder(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("can_breed") && mechanism.requireBoolean()) {
            ((Ageable)this.getLivingEntity()).setBreed(true);
        }
        if (mechanism.matches("breed") && mechanism.requireBoolean()) {
            ((Animals)this.getLivingEntity()).setLoveModeTicks(mechanism.getValue().asBoolean() ? 600 : 0);
        }
        if (mechanism.matches("passengers")) {
            this.entity.eject();
            for (EntityTag entityTag : mechanism.valueAsType(ListTag.class).filter(EntityTag.class, mechanism.context)) {
                if (this.comparesTo(entityTag) == 1) continue;
                if (!entityTag.isSpawned()) {
                    entityTag.spawnAt(this.getLocation());
                }
                if (!entityTag.isSpawned()) continue;
                this.entity.addPassenger(entityTag.getBukkitEntity());
            }
        }
        if (mechanism.matches("passenger") && mechanism.requireObject(EntityTag.class)) {
            EntityTag ent3 = mechanism.valueAsType(EntityTag.class);
            if (!ent3.isSpawned()) {
                ent3.spawnAt(this.getLocation());
            }
            this.entity.eject();
            if (ent3.isSpawned()) {
                this.entity.addPassenger(ent3.getBukkitEntity());
            }
        }
        if (mechanism.matches("time_lived") && mechanism.requireObject(DurationTag.class)) {
            NMSHandler.entityHelper.setTicksLived(this.entity, mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("absorption_health") && mechanism.requireFloat()) {
            this.getLivingEntity().setAbsorptionAmount(mechanism.getValue().asDouble());
        }
        if (mechanism.matches("oxygen") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setRemainingAir(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("remove_effects")) {
            for (PotionEffect potionEffect : this.getLivingEntity().getActivePotionEffects()) {
                this.getLivingEntity().removePotionEffect(potionEffect.getType());
            }
        }
        if (mechanism.matches("release_left_shoulder") && this.getLivingEntity() instanceof HumanEntity && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityLeft()) != null) {
            EntityTag entityTag = new EntityTag(bukkitEnt);
            String escript = entityTag.getEntityScript();
            EntityTag entityTag2 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : entityTag.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(entityTag), mechanism.context);
            entityTag2.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
        }
        if (mechanism.matches("release_right_shoulder") && this.getLivingEntity() instanceof HumanEntity && (bukkitEnt = ((HumanEntity)this.getLivingEntity()).getShoulderEntityRight()) != null) {
            EntityTag entityTag = new EntityTag(bukkitEnt);
            String escript = entityTag.getEntityScript();
            EntityTag entityTag3 = EntityTag.valueOf("e@" + (escript != null && escript.length() > 0 ? escript : entityTag.getEntityType().getLowercaseName()) + PropertyParser.getPropertiesString(entityTag), mechanism.context);
            entityTag3.spawnAt(this.getEyeLocation());
            ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
        }
        if (mechanism.matches("left_shoulder") && this.getLivingEntity() instanceof HumanEntity) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityLeft(null);
            }
        }
        if (mechanism.matches("right_shoulder") && this.getLivingEntity() instanceof HumanEntity) {
            if (mechanism.hasValue()) {
                if (mechanism.requireObject(EntityTag.class)) {
                    ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
                }
            } else {
                ((HumanEntity)this.getLivingEntity()).setShoulderEntityRight(null);
            }
        }
        if (mechanism.matches("persistent") && mechanism.requireBoolean()) {
            this.getLivingEntity().setRemoveWhenFarAway(!mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("force_no_persist") && mechanism.requireBoolean()) {
            this.getBukkitEntity().setPersistent(!mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("remove_when_far_away") && mechanism.requireBoolean()) {
            BukkitImplDeprecations.entityRemoveWhenFar.warn(mechanism.context);
            this.getLivingEntity().setRemoveWhenFarAway(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("sheared") && mechanism.requireBoolean() && this.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.getBukkitEntity()).setSheared(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("collidable") && mechanism.requireBoolean()) {
            if (this.isCitizensNPC()) {
                this.getDenizenNPC().getCitizen().data().setPersistent(NPC.Metadata.COLLIDABLE, (Object)mechanism.getValue().asBoolean());
            } else {
                this.getLivingEntity().setCollidable(mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("max_no_damage_duration") && mechanism.requireObject(DurationTag.class)) {
            this.getLivingEntity().setMaximumNoDamageTicks(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("velocity") && mechanism.requireObject(LocationTag.class)) {
            this.setVelocity(mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("move") && mechanism.requireObject(LocationTag.class)) {
            NMSHandler.entityHelper.move(this.getBukkitEntity(), mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("fake_move") && mechanism.requireObject(LocationTag.class)) {
            NMSHandler.entityHelper.fakeMove(this.getBukkitEntity(), mechanism.valueAsType(LocationTag.class).toVector());
        }
        if (mechanism.matches("fake_teleport") && mechanism.requireObject(LocationTag.class)) {
            NMSHandler.entityHelper.fakeTeleport(this.getBukkitEntity(), mechanism.valueAsType(LocationTag.class));
        }
        if (mechanism.matches("reset_client_location")) {
            NMSHandler.entityHelper.clientResetLoc(this.getBukkitEntity());
        }
        if (mechanism.matches("send_update_packets")) {
            NMSHandler.entityHelper.sendAllUpdatePackets(this.getBukkitEntity());
        }
        if (mechanism.matches("interact_with") && mechanism.requireObject(LocationTag.class)) {
            LocationTag interactLocation = mechanism.valueAsType(LocationTag.class);
            NMSHandler.entityHelper.forceInteraction(this.getPlayer(), interactLocation);
        }
        if (mechanism.matches("play_death")) {
            BukkitImplDeprecations.entityPlayDeath.warn(mechanism.context);
            this.getLivingEntity().playEffect(EntityEffect.DEATH);
        }
        if ((mechanism.matches("pickup_delay") || mechanism.matches("pickupdelay")) && this.getBukkitEntity() instanceof Item && mechanism.requireObject(DurationTag.class)) {
            ((Item)this.getBukkitEntity()).setPickupDelay(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("gliding") && mechanism.requireBoolean()) {
            this.getLivingEntity().setGliding(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("glowing") && mechanism.requireBoolean()) {
            this.getBukkitEntity().setGlowing(mechanism.getValue().asBoolean());
            if (Depends.citizens != null && CitizensAPI.getNPCRegistry().isNPC((Entity)this.getLivingEntity())) {
                CitizensAPI.getNPCRegistry().getNPC((Entity)this.getLivingEntity()).data().setPersistent(NPC.Metadata.GLOWING, (Object)mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("dragon_phase")) {
            EnderDragon ed = (EnderDragon)this.getLivingEntity();
            ed.setPhase(EnderDragon.Phase.valueOf((String)mechanism.getValue().asString().toUpperCase()));
        }
        if (mechanism.matches("experience") && this.getBukkitEntity() instanceof ExperienceOrb && mechanism.requireInteger()) {
            ((ExperienceOrb)this.getBukkitEntity()).setExperience(mechanism.getValue().asInt());
        }
        if (mechanism.matches("fuse_ticks") && this.getBukkitEntity() instanceof TNTPrimed && mechanism.requireInteger()) {
            ((TNTPrimed)this.getBukkitEntity()).setFuseTicks(mechanism.getValue().asInt());
        }
        if (mechanism.matches("show_to_players")) {
            HideEntitiesHelper.unhideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("hide_from_players")) {
            HideEntitiesHelper.hideEntity(null, this.getBukkitEntity());
        }
        if (mechanism.matches("skin_layers")) {
            int flags = 0;
            for (String str : mechanism.valueAsType(ListTag.class)) {
                String upper = str.toUpperCase();
                if (upper.equals("ALL")) {
                    flags = 255;
                    continue;
                }
                PlayerHelper.SkinLayer layer = PlayerHelper.SkinLayer.valueOf(upper);
                flags |= layer.flag;
            }
            NMSHandler.playerHelper.setSkinLayers((Player)this.getBukkitEntity(), (byte)flags);
        }
        if (mechanism.matches("mirror_player") && mechanism.requireBoolean()) {
            if (this.isNPC()) {
                MirrorTrait mirror = (MirrorTrait)this.getDenizenNPC().getCitizen().getOrAddTrait(MirrorTrait.class);
                if (mechanism.getValue().asBoolean()) {
                    mirror.enableMirror();
                } else {
                    mirror.disableMirror();
                }
            } else if (mechanism.getValue().asBoolean()) {
                ProfileEditor.mirrorUUIDs.add(this.getUUID());
            } else {
                ProfileEditor.mirrorUUIDs.remove(this.getUUID());
            }
        }
        if (mechanism.matches("swimming") && mechanism.requireBoolean()) {
            this.getLivingEntity().setSwimming(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("detonate")) {
            if (this.getBukkitEntity() instanceof Firework) {
                ((Firework)this.getBukkitEntity()).detonate();
            } else if (this.getBukkitEntity() instanceof Creeper) {
                ((Creeper)this.getBukkitEntity()).explode();
            } else {
                Debug.echoError("Cannot detonate entity of type '" + this.getBukkitEntityType().name() + "'.");
            }
        }
        if (mechanism.matches("ignite")) {
            if (this.getBukkitEntity() instanceof Creeper) {
                ((Creeper)this.getBukkitEntity()).ignite();
            } else {
                Debug.echoError("Cannot ignite entity of type '" + this.getBukkitEntityType().name() + "'.");
            }
        }
        if (mechanism.matches("head_angle") && mechanism.requireFloat()) {
            NMSHandler.entityHelper.setHeadAngle(this.getLivingEntity(), mechanism.getValue().asFloat());
        }
        if (mechanism.matches("skeleton_arms_raised") && mechanism.requireBoolean()) {
            BukkitImplDeprecations.entitySkeletonArmsRaised.warn(mechanism.context);
            if (this.getBukkitEntityType() == EntityType.SKELETON) {
                NMSHandler.entityHelper.setAggressive((Mob)this.getBukkitEntity(), mechanism.getValue().asBoolean());
            }
        }
        if (mechanism.matches("polar_bear_standing") && mechanism.requireBoolean()) {
            EntityAnimation entityAnimation = NMSHandler.animationHelper.getEntityAnimation(mechanism.getValue().asBoolean() ? "POLAR_BEAR_START_STANDING" : "POLAR_BEAR_STOP_STANDING");
            entityAnimation.play(this.entity);
        }
        if (mechanism.matches("ghast_attacking") && mechanism.requireBoolean()) {
            NMSHandler.entityHelper.setGhastAttacking((Ghast)this.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("enderman_angry") && mechanism.requireBoolean()) {
            NMSHandler.entityHelper.setEndermanAngry((Enderman)this.getBukkitEntity(), mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("melee_attack") && mechanism.requireObject(EntityTag.class)) {
            this.getLivingEntity().attack(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("last_hurt_by") && mechanism.requireObject(EntityTag.class)) {
            NMSHandler.entityHelper.setLastHurtBy(this.getLivingEntity(), mechanism.valueAsType(EntityTag.class).getLivingEntity());
        }
        if (mechanism.matches("fish_hook_nibble_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_nibble_time is only valid for FishHook entities.");
                return;
            }
            NMSHandler.fishingHelper.setNibble((FishHook)this.getBukkitEntity(), mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_bite_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_hook_time is only valid for FishHook entities.");
                return;
            }
            NMSHandler.fishingHelper.setHookTime((FishHook)this.getBukkitEntity(), mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_lure_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_lure_time is only valid for FishHook entities.");
                return;
            }
            NMSHandler.fishingHelper.setLureTime((FishHook)this.getBukkitEntity(), mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_pull")) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_pull is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).pullHookedEntity();
        }
        if (mechanism.matches("fish_hook_apply_lure") && mechanism.requireBoolean()) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_apply_lure is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setApplyLure(mechanism.getValue().asBoolean());
        }
        if (mechanism.matches("fish_hook_hooked_entity") && mechanism.requireObject(EntityTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_hooked_entity is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setHookedEntity(mechanism.valueAsType(EntityTag.class).getBukkitEntity());
        }
        if (mechanism.matches("fish_hook_min_lure_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_min_lure_time is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setMinWaitTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("fish_hook_max_lure_time") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getBukkitEntity() instanceof FishHook)) {
                mechanism.echoError("fish_hook_max_lure_time is only valid for FishHook entities.");
                return;
            }
            ((FishHook)this.getBukkitEntity()).setMaxWaitTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
        }
        if (mechanism.matches("redo_attack_cooldown")) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            NMSHandler.playerHelper.setAttackCooldown((Player)this.getLivingEntity(), 0);
        }
        if (mechanism.matches("reset_attack_cooldown")) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            NMSHandler.playerHelper.setAttackCooldown((Player)this.getLivingEntity(), Math.round(NMSHandler.playerHelper.getMaxAttackCooldownTicks((Player)this.getLivingEntity())));
        }
        if (mechanism.matches("attack_cooldown_percent") && mechanism.requireFloat()) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            float percent = mechanism.getValue().asFloat();
            if (percent >= 0.0f && percent <= 1.0f) {
                NMSHandler.playerHelper.setAttackCooldown((Player)this.getLivingEntity(), Math.round(NMSHandler.playerHelper.getMaxAttackCooldownTicks((Player)this.getLivingEntity()) * mechanism.getValue().asFloat()));
            } else {
                Debug.echoError("Invalid percentage! \"" + percent + "\" is not between 0 and 1!");
            }
        }
        if (mechanism.matches("attack_cooldown") && mechanism.requireObject(DurationTag.class)) {
            if (!(this.getLivingEntity() instanceof Player)) {
                mechanism.echoError("Only player-type entities can have attack_cooldowns!");
                return;
            }
            NMSHandler.playerHelper.setAttackCooldown((Player)this.getLivingEntity(), mechanism.getValue().asType(DurationTag.class, mechanism.context).getTicksAsInt());
        }
        if (mechanism.matches("fallingblock_type") && mechanism.requireObject(MaterialTag.class)) {
            if (!(this.getBukkitEntity() instanceof FallingBlock)) {
                mechanism.echoError("'fallingblock_type' is only valid for Falling Block entities.");
                return;
            }
            NMSHandler.entityHelper.setFallingBlockType((FallingBlock)this.getBukkitEntity(), mechanism.valueAsType(MaterialTag.class).getModernData());
        }
        if (mechanism.matches("tracking_range") && mechanism.requireInteger()) {
            NMSHandler.entityHelper.setTrackingRange(this.getBukkitEntity(), mechanism.getValue().asInt());
        }
        if (mechanism.matches("fake_pickup") && mechanism.requireObject(EntityTag.class)) {
            int n;
            Entity ent4 = mechanism.valueAsType(EntityTag.class).getBukkitEntity();
            boolean bl = true;
            if (ent4 instanceof Item) {
                n = ((Item)ent4).getItemStack().getAmount();
            }
            for (Player player : NMSHandler.entityHelper.getPlayersThatSee(this.getBukkitEntity())) {
                NMSHandler.packetHelper.sendCollectItemEntity(player, this.getBukkitEntity(), ent4, n);
            }
            if (this.isPlayer()) {
                NMSHandler.packetHelper.sendCollectItemEntity((Player)this.getBukkitEntity(), this.getBukkitEntity(), ent4, n);
            }
        }
        if (mechanism.matches("loot_table_id")) {
            if (!(this.getBukkitEntity() instanceof Lootable)) {
                mechanism.echoError("'loot_table_id' is only valid for lootable entities.");
                return;
            }
            LootTable table = Bukkit.getLootTable((NamespacedKey)Utilities.parseNamespacedKey(mechanism.getValue().asString()));
            if (table == null) {
                mechanism.echoError("Invalid loot table ID.");
                return;
            }
            ((Lootable)this.getBukkitEntity()).setLootTable(table);
        }
        tagProcessor.processMechanism(this, mechanism);
    }

    public final boolean trySpecialEntityMatcher(String text, boolean isNPC) {
        if (isNPC) {
            return text.equals("entity") || text.equals("npc");
        }
        switch (text) {
            case "entity": {
                return true;
            }
            case "npc": {
                return this.isCitizensNPC();
            }
            case "player": {
                return this.isPlayer();
            }
            case "living": {
                return this.isLivingEntityType();
            }
            case "vehicle": {
                return this.getBukkitEntity() instanceof Vehicle;
            }
            case "fish": {
                return this.getBukkitEntity() instanceof Fish;
            }
            case "projectile": {
                return this.getBukkitEntity() instanceof Projectile;
            }
            case "hanging": {
                return this.getBukkitEntity() instanceof Hanging;
            }
            case "monster": {
                return this.isMonsterType();
            }
            case "mob": {
                return this.isMobType();
            }
            case "animal": {
                return this.isAnimalType();
            }
        }
        return false;
    }

    public final boolean tryExactMatcher(String text) {
        if (specialEntityMatchables.contains(text)) {
            return this.trySpecialEntityMatcher(text, this.isCitizensNPC());
        }
        if (text.startsWith("npc_") && !text.startsWith("npc_flagged")) {
            String check = text.substring("npc_".length());
            if (specialEntityMatchables.contains(check)) {
                if (check.equals("player")) {
                    return this.npc.getEntityType() == EntityType.PLAYER;
                }
                return this.trySpecialEntityMatcher(check, false);
            }
            return check.equals(CoreUtilities.toLowerCase(this.npc.getEntityType().name()));
        }
        if (text.contains(":")) {
            if (text.startsWith("entity_flagged:")) {
                return ScriptEvent.coreFlaggedCheck(text.substring("entity_flagged:".length()), this.getFlagTracker());
            }
            if (text.startsWith("player_flagged:")) {
                return this.isPlayer() && ScriptEvent.coreFlaggedCheck(text.substring("player_flagged:".length()), this.getFlagTracker());
            }
            if (text.startsWith("npc_flagged:")) {
                return this.isCitizensNPC() && ScriptEvent.coreFlaggedCheck(text.substring("npc_flagged:".length()), this.getFlagTracker());
            }
            if (text.startsWith("vanilla_tagged:")) {
                String tagCheck = text.substring("vanilla_tagged:".length());
                HashSet<String> tags = VanillaTagHelper.tagsByEntity.get(this.getBukkitEntityType());
                if (tags == null) {
                    return false;
                }
                ScriptEvent.MatchHelper matcher = ScriptEvent.createMatcher(tagCheck);
                for (String tag : tags) {
                    if (!matcher.doesMatch(tag)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean advancedMatches(String text) {
        ScriptEvent.MatchHelper matcher = ScriptEvent.createMatcher(text);
        if (this.isCitizensNPC()) {
            return matcher.doesMatch("npc", this::tryExactMatcher);
        }
        if (this.getEntityScript() != null && matcher.doesMatch(this.getEntityScript(), this::tryExactMatcher)) {
            return true;
        }
        return matcher.doesMatch(this.getEntityType().getLowercaseName(), this::tryExactMatcher);
    }
}

