/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgNoDebug;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgRaw;
import com.denizenscript.denizencore.scripts.commands.generator.ArgUnparsed;
import com.denizenscript.denizencore.scripts.commands.queue.IfCommand;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.RepeatingSchedulable;
import java.util.ArrayList;
import java.util.List;

public class WaitUntilCommand
extends AbstractCommand
implements Holdable {
    public WaitUntilCommand() {
        this.setName("waituntil");
        this.setSyntax("waituntil (rate:<duration>) (max:<duration>) [<comparisons>]");
        this.setRequiredArguments(1, -1);
        this.forceHold = true;
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(final ScriptEntry scriptEntry, ScriptQueue origQueue, final @ArgUnparsed @ArgNoDebug @ArgRaw @ArgLinear @ArgName(value="if_comparisons") List<ScriptEntry.InternalArgument> comparisons, @ArgPrefixed @ArgName(value="rate") @ArgDefaultNull DurationTag rate, @ArgPrefixed @ArgName(value="max") @ArgDefaultNull DurationTag max) {
        boolean run = new IfCommand.ArgComparer().compare(new ArrayList<ScriptEntry.InternalArgument>(comparisons), scriptEntry);
        if (run) {
            Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil first check already <A>true<W>, not waiting.");
            scriptEntry.setFinished(true);
            return;
        }
        Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil first check <A>false<W>, will wait...");
        if (rate == null) {
            rate = origQueue instanceof TimedQueue ? ((TimedQueue)origQueue).getSpeed() : new DurationTag(1L);
        }
        if (!(origQueue instanceof TimedQueue)) {
            origQueue = origQueue.forceToTimed(null);
        }
        final long endTime = max == null ? -1L : DenizenCore.serverTimeMillis + max.getMillis();
        final RepeatingSchedulable schedulable = new RepeatingSchedulable(null, (float)rate.getSeconds());
        final ScriptQueue queue = origQueue;
        schedulable.run = new Runnable(){
            public int counter = 0;

            @Override
            public void run() {
                ++this.counter;
                if (CoreConfiguration.debugVerbose) {
                    Debug.log("WaitUntil looping: " + this.counter);
                }
                if (queue.getEntries().isEmpty()) {
                    Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil stopping early: queue is empty or was externally stopped.");
                    scriptEntry.setFinished(true);
                    schedulable.cancel();
                }
                if (new IfCommand.ArgComparer().compare(new ArrayList(comparisons), scriptEntry)) {
                    Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil completed after <A>" + this.counter + "<W> re-checks.");
                    scriptEntry.setFinished(true);
                    schedulable.cancel();
                } else if (endTime != -1L && endTime <= DenizenCore.serverTimeMillis) {
                    Debug.echoDebug((Debuggable)scriptEntry, "WaitUntil stopping early due to time out.");
                    scriptEntry.setFinished(true);
                    schedulable.cancel();
                }
            }
        };
        DenizenCore.schedule(schedulable);
    }
}

