/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class InvisibleTrait
extends Trait
implements Listener,
Toggleable {
    @Persist(value="")
    private boolean invisible = true;
    private static PotionEffect invis = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false);

    public InvisibleTrait() {
        super("invisible");
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof LivingEntity) {
            InvisibleTrait.setInvisible((LivingEntity)this.npc.getEntity(), this.npc, invisible);
        }
    }

    public static void setInvisible(LivingEntity ent, NPC npc, boolean invisible) {
        if (invisible) {
            InvisibleTrait.setInvisible(ent, npc);
        } else {
            InvisibleTrait.setVisible(ent, npc);
        }
    }

    public static void setVisible(LivingEntity ent, NPC npc) {
        if (ent.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            ent.removePotionEffect(PotionEffectType.INVISIBILITY);
        }
        if (ent.getType() == EntityType.ARMOR_STAND) {
            ((ArmorStand)ent).setVisible(true);
            if (npc != null) {
                ((ArmorStandTrait)npc.getOrAddTrait(ArmorStandTrait.class)).setVisible(true);
            }
        }
    }

    public static void setInvisible(LivingEntity ent, NPC npc) {
        if (npc != null && ent.getType() == EntityType.PLAYER) {
            npc.data().setPersistent("removefromplayerlist", (Object)false);
            NMS.addOrRemoveFromPlayerList((Entity)ent, (boolean)false);
        }
        if (ent.getType() == EntityType.ARMOR_STAND) {
            ((ArmorStand)ent).setVisible(false);
            if (npc != null) {
                ((ArmorStandTrait)npc.getOrAddTrait(ArmorStandTrait.class)).setVisible(false);
            }
        } else {
            invis.apply(ent);
        }
    }

    private void setInvisible() {
        if (this.invisible && this.npc.isSpawned() && this.npc.getEntity() instanceof LivingEntity) {
            InvisibleTrait.setInvisible((LivingEntity)this.npc.getEntity(), this.npc);
        }
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void onSpawn() {
        if (this.invisible) {
            this.setInvisible();
            if (!this.npc.isSpawned()) {
                new BukkitRunnable(){
                    int ticks = 0;

                    public void run() {
                        if (this.ticks++ > 80) {
                            return;
                        }
                        if (InvisibleTrait.this.npc.isSpawned()) {
                            InvisibleTrait.this.setInvisible();
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
            }
        }
    }

    public boolean toggle() {
        this.setInvisible(!this.invisible);
        return this.invisible;
    }

    public void onRemove() {
        this.setInvisible(false);
    }

    public void onAttach() {
        this.setInvisible(this.invisible);
    }
}

