/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.entity.EntityAttributeModifiers;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemAttributeModifiers
extends ItemProperty<MapTag> {
    public static boolean describes(ItemTag item) {
        return true;
    }

    @Override
    public boolean isDefaultValue(MapTag map) {
        return map.isEmpty();
    }

    @Override
    public MapTag getPropertyValue() {
        ItemMeta meta = this.getItemMeta();
        if (meta == null) {
            return null;
        }
        Multimap metaMap = meta.getAttributeModifiers();
        return ItemAttributeModifiers.getAttributeModifiersFor((Multimap<Attribute, AttributeModifier>)metaMap);
    }

    @Override
    public void setPropertyValue(MapTag param, Mechanism mechanism) {
        LinkedHashMultimap metaMap = LinkedHashMultimap.create();
        for (Map.Entry<StringHolder, ObjectTag> mapEntry : param.entrySet()) {
            Attribute attr = Attribute.valueOf((String)mapEntry.getKey().str.toUpperCase());
            for (ObjectTag listValue : CoreUtilities.objectToList(mapEntry.getValue(), mechanism.context)) {
                metaMap.put((Object)attr, (Object)EntityAttributeModifiers.modiferForMap(attr, (MapTag)listValue));
            }
        }
        ItemMeta meta = this.getItemMeta();
        meta.setAttributeModifiers((Multimap)metaMap);
        this.setItemMeta(meta);
    }

    @Override
    public String getPropertyId() {
        return "attribute_modifiers";
    }

    public static MapTag getAttributeModifiersFor(Multimap<Attribute, AttributeModifier> metaMap) {
        MapTag map = new MapTag();
        if (metaMap == null) {
            return map;
        }
        for (Attribute attribute : metaMap.keys()) {
            Collection modifiers = metaMap.get((Object)attribute);
            if (modifiers.isEmpty()) continue;
            ListTag subList = new ListTag();
            for (AttributeModifier modifier : modifiers) {
                subList.addObject(EntityAttributeModifiers.mapify(modifier));
            }
            map.putObject(attribute.name(), (ObjectTag)subList);
        }
        return map;
    }

    public static void register() {
        ItemAttributeModifiers.autoRegister("attribute_modifiers", ItemAttributeModifiers.class, MapTag.class, false, new String[0]);
        PropertyParser.registerTag(ItemAttributeModifiers.class, MapTag.class, "default_attribute_modifiers", (attribute, prop) -> {
            if (!attribute.hasParam() || !NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                return null;
            }
            EquipmentSlot slot = attribute.getParamElement().asEnum(EquipmentSlot.class);
            if (slot == null) {
                attribute.echoError("Invalid slot specified: " + attribute.getParam());
                return null;
            }
            return ItemAttributeModifiers.getAttributeModifiersFor((Multimap<Attribute, AttributeModifier>)prop.getMaterial().getDefaultAttributeModifiers(slot));
        }, new String[0]);
        PropertyParser.registerMechanism(ItemAttributeModifiers.class, MapTag.class, "add_attribute_modifiers", (prop, mechanism, param) -> {
            ItemMeta meta = prop.getItemMeta();
            for (Map.Entry<StringHolder, ObjectTag> subValue : param.entrySet()) {
                Attribute attr = Attribute.valueOf((String)subValue.getKey().str.toUpperCase());
                for (ObjectTag listValue : CoreUtilities.objectToList(subValue.getValue(), mechanism.context)) {
                    meta.addAttributeModifier(attr, EntityAttributeModifiers.modiferForMap(attr, (MapTag)listValue));
                }
            }
            prop.setItemMeta(meta);
        }, new String[0]);
        PropertyParser.registerMechanism(ItemAttributeModifiers.class, ListTag.class, "remove_attribute_modifiers", (prop, mechanism, param) -> {
            ItemMeta meta = prop.getItemMeta();
            ArrayList<String> inputList = new ArrayList<String>((Collection<String>)((Object)param));
            for (String toRemove : new ArrayList<String>(inputList)) {
                if (!new ElementTag(toRemove).matchesEnum(Attribute.class)) continue;
                inputList.remove(toRemove);
                Attribute attr = Attribute.valueOf((String)toRemove.toUpperCase());
                meta.removeAttributeModifier(attr);
            }
            for (String toRemove : inputList) {
                UUID id = UUID.fromString(toRemove);
                Multimap metaMap = meta.getAttributeModifiers();
                block2: for (Attribute attribute : metaMap.keys()) {
                    for (AttributeModifier modifer : metaMap.get((Object)attribute)) {
                        if (!modifer.getUniqueId().equals(id)) continue;
                        meta.removeAttributeModifier(attribute, modifer);
                        continue block2;
                    }
                }
            }
            prop.setItemMeta(meta);
        }, new String[0]);
    }
}

