/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionRefuse;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;

@ReflectionRefuse
public class SecretTag
implements ObjectTag {
    @ReflectionRefuse
    public static YamlConfiguration secretsFile;
    public String key;
    private String prefix = "Secret";
    public static ObjectTagProcessor<SecretTag> tagProcessor;

    public static void load() {
        File path = new File(DenizenCore.implementation.getDataFolder(), "secrets.secret");
        String fileContent = CoreUtilities.journallingLoadFile(path.getPath());
        if (fileContent != null) {
            if (!fileContent.startsWith("!SECRETS_FILE")) {
                Debug.echoError("Secrets file (Denizen/secrets.secret) is not properly formatted. Refusing to load. Please delete and reset it.");
                return;
            }
            fileContent = fileContent.substring("!SECRETS_FILE".length());
            secretsFile = YamlConfiguration.load(fileContent);
        } else {
            secretsFile = new YamlConfiguration();
            CoreUtilities.journallingFileSave(path.getPath(), "!SECRETS_FILE\n# Denizen Secrets File\n# Refer to meta documentation for SecretTag Objects: https://meta.denizenscript.com/Docs/ObjectTypes/SecretTag\n\n# my_token: abc123.123abc\n");
        }
    }

    @Fetchable(value="secret")
    public static SecretTag valueOf(String string, TagContext context) {
        SecretTag secret;
        if (string.startsWith("secret@")) {
            string = string.substring("secret@".length());
        }
        if ((secret = new SecretTag(string)).isValid()) {
            return secret;
        }
        return null;
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("secret@")) {
            return true;
        }
        return SecretTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public SecretTag(String key) {
        this.key = key;
    }

    public boolean isValid() {
        return this.getValue() != null;
    }

    @ReflectionRefuse
    public String getValue() {
        if (secretsFile == null) {
            return null;
        }
        return secretsFile.getString(this.key);
    }

    @Override
    public String identify() {
        return "secret@" + this.key;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debuggable() {
        return "<LG>secret@<Y>" + this.key;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "key", (attribute, object) -> new ElementTag(object.key, true), new String[0]);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    static {
        tagProcessor = new ObjectTagProcessor();
    }
}

