/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class NoteCommand
extends AbstractCommand {
    public NoteCommand() {
        this.setName("note");
        this.setSyntax("note [<object>/remove] [as:<name>]");
        this.setRequiredArguments(2, 2);
        this.isProcedural = false;
        this.autoCompile();
        this.addRemappedPrefixes("as", "id", "i");
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgLinear @ArgName(value="object") ObjectTag object, @ArgPrefixed @ArgName(value="as") String id) {
        String stringified;
        boolean remove;
        boolean bl = remove = object instanceof ElementTag && object.asElement().asLowerString().equals("remove");
        if (remove) {
            Notable note = NoteManager.getSavedObject(id);
            if (note != null) {
                note.forget();
                Debug.echoDebug((Debuggable)scriptEntry, "Note '" + id + "' removed");
            } else {
                Debug.echoDebug((Debuggable)scriptEntry, id + " is not saved");
            }
            return;
        }
        if (object instanceof ElementTag && (object = ObjectFetcher.pickObjectFor(stringified = object.toString(), scriptEntry.context)) == null) {
            Debug.echoError("Failed to read the object '" + stringified + "' into a real object value.");
            return;
        }
        if (!(object instanceof Notable)) {
            Debug.echoError("Object '" + object + "' has type '" + object.getDenizenObjectType() + "' which is not a notable object type.");
            return;
        }
        try {
            ((Notable)((Object)object)).makeUnique(id);
        }
        catch (Throwable ex) {
            Debug.echoError("Something went wrong converting that object!");
            Debug.echoError(ex);
        }
    }
}

