/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.containers.core;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemScriptHelper
implements Listener {
    public static final Map<String, ItemScriptContainer> item_scripts = new HashMap<String, ItemScriptContainer>();
    public static final Map<String, ItemScriptContainer> item_scripts_by_hash_id = new HashMap<String, ItemScriptContainer>();
    public static final Map<String, ItemScriptContainer> recipeIdToItemScript = new HashMap<String, ItemScriptContainer>();
    public static HashMap<String, String[]> smithingRetain = new HashMap();
    public static String ItemScriptHashID = ChatColor.RED.toString() + ChatColor.BLUE + ChatColor.BLACK;
    private static ItemStack AIR = new ItemStack(Material.AIR);
    public static HashMap<Material, Collection<Recipe>> recipeCache = new HashMap();

    public ItemScriptHelper() {
        Denizen.getInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.getInstance());
    }

    public static void removeDenizenRecipes() {
        smithingRetain.clear();
        recipeCache.clear();
        recipeIdToItemScript.clear();
        NMSHandler.itemHelper.clearDenizenRecipes();
        PaperAPITools.instance.clearBrewingRecipes();
    }

    public static String getIdFor(ItemScriptContainer container, String type, int id) {
        String basicId = type + "_" + Utilities.cleanseNamespaceID(container.getName()) + "_" + id;
        if (!recipeIdToItemScript.containsKey(basicId)) {
            recipeIdToItemScript.put("denizen:" + basicId, container);
            return basicId;
        }
        int newNumber = 1;
        String newId = basicId + "_1";
        while (recipeIdToItemScript.containsKey(newId)) {
            newId = basicId + "_" + newNumber++;
        }
        recipeIdToItemScript.put("denizen:" + newId, container);
        return newId;
    }

    public static List<String> splitByNonBracketedSlashes(String str) {
        boolean brackets = false;
        int start = 0;
        ArrayList<String> output = new ArrayList<String>(4);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '[') {
                brackets = true;
                continue;
            }
            if (c == ']') {
                brackets = false;
                continue;
            }
            if (c != '/' || brackets) continue;
            output.add(str.substring(start, i));
            start = i + 1;
        }
        output.add(str.substring(start));
        return output;
    }

    public static ItemStack[] textToItemArray(ItemScriptContainer container, String text, boolean exact) {
        if (CoreUtilities.toLowerCase(text).equals("air")) {
            return new ItemStack[0];
        }
        List<String> ingredientText = ItemScriptHelper.splitByNonBracketedSlashes(text);
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>(ingredientText.size());
        for (int i = 0; i < ingredientText.size(); ++i) {
            String entry = ingredientText.get(i);
            if (ScriptEvent.isAdvancedMatchable(entry)) {
                boolean any = false;
                for (Material material : Material.values()) {
                    if (!material.isItem() || !MaterialTag.advancedMatchesInternal(material, entry, true)) continue;
                    outputItems.add(new ItemStack(material, 1));
                    any = true;
                }
                if (exact) {
                    for (ItemScriptContainer possibleContainer : item_scripts.values()) {
                        if (possibleContainer.getCleanReference() == null || !possibleContainer.getCleanReference().tryAdvancedMatcher(entry)) continue;
                        outputItems.add(possibleContainer.getCleanReference().getItemStack());
                        any = true;
                    }
                }
                if (any) continue;
                Debug.echoError("Invalid ItemTag ingredient (empty advanced matcher), recipe will not be registered for item script '" + container.getName() + "': " + entry);
                return null;
            }
            ItemTag ingredient = ItemTag.valueOf(entry, container);
            if (ingredient == null) {
                Debug.echoError("Invalid ItemTag ingredient, recipe will not be registered for item script '" + container.getName() + "': " + entry);
                return null;
            }
            outputItems.add(ingredient.getItemStack().clone());
        }
        return outputItems.toArray(new ItemStack[0]);
    }

    public static void registerShapedRecipe(ItemScriptContainer container, ItemStack item, List<String> recipeList, String internalId, String group) {
        for (int n = 0; n < recipeList.size(); ++n) {
            recipeList.set(n, TagManager.tag(ScriptBuilder.stripLinePrefix(recipeList.get(n)), new BukkitTagContext(container)));
        }
        ArrayList<ItemStack[]> ingredients = new ArrayList<ItemStack[]>();
        ArrayList<Boolean> exacts = new ArrayList<Boolean>();
        int width = 1;
        for (String recipeRow : recipeList) {
            String[] elements = recipeRow.split("\\|", 3);
            if (width < 3 && elements.length == 3) {
                width = 3;
            }
            if (width < 2 && elements.length >= 2) {
                width = 2;
            }
            for (String element : elements) {
                boolean isExact;
                String itemText = element;
                boolean bl = isExact = !itemText.startsWith("material:");
                if (!isExact) {
                    itemText = itemText.substring("material:".length());
                }
                exacts.add(isExact);
                ItemStack[] items = ItemScriptHelper.textToItemArray(container, itemText, isExact);
                if (items == null) {
                    return;
                }
                ingredients.add(items);
            }
        }
        NamespacedKey key = new NamespacedKey("denizen", internalId);
        ShapedRecipe recipe = new ShapedRecipe(key, item);
        recipe.setGroup(group);
        String shape1 = "ABC".substring(0, width);
        String shape2 = "DEF".substring(0, width);
        String shape3 = "GHI".substring(0, width);
        String itemChars = shape1 + shape2 + shape3;
        recipe = recipeList.size() == 3 ? recipe.shape(new String[]{shape1, shape2, shape3}) : (recipeList.size() == 2 ? recipe.shape(new String[]{shape1, shape2}) : recipe.shape(new String[]{shape1}));
        for (int i = 0; i < ingredients.size(); ++i) {
            if (((ItemStack[])ingredients.get(i)).length == 0) continue;
            NMSHandler.itemHelper.setShapedRecipeIngredient(recipe, itemChars.charAt(i), (ItemStack[])ingredients.get(i), (Boolean)exacts.get(i));
        }
        Bukkit.addRecipe((Recipe)recipe);
    }

    public static void registerShapelessRecipe(ItemScriptContainer container, ItemStack item, String shapelessString, String internalId, String group, String category) {
        BukkitTagContext context = new BukkitTagContext(container);
        ArrayList<ItemStack[]> ingredients = new ArrayList<ItemStack[]>();
        ArrayList<Boolean> exacts = new ArrayList<Boolean>();
        for (String element : ListTag.valueOf(shapelessString, context)) {
            boolean isExact;
            String itemText = element;
            boolean bl = isExact = !itemText.startsWith("material:");
            if (!isExact) {
                itemText = itemText.substring("material:".length());
            }
            exacts.add(isExact);
            ItemStack[] items = ItemScriptHelper.textToItemArray(container, itemText, isExact);
            if (items == null) {
                return;
            }
            ingredients.add(items);
        }
        boolean[] bools = new boolean[exacts.size()];
        for (int i = 0; i < exacts.size(); ++i) {
            bools[i] = (Boolean)exacts.get(i);
        }
        NMSHandler.itemHelper.registerShapelessRecipe(internalId, group, item, ingredients, bools, category);
    }

    public static void registerFurnaceRecipe(ItemScriptContainer container, ItemStack item, String furnaceItemString, float exp, int time, String type, String internalId, String group, String category) {
        ItemStack[] items;
        boolean exact = true;
        if (furnaceItemString.startsWith("material:")) {
            exact = false;
            furnaceItemString = furnaceItemString.substring("material:".length());
        }
        if ((items = ItemScriptHelper.textToItemArray(container, furnaceItemString, exact)) == null) {
            return;
        }
        NMSHandler.itemHelper.registerFurnaceRecipe(internalId, group, item, items, exp, time, type, exact, category);
    }

    public static void registerStonecuttingRecipe(ItemScriptContainer container, ItemStack item, String inputItemString, String internalId, String group) {
        ItemStack[] items;
        boolean exact = true;
        if (inputItemString.startsWith("material:")) {
            exact = false;
            inputItemString = inputItemString.substring("material:".length());
        }
        if ((items = ItemScriptHelper.textToItemArray(container, inputItemString, exact)) == null) {
            return;
        }
        NMSHandler.itemHelper.registerStonecuttingRecipe(internalId, group, item, items, exact);
    }

    public static void registerSmithingRecipe(ItemScriptContainer container, ItemStack item, String templateString, String baseString, String additionString, String internalId, String retain) {
        ItemStack[] additionItems;
        ItemStack[] baseItems;
        ItemStack[] template = null;
        boolean templateExact = true;
        if (templateString != null) {
            if (templateString.startsWith("material:")) {
                templateExact = false;
                templateString = templateString.substring("material:".length());
            }
            if ((template = ItemScriptHelper.textToItemArray(container, templateString, templateExact)) == null) {
                return;
            }
        }
        boolean baseExact = true;
        if (baseString.startsWith("material:")) {
            baseExact = false;
            baseString = baseString.substring("material:".length());
        }
        if ((baseItems = ItemScriptHelper.textToItemArray(container, baseString, baseExact)) == null) {
            return;
        }
        boolean additionExact = true;
        if (additionString.startsWith("material:")) {
            additionExact = false;
            additionString = additionString.substring("material:".length());
        }
        if ((additionItems = ItemScriptHelper.textToItemArray(container, additionString, additionExact)) == null) {
            return;
        }
        smithingRetain.put(internalId, retain == null ? new String[]{} : CoreUtilities.split(CoreUtilities.toLowerCase(retain), '|').toArray(new String[0]));
        NMSHandler.itemHelper.registerSmithingRecipe(internalId, item, baseItems, baseExact, additionItems, additionExact, template, templateExact);
    }

    public static void rebuildRecipes() {
        for (ItemScriptContainer container : item_scripts.values()) {
            try {
                if (container.contains("recipes", Map.class)) {
                    BukkitTagContext context = new BukkitTagContext(container);
                    YamlConfiguration section = container.getConfigurationSection("recipes");
                    int id = 0;
                    for (StringHolder key : section.getKeys(false)) {
                        String internalId;
                        ++id;
                        YamlConfiguration subSection = section.getConfigurationSection(key.str);
                        String type = CoreUtilities.toLowerCase(subSection.getString("type"));
                        Function<String, String> getString = s -> TagManager.tag(subSection.getString((String)s), context);
                        if (subSection.contains("recipe_id")) {
                            internalId = getString.apply("recipe_id");
                            recipeIdToItemScript.put("denizen:" + internalId, container);
                        } else {
                            internalId = ItemScriptHelper.getIdFor(container, type + "_recipe", id);
                        }
                        String group = subSection.contains("group") ? getString.apply("group") : "";
                        ItemStack item = container.getCleanReference().getItemStack().clone();
                        if (subSection.contains("output_quantity")) {
                            item.setAmount(Integer.parseInt(getString.apply("output_quantity")));
                        }
                        switch (type) {
                            case "shaped": {
                                ItemScriptHelper.registerShapedRecipe(container, item, subSection.getStringList("input"), internalId, group);
                                break;
                            }
                            case "shapeless": {
                                ItemScriptHelper.registerShapelessRecipe(container, item, getString.apply("input"), internalId, group, subSection.getString("category"));
                                break;
                            }
                            case "stonecutting": {
                                ItemScriptHelper.registerStonecuttingRecipe(container, item, getString.apply("input"), internalId, group);
                                break;
                            }
                            case "furnace": 
                            case "blast": 
                            case "smoker": 
                            case "campfire": {
                                float exp = 0.0f;
                                int cookTime = 40;
                                if (subSection.contains("experience")) {
                                    exp = Float.parseFloat(getString.apply("experience"));
                                }
                                if (subSection.contains("cook_time")) {
                                    cookTime = DurationTag.valueOf(getString.apply("cook_time"), context).getTicksAsInt();
                                }
                                ItemScriptHelper.registerFurnaceRecipe(container, item, getString.apply("input"), exp, cookTime, type, internalId, group, subSection.getString("category"));
                                break;
                            }
                            case "smithing": {
                                String retain = null;
                                if (subSection.contains("retain")) {
                                    retain = getString.apply("retain");
                                }
                                String template = null;
                                if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
                                    template = getString.apply("template");
                                }
                                ItemScriptHelper.registerSmithingRecipe(container, item, template, getString.apply("base"), getString.apply("upgrade"), internalId, retain);
                                break;
                            }
                            case "brewing": {
                                PaperAPITools.instance.registerBrewingRecipe(internalId, item, getString.apply("input"), getString.apply("ingredient"), container);
                            }
                        }
                    }
                }
                if (container.contains("RECIPE", List.class)) {
                    BukkitImplDeprecations.oldRecipeScript.warn(container);
                    ItemScriptHelper.registerShapedRecipe(container, container.getCleanReference().getItemStack().clone(), container.getStringList("RECIPE"), ItemScriptHelper.getIdFor(container, "old_recipe", 0), "custom");
                }
                if (container.contains("SHAPELESS_RECIPE", String.class)) {
                    BukkitImplDeprecations.oldRecipeScript.warn(container);
                    ItemScriptHelper.registerShapelessRecipe(container, container.getCleanReference().getItemStack().clone(), container.getString("SHAPELESS_RECIPE"), ItemScriptHelper.getIdFor(container, "old_shapeless", 0), "custom", null);
                }
                if (!container.contains("FURNACE_RECIPE", String.class)) continue;
                BukkitImplDeprecations.oldRecipeScript.warn(container);
                ItemScriptHelper.registerFurnaceRecipe(container, container.getCleanReference().getItemStack().clone(), container.getString("FURNACE_RECIPE"), 0.0f, 40, "furnace", ItemScriptHelper.getIdFor(container, "old_furnace", 0), "custom", null);
            }
            catch (Exception ex) {
                Debug.echoError("Error while rebuilding item script recipes for '" + container.getName() + "'...");
                Debug.echoError(ex);
            }
        }
    }

    @EventHandler
    public void scriptReload(ScriptReloadEvent event) {
        ItemScriptHelper.rebuildRecipes();
    }

    public static boolean isItemscript(ItemStack item) {
        return ItemScriptHelper.getItemScriptNameText(item) != null;
    }

    public static String getItemScriptNameText(ItemStack item) {
        ItemScriptContainer container;
        if (item == null) {
            return null;
        }
        CompoundTag tag = NMSHandler.itemHelper.getNbtData(item);
        String scriptName = tag.getString("DenizenItemScript");
        if (scriptName != null && !scriptName.equals("")) {
            return scriptName;
        }
        String nbt = tag.getString("Denizen Item Script");
        if (nbt != null && !nbt.equals("") && (container = item_scripts_by_hash_id.get(nbt)) != null) {
            return container.getName();
        }
        return null;
    }

    public static ItemScriptContainer getItemScriptContainer(ItemStack item) {
        if (item == null) {
            return null;
        }
        CompoundTag tag = NMSHandler.itemHelper.getNbtData(item);
        String scriptName = tag.getString("DenizenItemScript");
        if (scriptName != null && !scriptName.equals("")) {
            return item_scripts.get(scriptName);
        }
        String nbt = tag.getString("Denizen Item Script");
        if (nbt != null && !nbt.equals("")) {
            return item_scripts_by_hash_id.get(nbt);
        }
        return null;
    }

    public static String createItemScriptID(ItemScriptContainer container) {
        String colors = ItemScriptHelper.createItemScriptID(container.getName());
        container.setHashID(colors);
        return colors;
    }

    public static String createItemScriptID(String name) {
        String script = name.toUpperCase();
        StringBuilder colors = new StringBuilder();
        colors.append(ItemScriptHashID);
        try {
            String hash = CoreUtilities.hash_md5(script.getBytes(StandardCharsets.UTF_8));
            for (int i = 0; i < 16; ++i) {
                colors.append('\u00a7').append(hash.charAt(i));
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            colors.append(ChatColor.BLUE);
        }
        return colors.toString();
    }

    public static boolean isAllowedChoice(ItemScriptContainer script, RecipeChoice choice) {
        if (choice instanceof RecipeChoice.ExactChoice) {
            for (ItemStack choiceOpt : ((RecipeChoice.ExactChoice)choice).getChoices()) {
                ItemScriptContainer choiceOptContainer = ItemScriptHelper.getItemScriptContainer(choiceOpt);
                if (script != choiceOptContainer) continue;
                return true;
            }
        }
        return false;
    }

    public static DenyCraftReason shouldDenyCraft(ItemStack[] items, Recipe recipe) {
        String[] shape;
        int width = items.length == 9 ? 3 : 2;
        int shapeStartX = 0;
        int shapeStartY = 0;
        if (recipe instanceof ShapedRecipe && ((shape = ((ShapedRecipe)recipe).getShape()).length != width || shape[0].length() != width)) {
            if (shape.length > width || shape[0].length() > width) {
                return DenyCraftReason.ALLOWED;
            }
            block0: for (shapeStartX = 0; shapeStartX <= width - shape[0].length(); ++shapeStartX) {
                for (shapeStartY = 0; shapeStartY <= width - shape.length; ++shapeStartY) {
                    boolean hasAnyInvalid = false;
                    block2: for (int x = 0; x < shape[0].length(); ++x) {
                        for (int y = 0; y < shape.length; ++y) {
                            ItemStack item = items[(y + shapeStartY) * width + (x + shapeStartX)];
                            RecipeChoice choice = (RecipeChoice)((ShapedRecipe)recipe).getChoiceMap().get(Character.valueOf(shape[y].charAt(x)));
                            if (choice == null || choice.test(item == null ? AIR : item)) continue;
                            hasAnyInvalid = true;
                            continue block2;
                        }
                    }
                    if (!hasAnyInvalid) break block0;
                }
            }
        }
        for (int i = 0; i < items.length; ++i) {
            ItemScriptContainer container;
            ItemStack item = items[i];
            if (item == null || item.getType() == Material.AIR || (container = ItemScriptHelper.getItemScriptContainer(item)) == null || container.allowInMaterialRecipes) continue;
            boolean allowed = false;
            if (recipe instanceof ShapelessRecipe) {
                for (RecipeChoice choice : ((ShapelessRecipe)recipe).getChoiceList()) {
                    if (!ItemScriptHelper.isAllowedChoice(container, choice)) continue;
                    allowed = true;
                    break;
                }
            } else if (recipe instanceof ShapedRecipe) {
                int x = i % width - shapeStartX;
                int y = i / width - shapeStartY;
                if (x < 0 || y < 0) {
                    return DenyCraftReason.IMPOSSIBLE;
                }
                String[] shape2 = ((ShapedRecipe)recipe).getShape();
                if (y < shape2.length && x < shape2[y].length()) {
                    char c = shape2[y].charAt(x);
                    RecipeChoice choice = (RecipeChoice)((ShapedRecipe)recipe).getChoiceMap().get(Character.valueOf(c));
                    if (ItemScriptHelper.isAllowedChoice(container, choice)) {
                        allowed = true;
                    }
                }
            } else {
                allowed = recipe instanceof CookingRecipe ? ItemScriptHelper.isAllowedChoice(container, ((CookingRecipe)recipe).getInputChoice()) : true;
            }
            if (allowed) continue;
            return DenyCraftReason.NOT_ALLOWED;
        }
        return DenyCraftReason.ALLOWED;
    }

    public static Collection<Recipe> getRecipesFor(Material item) {
        return recipeCache.computeIfAbsent(item, i -> Bukkit.getRecipesFor((ItemStack)new ItemStack(i)));
    }

    public static boolean hasAlternateValidRecipe(Recipe recipe, ItemStack[] items) {
        ItemStack result;
        if (recipe instanceof ShapedRecipe && ItemScriptHelper.isItemscript(result = recipe.getResult())) {
            for (Recipe altRecipe : ItemScriptHelper.getRecipesFor(result.getType())) {
                if (!(altRecipe instanceof ShapedRecipe) || ItemScriptHelper.shouldDenyCraft(items, altRecipe) != DenyCraftReason.ALLOWED) continue;
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCraftPrepared(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (recipe == null) {
            return;
        }
        ItemStack[] items = event.getInventory().getMatrix();
        if (ItemScriptHelper.shouldDenyCraft(items, recipe) != DenyCraftReason.ALLOWED && !ItemScriptHelper.hasAlternateValidRecipe(recipe, items)) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemCrafted(CraftItemEvent event) {
        Recipe recipe = event.getRecipe();
        ItemStack[] items = event.getInventory().getMatrix();
        if (ItemScriptHelper.shouldDenyCraft(items, recipe) != DenyCraftReason.ALLOWED && !ItemScriptHelper.hasAlternateValidRecipe(recipe, items)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemCooked(BlockCookEvent event) {
        ItemScriptContainer container = ItemScriptHelper.getItemScriptContainer(event.getSource());
        if (container == null || container.allowInMaterialRecipes) {
            return;
        }
        ItemStack[] stacks = new ItemStack[]{event.getSource()};
        for (Recipe recipe : ItemScriptHelper.getRecipesFor(event.getResult().getType())) {
            if (!(recipe instanceof CookingRecipe) || ItemScriptHelper.shouldDenyCraft(stacks, recipe) != DenyCraftReason.ALLOWED) continue;
            return;
        }
        event.setCancelled(true);
    }

    public static boolean isAllowedToCraftWith(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        ItemScriptContainer container = ItemScriptHelper.getItemScriptContainer(item);
        if (container == null) {
            return true;
        }
        return container.allowInMaterialRecipes;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBrewingStandBrews(BrewEvent event) {
        ItemStack ingredient = event.getContents().getIngredient();
        boolean ingredientBlockCraft = !ItemScriptHelper.isAllowedToCraftWith(ingredient);
        ArrayList<ItemHelper.BrewingRecipe> potentialRecipes = null;
        for (int i = 0; i < 3; ++i) {
            boolean inputBlockCraft;
            ItemStack currInput = event.getContents().getItem(i);
            boolean bl = inputBlockCraft = !ItemScriptHelper.isAllowedToCraftWith(currInput);
            if (!inputBlockCraft && !ingredientBlockCraft) continue;
            ItemHelper.BrewingRecipe customRecipe = null;
            if (Denizen.supportsPaper && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
                if (potentialRecipes == null) {
                    potentialRecipes = new ArrayList<ItemHelper.BrewingRecipe>();
                    for (ItemHelper.BrewingRecipe recipe : NMSHandler.itemHelper.getCustomBrewingRecipes().values()) {
                        if (!recipe.ingredient().test(ingredient)) continue;
                        potentialRecipes.add(recipe);
                    }
                }
                for (ItemHelper.BrewingRecipe recipe : potentialRecipes) {
                    if (currInput == null || !recipe.input().test(currInput)) continue;
                    customRecipe = recipe;
                    break;
                }
            }
            if (customRecipe == null && NMSHandler.itemHelper.isValidMix(currInput, ingredient)) {
                event.getResults().set(i, currInput);
                continue;
            }
            if (customRecipe == null || !this.shouldBlockChoice(customRecipe.ingredient(), ingredientBlockCraft) && !this.shouldBlockChoice(customRecipe.input(), inputBlockCraft)) continue;
            event.getResults().set(i, currInput);
        }
    }

    private boolean shouldBlockChoice(RecipeChoice choice, boolean blockCraft) {
        return blockCraft && choice instanceof RecipeChoice.MaterialChoice;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBrewingStandFuel(BrewingStandFuelEvent event) {
        if (!ItemScriptHelper.isAllowedToCraftWith(event.getFuel())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onItemSmithing(PrepareSmithingEvent event) {
        ItemTag got;
        HumanEntity human;
        ItemStack inputItem = event.getInventory().getItem(NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) ? 1 : 0);
        if (inputItem == null) {
            return;
        }
        Recipe recipe = event.getInventory().getRecipe();
        SmithingRecipe smithRecipe = (SmithingRecipe)recipe;
        if (smithRecipe == null || !smithRecipe.getKey().getNamespace().equals("denizen")) {
            if (!ItemScriptHelper.isAllowedToCraftWith(inputItem)) {
                event.setResult(new ItemStack(Material.AIR));
            }
            return;
        }
        ItemScriptContainer realResult = recipeIdToItemScript.get(smithRecipe.getKey().toString());
        if (realResult == null) {
            if (!ItemScriptHelper.isAllowedToCraftWith(inputItem)) {
                event.setResult(new ItemStack(Material.AIR));
            }
            return;
        }
        String[] retain = smithingRetain.get(smithRecipe.getKey().getKey());
        if (retain == null) {
            Debug.echoError("Smithing recipe mis-registered for script item: " + realResult.getName());
            if (!ItemScriptHelper.isAllowedToCraftWith(inputItem)) {
                event.setResult(new ItemStack(Material.AIR));
            }
            return;
        }
        PlayerTag player = null;
        if (!event.getInventory().getViewers().isEmpty() && !EntityTag.isNPC((Entity)(human = (HumanEntity)event.getInventory().getViewers().get(0))) && human instanceof Player) {
            player = new PlayerTag((Player)human);
        }
        if ((got = realResult.getItemFrom(new BukkitTagContext(player, null, new ScriptTag(realResult)))) == null) {
            return;
        }
        if (retain.length > 0) {
            ItemMeta originalMeta = inputItem.getItemMeta();
            ItemMeta newMeta = got.getItemMeta();
            String[] stringArray = retain;
            int n = stringArray.length;
            block8: for (int i = 0; i < n; ++i) {
                String retainable;
                switch (retainable = stringArray[i]) {
                    case "display": {
                        if (originalMeta.hasDisplayName()) {
                            String originalName = NMSHandler.itemHelper.getDisplayName(new ItemTag(inputItem));
                            ItemScriptContainer origScript = ItemScriptHelper.getItemScriptContainer(inputItem);
                            if (origScript == null || !originalName.equals(NMSHandler.itemHelper.getDisplayName(origScript.getItemFrom()))) {
                                NMSHandler.itemHelper.setDisplayName(got, originalName);
                            }
                        }
                        newMeta = got.getItemMeta();
                        continue block8;
                    }
                    case "enchantments": {
                        if (!originalMeta.hasEnchants()) continue block8;
                        for (Map.Entry enchant : originalMeta.getEnchants().entrySet()) {
                            newMeta.addEnchant((Enchantment)enchant.getKey(), ((Integer)enchant.getValue()).intValue(), true);
                        }
                        continue block8;
                    }
                }
            }
            got.setItemMeta(newMeta);
        }
        event.setResult(got.getItemStack());
    }

    public static enum DenyCraftReason {
        ALLOWED,
        IMPOSSIBLE,
        NOT_ALLOWED;

    }
}

