/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.properties;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.ObjectType;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.ObjectProperty;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.codegen.CodeGenUtil;
import com.denizenscript.denizencore.utilities.codegen.MethodGenerator;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class PropertyParser {
    public static Set<String> allMechanismsEver = new HashSet<String>();
    public static Map<Class<? extends ObjectTag>, ClassPropertiesInfo> propertiesByClass = new HashMap<Class<? extends ObjectTag>, ClassPropertiesInfo>();
    public static PropertyGetter<? extends ObjectTag> currentlyRegisteringProperty;
    public static ClassPropertiesInfo currentlyRegisteringPropertyInfo;
    public static long totalGenerated;
    public static final String GETTER_PATH;
    public static final Method GETTER_GET_METHOD;
    public static final String GETTER_GET_DESCRIPTOR;
    public static final Field OBJECT_PROPERTY_OBJECT_FIELD;
    public static AsciiMatcher needsEscapingMatcher;
    public static List<Property> empty;

    public static <T extends Property, R extends ObjectTag, P extends ObjectTag> void registerStaticTag(Class<T> propType, Class<R> returnType, Class<P> paramType, String name, PropertyTagWithReturnAndParam<T, R, P> runnable, String ... variants) {
        PropertyParser.registerTagInternal(propType, returnType, paramType, name, runnable, variants, true);
    }

    public static <T extends Property, R extends ObjectTag, P extends ObjectTag> void registerTag(Class<T> propType, Class<R> returnType, Class<P> paramType, String name, PropertyTagWithReturnAndParam<T, R, P> runnable, String ... variants) {
        PropertyParser.registerTagInternal(propType, returnType, paramType, name, runnable, variants, false);
    }

    public static <T extends Property, R extends ObjectTag, P extends ObjectTag> void registerTagInternal(Class<T> propType, Class<R> returnType, Class<P> paramType, String name, PropertyTagWithReturnAndParam<T, R, P> runnable, String[] variants, boolean isStatic) {
        PropertyTagWithReturn<Property, ObjectTag> altMethod = (attribute, prop) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ObjectTag param = attribute.getParamObject();
            Object result = param.asType(paramType, attribute.context);
            if (result == null) {
                attribute.echoError("Tag '<Y>" + name + "<W>' requires input of type '<Y>" + DebugInternals.getClassNameOpti(paramType) + "<W>' but received input '<LR>" + param + "<W>'.");
                return null;
            }
            return runnable.run(attribute, prop, result);
        };
        PropertyParser.registerTagInternal(propType, returnType, name, altMethod, variants, isStatic);
    }

    public static <T extends Property, R extends ObjectTag> void registerStaticTag(Class<T> propType, Class<R> returnType, String name, PropertyTagWithReturn<T, R> runnable, String ... variants) {
        PropertyParser.registerTagInternal(propType, returnType, name, runnable, variants, true);
    }

    public static <T extends Property, R extends ObjectTag> void registerTag(Class<T> propType, Class<R> returnType, String name, PropertyTagWithReturn<T, R> runnable, String ... variants) {
        PropertyParser.registerTagInternal(propType, returnType, name, runnable, variants, false);
    }

    public static <T extends Property, R extends ObjectTag> void registerTagInternal(Class<T> propType, Class<R> returnType, String name, PropertyTagWithReturn<T, R> runnable, String[] variants, boolean isStatic) {
        PropertyGetter<? extends ObjectTag> getter = currentlyRegisteringProperty;
        ObjectTagProcessor<ObjectTag> tagProcessor = PropertyParser.currentlyRegisteringPropertyInfo.objectType.tagProcessor;
        Function<? extends ObjectTag, String> reasonGetter = PropertyParser.getPropertyReasonMethod(propType);
        tagProcessor.registerTagInternal(returnType, name, (attribute, object) -> {
            Property prop = getter.get(object);
            if (prop == null) {
                if (!attribute.hasAlternative()) {
                    String reason;
                    if (reasonGetter != null && (reason = (String)reasonGetter.apply(object)) != null) {
                        attribute.echoError("Property '" + DebugInternals.getClassNameOpti(propType) + "' does not describe the input object, because " + reason);
                        return null;
                    }
                    attribute.echoError("Property '" + DebugInternals.getClassNameOpti(propType) + "' does not describe the input object.");
                }
                return null;
            }
            return runnable.run(attribute, prop);
        }, isStatic, variants);
    }

    public static Function<? extends ObjectTag, String> getPropertyReasonMethod(Class<?> propType) {
        while (propType != null && propType != Property.class && propType != Object.class) {
            Method method = Arrays.stream(propType.getDeclaredMethods()).filter(m -> m.getName().equals("getReasonNotDescribed") && (m.getModifiers() & 8) != 0).findFirst().orElse(null);
            if (method != null) {
                return ReflectionHelper.getStaticLambda(Function.class, "apply", propType, "getReasonNotDescribed");
            }
            propType = propType.getSuperclass();
        }
        return null;
    }

    public static <T extends Property> void registerMechanism(Class<T> propType, String name, PropertyMechanism<T> runner, String ... deprecatedVariants) {
        PropertyGetter<? extends ObjectTag> getter = currentlyRegisteringProperty;
        PropertyParser.currentlyRegisteringPropertyInfo.propertiesByMechanism.put(name, getter);
        ObjectTagProcessor<ObjectTag> tagProcessor = PropertyParser.currentlyRegisteringPropertyInfo.objectType.tagProcessor;
        Function<? extends ObjectTag, String> reasonGetter = PropertyParser.getPropertyReasonMethod(propType);
        tagProcessor.registerMechanism(name, true, (object, mechanism) -> {
            Property prop = getter.get(object);
            if (prop == null) {
                String reason;
                if (reasonGetter != null && (reason = (String)reasonGetter.apply(object)) != null) {
                    mechanism.echoError("Property '" + DebugInternals.getClassNameOpti(propType) + "' does not describe the input object, because " + reason);
                    return;
                }
                mechanism.echoError("Property '" + DebugInternals.getClassNameOpti(propType) + "' does not describe the input object.");
                return;
            }
            runner.run(prop, mechanism);
        }, deprecatedVariants);
    }

    public static <T extends Property, P extends ObjectTag> void registerMechanism(Class<T> propType, Class<P> paramType, String name, PropertyMechanismWithParam<T, P> runner, String ... deprecatedVariants) {
        PropertyParser.registerMechanism(propType, name, (T object, Mechanism mechanism) -> {
            if (mechanism.value == null) {
                mechanism.echoError("Error: mechanism '" + name + "' must have input of type '" + DebugInternals.getClassNameOpti(paramType) + "', but none was given.");
                return;
            }
            Object input = mechanism.value.asType(paramType, mechanism.context);
            if (input == null) {
                mechanism.echoError("Error: mechanism '" + name + "' must have input of type '" + DebugInternals.getClassNameOpti(paramType) + "', but value '" + mechanism.value + "' cannot be converted to the required type.");
                return;
            }
            runner.run(object, mechanism, input);
        }, deprecatedVariants);
    }

    public static <T extends ObjectTag> void registerPropertyGetter(PropertyGetter<T> getter, Class<T> objectType, String[] tags, String[] mechs, Class<? extends Property> property) {
        ClassPropertiesInfo propInfo = propertiesByClass.get(objectType);
        if (propInfo == null) {
            propInfo = new ClassPropertiesInfo();
            propInfo.objectType = ObjectFetcher.getType(objectType);
            propertiesByClass.put(objectType, propInfo);
        }
        currentlyRegisteringPropertyInfo = propInfo;
        currentlyRegisteringProperty = getter;
        try {
            for (Method registerMethod : property.getDeclaredMethods()) {
                if (!registerMethod.getName().equals("register") && !registerMethod.getName().equals("registerTags") || registerMethod.getParameterCount() != 0) continue;
                registerMethod.invoke(null, new Object[0]);
                break;
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        currentlyRegisteringProperty = null;
        currentlyRegisteringPropertyInfo = null;
        propInfo.allProperties.add(getter);
        if (tags != null) {
            String propName = DebugInternals.getClassNameOpti(property);
            String[] stringArray = tags;
            int n = stringArray.length;
            for (int registerMethod = 0; registerMethod < n; ++registerMethod) {
                String tag = stringArray[registerMethod];
                propInfo.propertiesByTag.put(tag, getter);
                propInfo.propertyNamesByTag.put(tag, propName);
            }
        }
        if (mechs != null) {
            for (String mech : mechs) {
                propInfo.propertiesByMechanism.put(mech, getter);
                allMechanismsEver.add(mech);
            }
        }
        propInfo.propertiesWithMechs.add(getter);
    }

    public static String[] getStringField(Class property, String fieldName) {
        try {
            Field f = property.getDeclaredField(fieldName);
            return (String[])f.get(null);
        }
        catch (IllegalAccessException e) {
            Debug.echoError("Invalid property field '" + fieldName + "' for property class '" + DebugInternals.getClassNameOpti(property) + "': field is not a String[]: " + e.getMessage() + "!");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public static <T extends ObjectTag> void registerProperty(Class<? extends Property> property, Class<T> objectType, PropertyGetter<T> getter) {
        PropertyParser.registerPropertyGetter(getter, objectType, PropertyParser.getStringField(property, "handledTags"), PropertyParser.getStringField(property, "handledMechs"), property);
    }

    public static <T extends ObjectTag> void registerProperty(Class<? extends Property> property, Class<T> objectType) {
        try {
            Method describesMethod = Arrays.stream(property.getMethods()).filter(m -> m.getName().equals("describes") && (m.getModifiers() & 8) != 0).findFirst().get();
            String cleanName = CodeGenUtil.cleanName(DebugInternals.getClassNameOpti(property).replace('.', '_'));
            String className = "com/denizenscript/_generated_/Properties/Prop" + totalGenerated++ + "_" + cleanName;
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 1, className, null, "java/lang/Object", new String[]{GETTER_PATH});
            cw.visitSource("GENERATED_PROP_GETTER", null);
            MethodGenerator.genDefaultConstructor(cw, className);
            MethodGenerator gen = MethodGenerator.generateMethod(className, cw, 17, "get", GETTER_GET_DESCRIPTOR);
            MethodGenerator.Local objectLocal = gen.addLocal("object", ObjectTag.class);
            Label returnLabel = new Label();
            gen.loadLocal(objectLocal);
            gen.cast(objectType);
            gen.invokeStatic(describesMethod);
            gen.jumpIfFalseTo(returnLabel);
            Constructor<?> constructor = property.getDeclaredConstructors()[0];
            gen.constructNew(property);
            gen.stackDuplicate();
            if (constructor.getParameters().length == 1) {
                gen.loadLocal(objectLocal);
                gen.cast(objectType);
            }
            constructor.setAccessible(true);
            gen.invokeSpecial(constructor);
            if (ObjectProperty.class.isAssignableFrom(property)) {
                gen.stackDuplicate();
                gen.loadLocal(objectLocal);
                gen.setInstanceField(OBJECT_PROPERTY_OBJECT_FIELD);
            }
            gen.returnValue(ObjectTag.class);
            gen.advanceAndLabel(returnLabel);
            gen.loadNull();
            gen.returnValue(ObjectTag.class);
            gen.end();
            cw.visitEnd();
            byte[] compiled = cw.toByteArray();
            Class<?> generatedClass = CodeGenUtil.loader.define(className.replace('/', '.'), compiled);
            Object result = generatedClass.getConstructors()[0].newInstance(new Object[0]);
            PropertyGetter getter = (PropertyGetter)result;
            PropertyParser.registerProperty(property, objectType, getter);
        }
        catch (Throwable e) {
            Debug.echoError("Unable to register property '" + DebugInternals.getClassNameOpti(property) + "'!");
            Debug.echoError(e);
        }
    }

    public static boolean isConsistentBrackets(String str, int start) {
        int brackets = 0;
        for (int i = start; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '[') {
                ++brackets;
                continue;
            }
            if (c != ']' || --brackets >= 0) continue;
            return false;
        }
        return brackets == 0;
    }

    public static String escapePropertyKey(String input) {
        if (needsEscapingMatcher.containsAnyMatch(input)) {
            input = CoreUtilities.replace(input, "&", "&amp");
            input = CoreUtilities.replace(input, ";", "&sc");
            input = CoreUtilities.replace(input, "[", "&lb");
            input = CoreUtilities.replace(input, "]", "&rb");
            input = CoreUtilities.replace(input, "=", "&eq");
        }
        return input;
    }

    public static String escapePropertyValue(String input) {
        if (needsEscapingMatcher.containsAnyMatch(input)) {
            int closeBracket;
            int openBracket = input.indexOf(91);
            if (openBracket != -1 && (closeBracket = input.lastIndexOf(93)) > openBracket && PropertyParser.isConsistentBrackets(input, openBracket)) {
                return PropertyParser.escapePropertyValue(input.substring(0, openBracket)) + input.substring(openBracket, closeBracket + 1) + PropertyParser.escapePropertyValue(input.substring(closeBracket + 1));
            }
            input = CoreUtilities.replace(input, "&", "&amp");
            input = CoreUtilities.replace(input, ";", "&sc");
            input = CoreUtilities.replace(input, "[", "&lb");
            input = CoreUtilities.replace(input, "]", "&rb");
            input = CoreUtilities.replace(input, "=", "&eq");
        }
        return input;
    }

    public static String getPropertiesDebuggable(ObjectTag object) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return "";
        }
        StringBuilder prop_string = new StringBuilder(properties.propertiesWithMechs.size() * 10);
        for (PropertyGetter getter : properties.propertiesWithMechs) {
            ObjectTag description;
            Property property = getter.get(object);
            if (property == null || (description = property.getPropertyValueNoDefault()) == null) continue;
            prop_string.append(property.getPropertyId()).append(" <LG>=<Y> ").append(description.debuggable()).append("<LG>; <Y>");
        }
        if (prop_string.length() > 0) {
            return "<LG>[<Y>" + prop_string.substring(0, prop_string.length() - "; <Y>".length()) + "<LG>]";
        }
        return "";
    }

    public static String getPropertiesString(ObjectTag object) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return "";
        }
        StringBuilder prop_string = new StringBuilder(properties.propertiesWithMechs.size() * 10);
        for (PropertyGetter getter : properties.propertiesWithMechs) {
            String description;
            Property property = getter.get(object);
            if (property == null || (description = property.getPropertySavableValue()) == null) continue;
            prop_string.append(property.getPropertyId()).append('=').append(PropertyParser.escapePropertyValue(description)).append(';');
        }
        if (prop_string.length() > 0) {
            return "[" + prop_string.substring(0, prop_string.length() - 1) + "]";
        }
        return "";
    }

    public static MapTag getPropertiesMap(ObjectTag object) {
        MapTag map = new MapTag();
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return map;
        }
        for (PropertyGetter getter : properties.propertiesWithMechs) {
            ObjectTag description;
            Property property = getter.get(object);
            if (property == null || (description = property.getPropertyValueNoDefault()) == null) continue;
            map.putObject(property.getPropertyId(), description);
        }
        return map;
    }

    public static List<Property> getProperties(ObjectTag object, String attribLow) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return empty;
        }
        PropertyGetter getter = properties.propertiesByTag.get(attribLow);
        if (getter != null) {
            Property prop = getter.get(object);
            if (prop == null) {
                return empty;
            }
            return Collections.singletonList(getter.get(object));
        }
        return PropertyParser.getProperties(object);
    }

    public static List<Property> getProperties(ObjectTag object) {
        ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
        if (properties == null) {
            return empty;
        }
        ArrayList<Property> props = new ArrayList<Property>(properties.allProperties.size());
        for (PropertyGetter getter : properties.allProperties) {
            Property prop = getter.get(object);
            if (prop == null) continue;
            props.add(prop);
        }
        return props;
    }

    public static <T extends Adjustable> void registerPropertyTagHandlers(Class<T> type, ObjectTagProcessor<T> processor) {
        processor.registerTag(type, "with", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Adjustable instance = (Adjustable)object.duplicate();
            List<String> properties = ObjectFetcher.separateProperties("[" + attribute.getParam() + "]");
            for (int i = 1; i < properties.size(); ++i) {
                List<String> data = CoreUtilities.split(properties.get(i), '=', 2);
                if (data.size() != 2) {
                    Debug.echoError("Invalid property string '" + properties.get(i) + "'!");
                    continue;
                }
                instance.safeApplyProperty(new Mechanism(data.get(0), ObjectFetcher.pickObjectFor(data.get(1), attribute.context), attribute.context));
            }
            return instance;
        }, new String[0]);
        processor.registerTag(type, "with_single", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Adjustable instance = (Adjustable)object.duplicate();
            List<String> data = CoreUtilities.split(attribute.getParam(), '=', 2);
            if (data.size() != 2) {
                Debug.echoError("Invalid property string '" + attribute.getParam() + "'!");
            } else {
                instance.safeApplyProperty(new Mechanism(data.get(0), ObjectFetcher.pickObjectFor(data.get(1), attribute.context), attribute.context));
            }
            return instance;
        }, new String[0]);
        processor.registerTag(type, "with_map", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            MapTag properties = attribute.paramAsType(MapTag.class);
            if (properties == null) {
                attribute.echoError("Cannot process 'with_map': invalid map input.");
                return null;
            }
            Adjustable instance = (Adjustable)object.duplicate();
            for (Map.Entry<StringHolder, ObjectTag> pair : properties.entrySet()) {
                instance.safeApplyProperty(new Mechanism(pair.getKey().low, pair.getValue(), attribute.context));
            }
            return instance;
        }, new String[0]);
        processor.registerTag(ElementTag.class, "supports", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String propertyName = attribute.getParam();
            ClassPropertiesInfo properties = propertiesByClass.get(object.getClass());
            if (properties == null) {
                return new ElementTag(false);
            }
            PropertyGetter getter = properties.propertiesByMechanism.get(CoreUtilities.toLowerCase(propertyName));
            if (getter == null) {
                return new ElementTag(false);
            }
            return new ElementTag(getter.get(object) != null);
        }, new String[0]);
        processor.registerTag(MapTag.class, "property_map", (attribute, object) -> PropertyParser.getPropertiesMap(object), new String[0]);
    }

    static {
        totalGenerated = 0L;
        GETTER_PATH = Type.getInternalName(PropertyGetter.class);
        GETTER_GET_METHOD = ReflectionHelper.getMethod(PropertyGetter.class, "get", ObjectTag.class);
        GETTER_GET_DESCRIPTOR = Type.getMethodDescriptor(GETTER_GET_METHOD);
        OBJECT_PROPERTY_OBJECT_FIELD = ReflectionHelper.getFields(ObjectProperty.class).get("object", ObjectTag.class);
        needsEscapingMatcher = new AsciiMatcher("&;[]=");
        empty = new ArrayList<Property>();
    }

    @FunctionalInterface
    public static interface PropertyTagWithReturnAndParam<T extends Property, R extends ObjectTag, P extends ObjectTag> {
        public R run(Attribute var1, T var2, P var3);
    }

    @FunctionalInterface
    public static interface PropertyTagWithReturn<T extends Property, R extends ObjectTag> {
        public R run(Attribute var1, T var2);
    }

    @FunctionalInterface
    public static interface PropertyGetter<T extends ObjectTag> {
        public Property get(T var1);
    }

    public static class ClassPropertiesInfo {
        public ObjectType<? extends ObjectTag> objectType;
        public List<PropertyGetter> allProperties = new ArrayList<PropertyGetter>();
        public List<PropertyGetter> propertiesWithMechs = new ArrayList<PropertyGetter>();
        public Map<String, PropertyGetter> propertiesByTag = new HashMap<String, PropertyGetter>();
        public Map<String, PropertyGetter> propertiesByMechanism = new HashMap<String, PropertyGetter>();
        public Map<String, String> propertyNamesByTag = new HashMap<String, String>();
    }

    @FunctionalInterface
    public static interface PropertyMechanism<T extends Property> {
        public void run(T var1, Mechanism var2);
    }

    @FunctionalInterface
    public static interface PropertyMechanismWithParam<T extends Property, P extends ObjectTag> {
        public void run(T var1, Mechanism var2, P var3);
    }
}

