/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.inventory.InventoryContents;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemInventoryContents
extends ItemProperty<ListTag> {
    public static boolean describes(ItemTag item) {
        BlockStateMeta blockStateMeta;
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)itemMeta).getBlockState() instanceof InventoryHolder || item.getItemMeta() instanceof BundleMeta;
    }

    public InventoryTag getItemInventory() {
        InventoryHolder holder = (InventoryHolder)this.as(BlockStateMeta.class).getBlockState();
        Inventory inv = ItemInventoryContents.getInventoryFor(holder);
        return InventoryTag.mirrorBukkitInventory(inv);
    }

    public static Inventory getInventoryFor(InventoryHolder holder) {
        Inventory inventory;
        if (holder instanceof Chest) {
            Chest chest = (Chest)holder;
            inventory = chest.getBlockInventory();
        } else {
            inventory = holder.getInventory();
        }
        return inventory;
    }

    @Override
    public ListTag getPropertyValue() {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            if (!blockStateMeta.hasBlockState()) {
                return null;
            }
            return new InventoryContents(this.getItemInventory()).getContents(false);
        }
        return new ListTag(this.as(BundleMeta.class).getItems(), item -> item != null && item.getType() != Material.AIR, ItemTag::new);
    }

    @Override
    public void setPropertyValue(ListTag value, Mechanism mechanism) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(value.size());
        for (ItemTag itemTag : value.filter(ItemTag.class, mechanism.context)) {
            items.add(itemTag.getItemStack());
        }
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof BlockStateMeta) {
            BlockStateMeta blockStateMeta = (BlockStateMeta)itemMeta;
            BlockState blockState = blockStateMeta.getBlockState();
            Inventory inventory = ItemInventoryContents.getInventoryFor((InventoryHolder)blockState);
            if (items.size() > inventory.getSize()) {
                mechanism.echoError("Input list is too large: must be " + inventory.getSize() + " or less.");
                return;
            }
            inventory.setContents(items.toArray(new ItemStack[0]));
            blockStateMeta.setBlockState(blockState);
            this.setItemMeta((ItemMeta)blockStateMeta);
        } else {
            this.editMeta(BundleMeta.class, bundleMeta -> bundleMeta.setItems(items));
        }
    }

    @Override
    public String getPropertyId() {
        return "inventory_contents";
    }

    public static void register() {
        PropertyParser.registerTag(ItemInventoryContents.class, ListTag.class, "inventory_contents", (attribute, prop) -> {
            BlockStateMeta blockStateMeta;
            ItemMeta patt3757$temp = prop.getItemMeta();
            if (patt3757$temp instanceof BlockStateMeta && !(blockStateMeta = (BlockStateMeta)patt3757$temp).hasBlockState()) {
                return new ListTag();
            }
            return prop.getPropertyValue();
        }, new String[0]);
        PropertyParser.registerMechanism(ItemInventoryContents.class, ListTag.class, "inventory_contents", (prop, mechanism, input) -> prop.setPropertyValue((ListTag)input, mechanism), new String[0]);
        PropertyParser.registerTag(ItemInventoryContents.class, InventoryTag.class, "inventory", (attribute, prop) -> {
            BukkitImplDeprecations.itemInventoryTag.warn(attribute.context);
            return prop.getItemInventory();
        }, new String[0]);
        PropertyParser.registerMechanism(ItemInventoryContents.class, InventoryTag.class, "inventory", (prop, mechanism, input) -> {
            BukkitImplDeprecations.itemInventoryTag.warn(mechanism.context);
            Argument argument = new Argument("");
            argument.unsetValue();
            argument.object = mechanism.getValue();
            AbstractMap.SimpleEntry<Integer, InventoryTag> inventoryPair = Conversion.getInventory(argument, mechanism.context);
            if (inventoryPair == null || ((InventoryTag)inventoryPair.getValue()).getInventory() == null) {
                return;
            }
            ListTag items = new InventoryContents((InventoryTag)inventoryPair.getValue()).getContents(false);
            ItemStack[] itemArray = new ItemStack[items.size()];
            for (int i = 0; i < itemArray.length; ++i) {
                itemArray[i] = ((ItemTag)items.objectForms.get(i)).getItemStack().clone();
            }
            ItemMeta patt5378$temp = prop.getItemMeta();
            if (patt5378$temp instanceof BlockStateMeta) {
                BlockStateMeta blockStateMeta = (BlockStateMeta)patt5378$temp;
                InventoryHolder invHolder = (InventoryHolder)blockStateMeta.getBlockState();
                if (items.size() > ItemInventoryContents.getInventoryFor(invHolder).getSize()) {
                    mechanism.echoError("Invalid inventory mechanism input size; expected " + ItemInventoryContents.getInventoryFor(invHolder).getSize() + " or less.");
                    return;
                }
                ItemInventoryContents.getInventoryFor(invHolder).setContents(itemArray);
                blockStateMeta.setBlockState((BlockState)invHolder);
                prop.setItemMeta((ItemMeta)blockStateMeta);
            } else {
                prop.editMeta(BundleMeta.class, bundleMeta -> bundleMeta.setItems(Arrays.asList(itemArray)));
            }
        }, new String[0]);
    }
}

