/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.command.manager;

import com.denizenscript.denizen.utilities.command.manager.messaging.Messaging;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;

public class Paginator {
    private String header;
    private final List<String> lines = new ArrayList<String>();
    private static final int LINES_PER_PAGE = 9;

    public void addLine(String line) {
        this.lines.add(line);
    }

    public Paginator header(String header) {
        this.header = header;
        return this;
    }

    public boolean sendPage(CommandSender sender, int page) {
        int pages = (int)(this.lines.size() / 9 == 0 ? 1.0 : Math.ceil((double)this.lines.size() / 9.0));
        if (page < 0 || page > pages) {
            return false;
        }
        int startIndex = 9 * page - 9;
        int endIndex = page * 9;
        Messaging.send(sender, Paginator.wrapHeader("<e>" + this.header + " <f>" + page + "/" + pages));
        if (this.lines.size() < endIndex) {
            endIndex = this.lines.size();
        }
        for (String line : this.lines.subList(startIndex, endIndex)) {
            Messaging.send(sender, line);
        }
        return true;
    }

    public static String wrapHeader(Object string) {
        String highlight = "<e>";
        return highlight + "=====[ " + string.toString() + highlight + " ]=====";
    }
}

