/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;

public class LegacyNamingHelper<T extends Enum<T>> {
    private final Set<String> modernNames;
    private final Class<T> enumType;

    public static <T extends Keyed> T convert(Class<T> type, String string) {
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21)) {
            return (T)Bukkit.getRegistry(type).get(Utilities.parseNamespacedKey(string));
        }
        return (T)((Keyed)ElementTag.asEnum(type, string));
    }

    public static <T extends Keyed> Optional<T> requireType(Mechanism mechanism, Class<T> type) {
        T converted = LegacyNamingHelper.convert(type, mechanism.getValue().asString());
        if (converted == null) {
            mechanism.echoError("Invalid " + DebugInternals.getClassNameOpti(type) + " specified: must specify a valid name.");
            return Optional.empty();
        }
        return Optional.of(converted);
    }

    public LegacyNamingHelper(Class<T> enumType) {
        this.enumType = enumType;
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        this.modernNames = new HashSet<String>(enumConstants.length);
        for (Enum enumConstant : enumConstants) {
            this.modernNames.add(enumConstant.name());
        }
    }

    public T fromName(String name, TagContext context) {
        T value;
        String nameUpper = CoreUtilities.toUpperCase(name);
        try {
            value = Enum.valueOf(this.enumType, nameUpper);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && !this.modernNames.contains(nameUpper)) {
            BukkitImplDeprecations.oldSpigotNames.warn(context);
        }
        return value;
    }
}

