/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizen.utilities.LegacyNamingHelper;
import com.denizenscript.denizen.utilities.MultiVersionHelper1_19;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.Arrays;
import org.bukkit.DyeColor;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieVillager;

public class EntityColor
extends EntityProperty<ElementTag> {
    public static final EntityType MOOSHROOM_ENTITY_TYPE = (EntityType)Registry.ENTITY_TYPE.get(NamespacedKey.minecraft((String)"mooshroom"));

    public static boolean describes(EntityTag entity) {
        EntityType type = entity.getBukkitEntityType();
        return type == EntityType.SHEEP || type == EntityType.HORSE || type == EntityType.WOLF || type == EntityType.OCELOT || type == EntityType.RABBIT || type == EntityType.LLAMA || type == EntityType.PARROT || type == EntityType.SHULKER || type == MOOSHROOM_ENTITY_TYPE || type == EntityType.CAT || type == EntityType.FOX || type == EntityType.PANDA || type == EntityType.ARROW || type == EntityType.VILLAGER || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.TRADER_LLAMA || type == EntityType.TROPICAL_FISH || type == EntityType.GOAT || type == EntityType.AXOLOTL || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type);
    }

    @Override
    public ElementTag getPropertyValue() {
        String color = this.getColor(true);
        return color == null ? null : new ElementTag(CoreUtilities.toLowerCase(color));
    }

    @Override
    public String getPropertyId() {
        return "color";
    }

    @Override
    public void setPropertyValue(ElementTag color, Mechanism mechanism) {
        EntityType type = this.getType();
        if (type == EntityType.HORSE && mechanism.requireObject(ListTag.class)) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            Horse horse = this.as(Horse.class);
            ElementTag horseColor = new ElementTag(list.get(0));
            if (horseColor.matchesEnum(Horse.Color.class)) {
                horse.setColor(horseColor.asEnum(Horse.Color.class));
            } else {
                mechanism.echoError("Invalid horse color specified: " + String.valueOf(horseColor));
            }
            if (list.size() > 1) {
                ElementTag style = new ElementTag(list.get(1));
                if (style.matchesEnum(Horse.Style.class)) {
                    horse.setStyle(style.asEnum(Horse.Style.class));
                } else {
                    mechanism.echoError("Invalid horse style specified: " + String.valueOf(style));
                }
            }
        } else if (type == EntityType.SHEEP && mechanism.requireEnum(DyeColor.class)) {
            this.as(Sheep.class).setColor(color.asEnum(DyeColor.class));
        } else if (type == EntityType.WOLF && mechanism.requireEnum(DyeColor.class)) {
            this.as(Wolf.class).setCollarColor(color.asEnum(DyeColor.class));
        } else if (type == EntityType.OCELOT && mechanism.requireEnum(Ocelot.Type.class)) {
            this.as(Ocelot.class).setCatType(color.asEnum(Ocelot.Type.class));
        } else if (type == EntityType.RABBIT && mechanism.requireEnum(Rabbit.Type.class)) {
            this.as(Rabbit.class).setRabbitType(color.asEnum(Rabbit.Type.class));
        } else if ((type == EntityType.LLAMA || type == EntityType.TRADER_LLAMA) && mechanism.requireEnum(Llama.Color.class)) {
            this.as(Llama.class).setColor(color.asEnum(Llama.Color.class));
        } else if (type == EntityType.PARROT && mechanism.requireEnum(Parrot.Variant.class)) {
            this.as(Parrot.class).setVariant(color.asEnum(Parrot.Variant.class));
        } else if (type == EntityType.SHULKER && mechanism.requireEnum(DyeColor.class)) {
            this.as(Shulker.class).setColor(color.asEnum(DyeColor.class));
        } else if (type == MOOSHROOM_ENTITY_TYPE && mechanism.requireEnum(MushroomCow.Variant.class)) {
            this.as(MushroomCow.class).setVariant(color.asEnum(MushroomCow.Variant.class));
        } else if (type == EntityType.TROPICAL_FISH && mechanism.requireObject(ListTag.class)) {
            ListTag list = mechanism.valueAsType(ListTag.class);
            TropicalFish fish = this.as(TropicalFish.class);
            ElementTag pattern = new ElementTag(list.get(0));
            if (pattern.matchesEnum(TropicalFish.Pattern.class)) {
                fish.setPattern(pattern.asEnum(TropicalFish.Pattern.class));
            } else {
                mechanism.echoError("Invalid tropical fish pattern specified: " + String.valueOf(pattern));
            }
            if (list.size() > 1) {
                ElementTag fishColor = new ElementTag(list.get(1));
                if (fishColor.matchesEnum(DyeColor.class)) {
                    fish.setBodyColor(fishColor.asEnum(DyeColor.class));
                } else {
                    mechanism.echoError("Invalid color specified: " + String.valueOf(fishColor));
                }
            }
            if (list.size() > 2) {
                ElementTag patternColor = new ElementTag(list.get(2));
                if (patternColor.matchesEnum(DyeColor.class)) {
                    fish.setPatternColor(patternColor.asEnum(DyeColor.class));
                } else {
                    mechanism.echoError("Invalid pattern color specified: " + String.valueOf(patternColor));
                }
            }
        } else if (type == EntityType.FOX && mechanism.requireEnum(Fox.Type.class)) {
            this.as(Fox.class).setFoxType(color.asEnum(Fox.Type.class));
        } else if (type == EntityType.CAT && mechanism.requireObject(ListTag.class)) {
            Cat cat = this.as(Cat.class);
            ListTag list = mechanism.valueAsType(ListTag.class);
            String catTypeStr = list.get(0);
            Cat.Type catType = LegacyNamingHelper.convert(Cat.Type.class, catTypeStr);
            if (catType != null) {
                cat.setCatType(catType);
            } else {
                mechanism.echoError("Invalid cat type specified: " + catTypeStr);
            }
            if (list.size() > 1) {
                ElementTag collarColor = new ElementTag(list.get(1));
                if (collarColor.matchesEnum(DyeColor.class)) {
                    cat.setCollarColor(collarColor.asEnum(DyeColor.class));
                } else {
                    mechanism.echoError("Invalid color specified: " + String.valueOf(collarColor));
                }
            }
        } else if (type == EntityType.PANDA && mechanism.requireObject(ListTag.class)) {
            Panda panda = this.as(Panda.class);
            ListTag list = mechanism.valueAsType(ListTag.class);
            ElementTag mainGene = new ElementTag(list.get(0));
            if (mainGene.matchesEnum(Panda.Gene.class)) {
                panda.setMainGene(mainGene.asEnum(Panda.Gene.class));
            } else {
                mechanism.echoError("Invalid panda gene specified: " + String.valueOf(mainGene));
            }
            if (list.size() > 1) {
                ElementTag hiddenGene = new ElementTag(list.get(1));
                if (hiddenGene.matchesEnum(Panda.Gene.class)) {
                    panda.setHiddenGene(hiddenGene.asEnum(Panda.Gene.class));
                } else {
                    mechanism.echoError("Invalid panda hidden gene specified: " + String.valueOf(hiddenGene));
                }
            }
        } else if (type == EntityType.VILLAGER) {
            LegacyNamingHelper.requireType(mechanism, Villager.Type.class).ifPresent(arg_0 -> ((Villager)this.as(Villager.class)).setVillagerType(arg_0));
        } else if (type == EntityType.ZOMBIE_VILLAGER) {
            LegacyNamingHelper.requireType(mechanism, Villager.Type.class).ifPresent(arg_0 -> ((ZombieVillager)this.as(ZombieVillager.class)).setVillagerType(arg_0));
        } else if (type == EntityType.ARROW && mechanism.requireObject(ColorTag.class)) {
            this.as(Arrow.class).setColor(BukkitColorExtensions.getColor(mechanism.valueAsType(ColorTag.class)));
        } else if (type == EntityType.GOAT) {
            this.as(Goat.class).setScreaming(color.asLowerString().equals("screaming"));
        } else if (type == EntityType.AXOLOTL && mechanism.requireEnum(Axolotl.Variant.class)) {
            this.as(Axolotl.class).setVariant(color.asEnum(Axolotl.Variant.class));
        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type)) {
            MultiVersionHelper1_19.setColor(this.getEntity(), mechanism);
        }
    }

    public String getColor(boolean includeDeprecated) {
        EntityType type = this.getType();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type)) {
            return MultiVersionHelper1_19.getColor(this.getEntity());
        }
        Entity entity = this.getEntity();
        if (entity instanceof MushroomCow) {
            MushroomCow mushroomCow = (MushroomCow)entity;
            return mushroomCow.getVariant().name();
        }
        return switch (type) {
            case EntityType.HORSE -> {
                Horse horse = this.as(Horse.class);
                String var3_6 = horse.getColor().name() + "|" + horse.getStyle().name();
                yield var3_6;
            }
            case EntityType.SHEEP -> {
                String var3_7 = this.as(Sheep.class).getColor().name();
                yield var3_7;
            }
            case EntityType.WOLF -> {
                String var3_8 = this.as(Wolf.class).getCollarColor().name();
                yield var3_8;
            }
            case EntityType.OCELOT -> {
                if (includeDeprecated) {
                    String var3_9 = this.as(Ocelot.class).getCatType().name();
                    yield var3_9;
                }
                String var3_10 = null;
                yield var3_10;
            }
            case EntityType.RABBIT -> {
                String var3_11 = this.as(Rabbit.class).getRabbitType().name();
                yield var3_11;
            }
            case EntityType.LLAMA, EntityType.TRADER_LLAMA -> {
                String var3_12 = this.as(Llama.class).getColor().name();
                yield var3_12;
            }
            case EntityType.PARROT -> {
                String var3_13 = this.as(Parrot.class).getVariant().name();
                yield var3_13;
            }
            case EntityType.SHULKER -> {
                DyeColor color = this.as(Shulker.class).getColor();
                String var3_14 = color == null ? null : color.name();
                yield var3_14;
            }
            case EntityType.TROPICAL_FISH -> {
                TropicalFish fish = this.as(TropicalFish.class);
                String var3_15 = new ListTag(Arrays.asList(fish.getPattern().name(), fish.getBodyColor().name(), fish.getPatternColor().name())).identify();
                yield var3_15;
            }
            case EntityType.FOX -> {
                String var3_16 = this.as(Fox.class).getFoxType().name();
                yield var3_16;
            }
            case EntityType.CAT -> {
                Cat cat = this.as(Cat.class);
                String var3_17 = String.valueOf(cat.getCatType()) + "|" + cat.getCollarColor().name();
                yield var3_17;
            }
            case EntityType.PANDA -> {
                Panda panda = this.as(Panda.class);
                String var3_18 = panda.getMainGene().name() + "|" + panda.getHiddenGene().name();
                yield var3_18;
            }
            case EntityType.VILLAGER -> {
                String var3_19 = String.valueOf(this.as(Villager.class).getVillagerType());
                yield var3_19;
            }
            case EntityType.ZOMBIE_VILLAGER -> {
                String var3_20 = String.valueOf(this.as(ZombieVillager.class).getVillagerType());
                yield var3_20;
            }
            case EntityType.ARROW -> {
                try {
                    String var3_21 = BukkitColorExtensions.fromColor(this.as(Arrow.class).getColor()).identify();
                    yield var3_21;
                }
                catch (Exception e) {
                    String var3_22 = null;
                    yield var3_22;
                }
            }
            case EntityType.GOAT -> {
                String var3_23 = this.as(Goat.class).isScreaming() ? "screaming" : "normal";
                yield var3_23;
            }
            case EntityType.AXOLOTL -> {
                String var3_24 = this.as(Axolotl.class).getVariant().name();
                yield var3_24;
            }
            default -> {
                String var3_25 = null;
                yield var3_25;
            }
        };
    }

    public ListTag getAllowedColors() {
        EntityType type = this.getType();
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && MultiVersionHelper1_19.colorIsApplicable(type)) {
            return MultiVersionHelper1_19.getAllowedColors(type);
        }
        if (type == MOOSHROOM_ENTITY_TYPE) {
            return Utilities.listTypes(MushroomCow.Variant.class);
        }
        return switch (type) {
            case EntityType.HORSE -> {
                ListTag horseColors = Utilities.listTypes(Horse.Color.class);
                horseColors.addAll(Utilities.listTypes(Horse.Style.class));
                yield horseColors;
            }
            case EntityType.SHEEP, EntityType.WOLF, EntityType.SHULKER -> Utilities.listTypes(DyeColor.class);
            case EntityType.RABBIT -> Utilities.listTypes(Rabbit.Type.class);
            case EntityType.LLAMA, EntityType.TRADER_LLAMA -> Utilities.listTypes(Llama.Color.class);
            case EntityType.PARROT -> Utilities.listTypes(Parrot.Variant.class);
            case EntityType.TROPICAL_FISH -> {
                ListTag patterns = Utilities.listTypes(TropicalFish.Pattern.class);
                patterns.addAll(Utilities.listTypes(DyeColor.class));
                yield patterns;
            }
            case EntityType.FOX -> Utilities.listTypes(Fox.Type.class);
            case EntityType.CAT -> Utilities.listTypes(Cat.Type.class);
            case EntityType.PANDA -> Utilities.listTypes(Panda.Gene.class);
            case EntityType.VILLAGER, EntityType.ZOMBIE_VILLAGER -> Utilities.listTypes(Villager.Type.class);
            case EntityType.GOAT -> {
                ListTag result = new ListTag();
                result.add("screaming");
                result.add("normal");
                yield result;
            }
            case EntityType.AXOLOTL -> Utilities.listTypes(Axolotl.Variant.class);
            default -> null;
        };
    }

    public static void register() {
        EntityColor.autoRegister("color", EntityColor.class, ElementTag.class, false, new String[0]);
        PropertyParser.registerTag(EntityColor.class, ListTag.class, "allowed_colors", (attribute, object) -> object.getAllowedColors(), new String[0]);
    }
}

