/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.LegacyNamingHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;

public class EntityProfession
implements Property {
    public static final String[] handledTags = new String[]{"profession"};
    public static final String[] handledMechs = new String[]{"profession"};
    EntityTag professional;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).getBukkitEntityType() == EntityType.VILLAGER || ((EntityTag)entity).getBukkitEntityType() == EntityType.ZOMBIE_VILLAGER;
    }

    public static EntityProfession getFrom(ObjectTag entity) {
        if (!EntityProfession.describes(entity)) {
            return null;
        }
        return new EntityProfession((EntityTag)entity);
    }

    public EntityProfession(EntityTag entity) {
        this.professional = entity;
    }

    public Villager.Profession getProfession() {
        if (this.professional.getBukkitEntityType() == EntityType.ZOMBIE_VILLAGER) {
            return ((ZombieVillager)this.professional.getBukkitEntity()).getVillagerProfession();
        }
        return ((Villager)this.professional.getBukkitEntity()).getProfession();
    }

    public void setProfession(Villager.Profession profession) {
        if (this.professional.getBukkitEntityType() == EntityType.ZOMBIE_VILLAGER) {
            ((ZombieVillager)this.professional.getBukkitEntity()).setVillagerProfession(profession);
        } else {
            ((Villager)this.professional.getBukkitEntity()).setProfession(profession);
        }
    }

    @Override
    public String getPropertyString() {
        return CoreUtilities.toLowerCase(String.valueOf(this.getProfession()));
    }

    @Override
    public String getPropertyId() {
        return "profession";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("profession")) {
            return new ElementTag(String.valueOf(this.getProfession()), true).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("profession")) {
            LegacyNamingHelper.requireType(mechanism, Villager.Profession.class).ifPresent(this::setProfession);
        }
    }
}

