/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class ItemFrameInvisible
implements Property {
    public static final String[] handledTags = new String[]{"invisible"};
    public static final String[] handledMechs = new String[]{"invisible"};
    ItemTag item;

    public static boolean describes(ObjectTag object) {
        return object instanceof ItemTag && (((ItemTag)object).getBukkitMaterial() == Material.ITEM_FRAME || ((ItemTag)object).getBukkitMaterial() == Material.GLOW_ITEM_FRAME);
    }

    public static ItemFrameInvisible getFrom(ObjectTag object) {
        if (!ItemFrameInvisible.describes(object)) {
            return null;
        }
        return new ItemFrameInvisible((ItemTag)object);
    }

    public ItemFrameInvisible(ItemTag item) {
        this.item = item;
    }

    public boolean isInvisible() {
        CompoundTag entityNbt = NMSHandler.itemHelper.getEntityData(this.item.getItemStack());
        if (entityNbt == null) {
            return false;
        }
        byte b = entityNbt.getByte("Invisible");
        return b == 1;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("invisible")) {
            return new ElementTag(this.isInvisible()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.isInvisible()) {
            return "true";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "invisible";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("invisible") && mechanism.requireBoolean()) {
            CompoundTag entityNbt = NMSHandler.itemHelper.getEntityData(this.item.getItemStack());
            boolean invisible = mechanism.getValue().asBoolean();
            if (!invisible && entityNbt == null) {
                return;
            }
            if (invisible) {
                CompoundTagBuilder builder = entityNbt != null ? entityNbt.createBuilder() : CompoundTagBuilder.create();
                entityNbt = builder.putByte("Invisible", (byte)1).build();
            } else {
                entityNbt = entityNbt.createBuilder().remove("Invisible").build();
            }
            this.item.setItemStack(NMSHandler.itemHelper.setEntityData(this.item.getItemStack(), entityNbt, this.item.getBukkitMaterial() == Material.ITEM_FRAME ? EntityType.ITEM_FRAME : EntityType.GLOW_ITEM_FRAME));
        }
    }
}

