/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapView;

public abstract class MapObject {
    protected String xTag;
    protected String yTag;
    protected String visibilityTag;
    protected Map<UUID, Boolean> currentVisibility = new HashMap<UUID, Boolean>();
    protected boolean debug;
    public boolean showPastEdge = false;
    public MapView lastMap;
    public boolean worldCoordinates = false;

    public MapObject(String xTag, String yTag, String visibilityTag, boolean debug) {
        this.xTag = xTag;
        this.yTag = yTag;
        this.visibilityTag = visibilityTag;
        this.debug = debug;
    }

    public void update(PlayerTag player, UUID uuid) {
        this.currentVisibility.put(uuid, this.tag(this.visibilityTag, player).equalsIgnoreCase("true"));
    }

    public int getX(PlayerTag player) {
        int x = (int)Double.parseDouble(this.tag(this.xTag, player));
        if (this.worldCoordinates && this.lastMap != null) {
            float f = (float)(x - this.lastMap.getCenterX()) / (float)(2 << this.lastMap.getScale().getValue());
            x = (int)((double)(f * 2.0f) + 0.5) + 64;
            if (this.showPastEdge) {
                x = Math.max(Math.min(x, 127), 0);
            }
        }
        return x;
    }

    public int getY(PlayerTag player) {
        int y = (int)Double.parseDouble(this.tag(this.yTag, player));
        if (this.worldCoordinates && this.lastMap != null) {
            float f1 = (float)(y - this.lastMap.getCenterZ()) / (float)(2 << this.lastMap.getScale().getValue());
            y = (int)((double)(f1 * 2.0f) + 0.5) + 64;
            if (this.showPastEdge) {
                y = Math.max(Math.min(y, 127), 0);
            }
        }
        return y;
    }

    public boolean isVisibleTo(PlayerTag player) {
        if (!this.currentVisibility.containsKey(player.getUUID())) {
            this.currentVisibility.put(player.getUUID(), this.tag(this.visibilityTag, player).equalsIgnoreCase("true"));
        }
        return this.currentVisibility.get(player.getUUID());
    }

    public TagContext getTagContext(PlayerTag player) {
        return new BukkitTagContext(player, player.getSelectedNPC(), null, this.debug, null);
    }

    protected String tag(String arg, PlayerTag player) {
        return TagManager.tag(arg, this.getTagContext(player));
    }

    public Map<String, Object> getSaveData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("x", this.xTag);
        data.put("y", this.yTag);
        data.put("visibility", this.visibilityTag);
        data.put("debug", this.debug ? "true" : "false");
        data.put("world_coordinates", this.worldCoordinates ? "true" : "false");
        data.put("show_past_edge", this.showPastEdge ? "true" : "false");
        return data;
    }

    public abstract void render(MapView var1, MapCanvas var2, PlayerTag var3, UUID var4);
}

