/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.entity;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HideEntitiesHelper {
    public static HashMap<UUID, PlayerHideMap> playerHides = new HashMap();
    public static HashSet<UUID> defaultHidden = new HashSet();
    public static EnforcePlayerHides EPH = null;

    public static boolean hasAnyHides() {
        return !playerHides.isEmpty() || !defaultHidden.isEmpty();
    }

    public static PlayerHideMap getPlayerMapFor(UUID player) {
        PlayerHideMap map = playerHides.get(player);
        if (map == null) {
            map = new PlayerHideMap();
            map.player = player;
            playerHides.put(player, map);
        }
        return map;
    }

    public static boolean playerShouldHide(UUID player, Entity ent) {
        PlayerHideMap map = playerHides.get(player);
        if (map == null) {
            return defaultHidden.contains(ent.getUniqueId()) && !player.equals(ent.getUniqueId());
        }
        return map.shouldHide(ent);
    }

    public static boolean addHide(UUID player, UUID entity) {
        NetworkInterceptHelper.enable();
        HideEntitiesHelper.ensurePlayerHiding();
        if (player == null) {
            return defaultHidden.add(entity);
        }
        PlayerHideMap map = HideEntitiesHelper.getPlayerMapFor(player);
        map.overridinglyShow.remove(entity);
        return map.entitiesHidden.add(entity);
    }

    public static void hideEntity(Player player, Entity entity) {
        if (HideEntitiesHelper.addHide(player == null ? null : player.getUniqueId(), entity.getUniqueId())) {
            if (player == null) {
                for (Player pl : Bukkit.getOnlinePlayers()) {
                    NMSHandler.entityHelper.sendHidePacket(pl, entity);
                }
            } else {
                NMSHandler.entityHelper.sendHidePacket(player, entity);
            }
        }
    }

    public static boolean removeHide(UUID player, UUID entity) {
        NetworkInterceptHelper.enable();
        if (player == null) {
            return defaultHidden.remove(entity);
        }
        PlayerHideMap map = playerHides.get(player);
        if (defaultHidden.contains(entity) || map != null && map.shouldHideViaMatcher(Bukkit.getEntity((UUID)entity))) {
            if (map == null) {
                map = new PlayerHideMap();
                map.player = player;
                playerHides.put(player, map);
            }
            map.entitiesHidden.remove(entity);
            return map.overridinglyShow.add(entity);
        }
        if (map == null) {
            return false;
        }
        boolean result = map.entitiesHidden.remove(entity);
        if (result && map.entitiesHidden.isEmpty() && map.overridinglyShow.isEmpty() && map.matchersHidden.isEmpty()) {
            playerHides.remove(player);
        }
        return result;
    }

    public static void unhideEntity(Player player, Entity entity) {
        if (HideEntitiesHelper.removeHide(player == null ? null : player.getUniqueId(), entity.getUniqueId())) {
            if (player == null) {
                for (Player pl : Bukkit.getOnlinePlayers()) {
                    NMSHandler.entityHelper.sendShowPacket(pl, entity);
                }
            } else {
                NMSHandler.entityHelper.sendShowPacket(player, entity);
            }
        }
    }

    public static void ensurePlayerHiding() {
        if (EPH == null) {
            EPH = new EnforcePlayerHides();
            Bukkit.getPluginManager().registerEvents((Listener)EPH, (Plugin)Denizen.getInstance());
        }
    }

    public static class PlayerHideMap {
        public UUID player;
        public HashSet<UUID> entitiesHidden = new HashSet();
        public HashSet<UUID> overridinglyShow = new HashSet();
        public HashSet<String> matchersHidden = new HashSet();

        public boolean shouldHideViaMatcher(Entity entity) {
            if (entity == null) {
                return false;
            }
            if (!this.matchersHidden.isEmpty()) {
                if (this.overridinglyShow.contains(entity.getUniqueId())) {
                    return false;
                }
                EntityTag entityTag = new EntityTag(entity);
                for (String matchable : this.matchersHidden) {
                    Player thisPlayer;
                    if (!entityTag.tryAdvancedMatcher(matchable, CoreUtilities.noDebugContext)) continue;
                    if (entity instanceof Player && (thisPlayer = Bukkit.getPlayer((UUID)this.player)) != null && thisPlayer.canSee((Player)entity)) {
                        thisPlayer.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean shouldHide(Entity entity) {
            if (entity == null) {
                return false;
            }
            if (this.overridinglyShow.contains(entity.getUniqueId())) {
                return false;
            }
            if (this.entitiesHidden.contains(entity.getUniqueId())) {
                return true;
            }
            if (defaultHidden.contains(entity.getUniqueId())) {
                return true;
            }
            return this.shouldHideViaMatcher(entity);
        }
    }

    public static class EnforcePlayerHides
    implements Listener {
        @EventHandler
        public void onPlayerJoin(PlayerJoinEvent event) {
            for (UUID id : defaultHidden) {
                Player pTarget = Bukkit.getPlayer((UUID)id);
                if (pTarget == null) continue;
                event.getPlayer().hidePlayer((Plugin)Denizen.getInstance(), pTarget);
            }
            final Player pl = event.getPlayer();
            final PlayerHideMap map = playerHides.get(pl.getUniqueId());
            if (map == null) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    block4: {
                        if (!pl.isOnline()) break block4;
                        if (map.matchersHidden != null) {
                            for (Entity entity : pl.getWorld().getEntities()) {
                                if (!map.shouldHide(entity)) continue;
                                NMSHandler.entityHelper.sendHidePacket(pl, entity);
                            }
                        } else {
                            for (UUID id : map.entitiesHidden) {
                                Entity ent = Bukkit.getEntity((UUID)id);
                                if (ent == null) continue;
                                NMSHandler.entityHelper.sendHidePacket(pl, ent);
                            }
                        }
                    }
                }
            }.runTaskLater((Plugin)Denizen.getInstance(), 5L);
        }
    }
}

