/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.tags.TagContext;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;

public class BlockDispensesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public ItemTag item;
    private MaterialTag material;
    public BlockDispenseEvent event;

    public BlockDispensesScriptEvent() {
        this.registerCouldMatcher("<block> dispenses <item>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(2, this.item)) {
            return false;
        }
        if (!path.tryArgObject(0, this.material)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ItemTag it;
        LocationTag vel;
        if (determinationObj.canBeType(LocationTag.class) && (vel = determinationObj.asType(LocationTag.class, (TagContext)this.getTagContext(path))) != null) {
            this.event.setVelocity(vel.toVector());
            return true;
        }
        if (determinationObj.canBeType(ItemTag.class) && (it = determinationObj.asType(ItemTag.class, (TagContext)this.getTagContext(path))) != null) {
            this.item = it;
            this.event.setItem(this.item.getItemStack());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
            case "item": {
                return this.item;
            }
            case "velocity": {
                return new LocationTag(this.event.getVelocity());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockDispenses(BlockDispenseEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.item = new ItemTag(event.getItem());
        this.event = event;
        this.fire((Event)event);
    }
}

