/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;

public class EntityDisplay
extends EntityProperty<ElementTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof ItemDisplay || entity.getBukkitEntity() instanceof TextDisplay;
    }

    @Override
    public ElementTag getPropertyValue() {
        Entity entity = this.getEntity();
        if (entity instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            return new ElementTag((Enum<?>)itemDisplay.getItemDisplayTransform());
        }
        return new ElementTag((Enum<?>)this.as(TextDisplay.class).getAlignment());
    }

    @Override
    public boolean isDefaultValue(ElementTag value) {
        if (this.getEntity() instanceof ItemDisplay) {
            return value.asEnum(ItemDisplay.ItemDisplayTransform.class) == ItemDisplay.ItemDisplayTransform.NONE;
        }
        return value.asEnum(TextDisplay.TextAlignment.class) == TextDisplay.TextAlignment.CENTER;
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        Entity entity = this.getEntity();
        if (entity instanceof ItemDisplay) {
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            if (mechanism.requireEnum(ItemDisplay.ItemDisplayTransform.class)) {
                itemDisplay.setItemDisplayTransform(value.asEnum(ItemDisplay.ItemDisplayTransform.class));
            }
        } else if (mechanism.requireEnum(TextDisplay.TextAlignment.class)) {
            this.as(TextDisplay.class).setAlignment(value.asEnum(TextDisplay.TextAlignment.class));
        }
    }

    @Override
    public String getPropertyId() {
        return "display";
    }

    public static void register() {
        EntityDisplay.autoRegister("display", EntityDisplay.class, ElementTag.class, false, new String[0]);
    }
}

