/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Candle;
import org.bukkit.block.data.type.FlowerBed;
import org.bukkit.block.data.type.LeafLitter;
import org.bukkit.block.data.type.PinkPetals;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.block.data.type.SeaPickle;
import org.bukkit.block.data.type.TurtleEgg;

public class MaterialCount
extends MaterialProperty<ElementTag> {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof SeaPickle || data instanceof TurtleEgg || data instanceof RespawnAnchor || data instanceof Candle || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && data instanceof PinkPetals || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (data instanceof FlowerBed || data instanceof LeafLitter);
    }

    @Override
    public ElementTag getPropertyValue() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof SeaPickle) {
            SeaPickle seaPickle = (SeaPickle)blockData;
            return new ElementTag(seaPickle.getPickles());
        }
        blockData = this.getBlockData();
        if (blockData instanceof TurtleEgg) {
            TurtleEgg turtleEgg = (TurtleEgg)blockData;
            return new ElementTag(turtleEgg.getEggs());
        }
        blockData = this.getBlockData();
        if (blockData instanceof RespawnAnchor) {
            RespawnAnchor respawnAnchor = (RespawnAnchor)blockData;
            return new ElementTag(respawnAnchor.getCharges());
        }
        blockData = this.getBlockData();
        if (blockData instanceof Candle) {
            Candle candle = (Candle)blockData;
            return new ElementTag(candle.getCandles());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (blockData = this.getBlockData()) instanceof PinkPetals) {
            PinkPetals pinkPetals = (PinkPetals)blockData;
            return new ElementTag(pinkPetals.getFlowerAmount());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof FlowerBed) {
            FlowerBed flowerBed = (FlowerBed)blockData;
            return new ElementTag(flowerBed.getFlowerAmount());
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof LeafLitter) {
            LeafLitter leafLitter = (LeafLitter)blockData;
            return new ElementTag(leafLitter.getSegmentAmount());
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        if (mechanism.requireInteger()) {
            int count = value.asInt();
            if (count < this.getMin() || count > this.getMax()) {
                mechanism.echoError("Material count mechanism value '" + count + "' is not valid. Must be between " + this.getMin() + " and " + this.getMax() + ".");
                return;
            }
            BlockData blockData = this.getBlockData();
            if (blockData instanceof SeaPickle) {
                SeaPickle seaPickle = (SeaPickle)blockData;
                seaPickle.setPickles(count);
            } else {
                blockData = this.getBlockData();
                if (blockData instanceof TurtleEgg) {
                    TurtleEgg turtleEgg = (TurtleEgg)blockData;
                    turtleEgg.setEggs(count);
                } else {
                    blockData = this.getBlockData();
                    if (blockData instanceof RespawnAnchor) {
                        RespawnAnchor respawnAnchor = (RespawnAnchor)blockData;
                        respawnAnchor.setCharges(count);
                    } else {
                        blockData = this.getBlockData();
                        if (blockData instanceof Candle) {
                            Candle candle = (Candle)blockData;
                            candle.setCandles(count);
                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (blockData = this.getBlockData()) instanceof PinkPetals) {
                            PinkPetals pinkPetals = (PinkPetals)blockData;
                            pinkPetals.setFlowerAmount(count);
                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof FlowerBed) {
                            FlowerBed flowerBed = (FlowerBed)blockData;
                            flowerBed.setFlowerAmount(count);
                        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof LeafLitter) {
                            LeafLitter leafLitter = (LeafLitter)blockData;
                            leafLitter.setSegmentAmount(count);
                        }
                    }
                }
            }
        }
    }

    @Override
    public String getPropertyId() {
        return "count";
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialCount.class, ElementTag.class, "count_max", (attribute, material) -> new ElementTag(material.getMax()), "pickle_max");
        PropertyParser.registerStaticTag(MaterialCount.class, ElementTag.class, "count_min", (attribute, material) -> new ElementTag(material.getMin()), "pickle_min");
        MaterialCount.autoRegister("count", MaterialCount.class, ElementTag.class, false, "pickle_count");
    }

    public int getMax() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof SeaPickle) {
            SeaPickle seaPickle = (SeaPickle)blockData;
            return seaPickle.getMaximumPickles();
        }
        blockData = this.getBlockData();
        if (blockData instanceof TurtleEgg) {
            TurtleEgg turtleEgg = (TurtleEgg)blockData;
            return turtleEgg.getMaximumEggs();
        }
        blockData = this.getBlockData();
        if (blockData instanceof RespawnAnchor) {
            RespawnAnchor respawnAnchor = (RespawnAnchor)blockData;
            return respawnAnchor.getMaximumCharges();
        }
        blockData = this.getBlockData();
        if (blockData instanceof Candle) {
            Candle candle = (Candle)blockData;
            return candle.getMaximumCandles();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && (blockData = this.getBlockData()) instanceof PinkPetals) {
            PinkPetals pinkPetals = (PinkPetals)blockData;
            return pinkPetals.getMaximumFlowerAmount();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof FlowerBed) {
            FlowerBed flowerBed = (FlowerBed)blockData;
            return flowerBed.getMaximumFlowerAmount();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && (blockData = this.getBlockData()) instanceof LeafLitter) {
            LeafLitter leafLitter = (LeafLitter)blockData;
            return leafLitter.getMaximumSegmentAmount();
        }
        throw new UnsupportedOperationException();
    }

    public int getMin() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof SeaPickle) {
            SeaPickle seaPickle = (SeaPickle)blockData;
            return seaPickle.getMinimumPickles();
        }
        blockData = this.getBlockData();
        if (blockData instanceof TurtleEgg) {
            TurtleEgg turtleEgg = (TurtleEgg)blockData;
            return turtleEgg.getMinimumEggs();
        }
        if (this.getBlockData() instanceof RespawnAnchor) {
            return 0;
        }
        if (this.getBlockData() instanceof Candle) {
            return 1;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19) && this.getBlockData() instanceof PinkPetals) {
            return 1;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && this.getBlockData() instanceof FlowerBed) {
            return 1;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_21) && this.getBlockData() instanceof LeafLitter) {
            return 1;
        }
        throw new UnsupportedOperationException();
    }
}

