/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.core;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.core.CooldownCommand;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class ResetCommand
extends AbstractCommand {
    public ResetCommand() {
        this.setName("reset");
        this.setSyntax("reset (<player>|...) [cooldown/saves/global_cooldown] (<script>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (arg.matches("cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.PLAYER_COOLDOWN);
                continue;
            }
            if (arg.matches("global_cooldown") && !scriptEntry.hasObject("type")) {
                scriptEntry.addObject("type", (Object)Type.GLOBAL_COOLDOWN);
                continue;
            }
            if (arg.matchesArgumentType(ScriptTag.class)) {
                scriptEntry.addObject("script", arg.asType(ScriptTag.class));
                continue;
            }
            if (arg.matchesArgumentList(PlayerTag.class)) {
                scriptEntry.addObject("players", arg.asType(ListTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.getObject("type").equals((Object)Type.GLOBAL_COOLDOWN)) {
            scriptEntry.defaultObject("players", Utilities.getEntryPlayer(scriptEntry));
        }
        if (!scriptEntry.hasObject("script")) {
            throw new InvalidArgumentsException("Must specify a script!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ObjectTag player = (ObjectTag)scriptEntry.getObjectTag("players");
        ListTag players = player instanceof PlayerTag ? new ListTag(player) : (ListTag)scriptEntry.getObjectTag("players");
        Type type = (Type)((Object)scriptEntry.getObject("type"));
        ScriptTag script = (ScriptTag)scriptEntry.getObjectTag("script");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), players, ResetCommand.db("type", (Object)type), script);
        }
        if (type == Type.GLOBAL_COOLDOWN) {
            CooldownCommand.setCooldown(null, new DurationTag(0), script.getName(), true);
            return;
        }
        for (String object : players) {
            PlayerTag resettable = PlayerTag.valueOf(object, scriptEntry.context);
            if (!resettable.isValid()) continue;
            switch (type.ordinal()) {
                case 0: {
                    CooldownCommand.setCooldown(resettable, new DurationTag(0), script.getName(), false);
                    return;
                }
            }
        }
    }

    private static enum Type {
        PLAYER_COOLDOWN,
        GLOBAL_COOLDOWN;

    }
}

