/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.world.GameRuleReflect;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.lang.constant.Constable;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.generator.WorldInfo;

public class GameRuleCommand
extends AbstractCommand {
    public GameRuleCommand() {
        this.setName("gamerule");
        this.setSyntax("gamerule [<world>] [<rule>] [<value>]");
        this.setRequiredArguments(3, 3);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        for (GameRule<?> gameRule : GameRuleReflect.values()) {
            tab.add(GameRuleReflect.getName(gameRule));
        }
        tab.add(Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("gamerule")) {
                scriptEntry.addObject("gamerule", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("value")) {
                scriptEntry.addObject("value", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("world")) {
            throw new InvalidArgumentsException("Must specify a world!");
        }
        if (!scriptEntry.hasObject("gamerule")) {
            throw new InvalidArgumentsException("Must specify a gamerule!");
        }
        if (!scriptEntry.hasObject("value")) {
            throw new InvalidArgumentsException("Must specify a value!");
        }
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        Constable convertedValue;
        GameRule<?> gameRule;
        WorldTag world = (WorldTag)scriptEntry.getObjectTag("world");
        ElementTag gameRuleInput = scriptEntry.getElement("gamerule");
        ElementTag valueInput = scriptEntry.getElement("value");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), world, gameRuleInput, valueInput);
        }
        if ((gameRule = GameRuleReflect.getByName(gameRuleInput.asString())) == null) {
            Debug.echoError("Invalid game rule specified: " + gameRuleInput.asString() + ".");
            return;
        }
        Class<?> gameRuleType = GameRuleReflect.getType(gameRule);
        if (gameRuleType == Integer.class) {
            if (!valueInput.isInt()) {
                Debug.echoError("Invalid value specified: must be a number.");
                return;
            }
            convertedValue = valueInput.asInt();
        } else if (gameRuleType == Boolean.class) {
            if (!valueInput.isBoolean()) {
                Debug.echoError("Invalid value specified: must be a boolean.");
                return;
            }
            convertedValue = Boolean.valueOf(valueInput.asBoolean());
        } else {
            Debug.echoError("Unrecognized game rule type '" + DebugInternals.getFullClassNameOpti(gameRuleType) + "'! Please report this to the developers.");
            return;
        }
        if (!world.getWorld().setGameRule(gameRule, (Object)convertedValue)) {
            Debug.echoError(scriptEntry, "Invalid gamerule!");
        }
    }
}

