/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.containers.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptFormattingContext;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.SimpleDefinitionProvider;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class FormatScriptContainer
extends ScriptContainer {
    final ParseableTag formatTag;
    ScriptFormattingContext asFormattingContext = null;

    public FormatScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        super(configurationSection, scriptContainerName);
        this.canRunScripts = false;
        this.formatTag = this.getCachedTag("format");
        if (this.formatTag == null) {
            Debug.echoError(this, "Invalid format script: must have a 'format' key.");
        } else {
            this.handlePseudoTagBasesDeprecation("format", "<text", "<name");
        }
    }

    public ParseableTag getFormatTag() {
        return this.formatTag;
    }

    public ScriptFormattingContext getAsFormattingContext() {
        if (this.asFormattingContext == null) {
            this.asFormattingContext = new ScriptFormattingContext(null, this.formatTag);
        }
        return this.asFormattingContext;
    }

    public String getRawFormat() {
        return this.getString("format", "<[text]>");
    }

    public String getFormattedText(String text, ScriptEntry entry) {
        return this.getFormattedText(text, entry.getContext());
    }

    public String getFormattedText(String textToReplace, TagContext context) {
        return FormatScriptContainer.formatText(this.formatTag, textToReplace, context, this.getAsScriptArg());
    }

    public static String formatText(ParseableTag formatTag, String rawText, TagContext context, ScriptTag source) {
        if (formatTag == null) {
            return rawText;
        }
        TagContext changedContext = context.clone();
        changedContext.script = source;
        changedContext.definitionProvider = new SimpleDefinitionProvider(changedContext.definitionProvider);
        changedContext.definitionProvider.addDefinition("text", new ElementTag(rawText, true));
        DenizenCore.implementation.addFormatScriptDefinitions(changedContext.definitionProvider, changedContext);
        return formatTag.parse(changedContext).identify();
    }
}

