/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockIgniteEvent;

public class BlockIgnitesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public LocationTag location;
    public MaterialTag material;
    public ElementTag cause;
    public BlockIgniteEvent event;

    public BlockIgnitesScriptEvent() {
        this.registerCouldMatcher("block ignites");
        this.registerSwitches("cause");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!BlockIgnitesScriptEvent.runGenericSwitchCheck(path, "cause", this.cause.asString())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "material" -> new MaterialTag(this.event.getBlock());
            case "cause" -> this.cause;
            case "entity" -> {
                if (this.event.getIgnitingEntity() != null) {
                    yield new EntityTag(this.event.getIgnitingEntity()).getDenizenObject();
                }
                yield null;
            }
            case "origin_location" -> {
                if (this.event.getIgnitingBlock() != null) {
                    yield new LocationTag(this.event.getIgnitingBlock().getLocation());
                }
                yield null;
            }
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onBlockIgnites(BlockIgniteEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.cause = new ElementTag((Enum<?>)event.getCause());
        this.event = event;
        this.fire((Event)event);
    }
}

