/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.inventory.InventoryTrackerSystem;
import com.denizenscript.denizen.utilities.inventory.InventoryViewUtil;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.core.FlagCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgRaw;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.data.ActionableDataProvider;
import com.denizenscript.denizencore.utilities.data.DataAction;
import com.denizenscript.denizencore.utilities.data.DataActionHelper;
import java.util.AbstractMap;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class InventoryCommand
extends AbstractCommand
implements Listener {
    public static Player currentAltPlayer;
    public static Location currentAltLocation;
    public static String currentAltTitle;
    public static String currentAltType;
    public static ObjectTag currentAltHolder;

    public InventoryCommand() {
        this.setName("inventory");
        this.setSyntax("inventory [open/close/copy/move/swap/set/keep/exclude/fill/clear/update/adjust <mechanism>:<value>/flag <name>(:<action>)[:<value>] (expire:<time>)] (destination:<inventory>) (origin:<inventory>/<item>|...) (slot:<slot>)");
        this.setRequiredArguments(1, 6);
        this.isProcedural = false;
        this.allowedDynamicPrefixes = true;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Denizen.instance);
        this.autoCompile();
        this.addRemappedPrefixes("origin", "o", "source", "items", "i", "from", "f");
        this.addRemappedPrefixes("destination", "dest", "d", "target", "to", "t");
        this.addRemappedPrefixes("slot", "s");
        this.addRemappedPrefixes("expiration", "expires", "expire", "duration");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.add(PropertyParser.propertiesByClass.get(ItemTag.class).propertiesByMechanism.keySet());
        if (tab.arg.contains(":")) {
            Consumer<String> addAll = s -> {
                tab.add("o:" + s);
                tab.add("origin:" + s);
                tab.add("d:" + s);
                tab.add("dest:" + s);
                tab.add("destination:" + s);
            };
            for (InventoryTag inventoryTag : NoteManager.notesByType.get(InventoryTag.class)) {
                addAll.accept(inventoryTag.noteName);
            }
            for (String string : InventoryScriptHelper.inventoryScripts.keySet()) {
                addAll.accept(string);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onOpen(InventoryOpenEvent event) {
        if (currentAltHolder == null || currentAltPlayer == null) {
            return;
        }
        if (event.getInventory().getLocation() == null || currentAltLocation.distanceSquared(event.getInventory().getLocation()) > 1.0) {
            return;
        }
        if (!event.getPlayer().getUniqueId().equals(currentAltPlayer.getUniqueId())) {
            return;
        }
        if (currentAltTitle != null && NMSHandler.getVersion().isAtLeast(NMSVersion.v1_18)) {
            NMSHandler.getInstance().setInventoryTitle(event.getView(), currentAltTitle);
        }
        InventoryTag newTag = new InventoryTag(event.getInventory(), currentAltType, currentAltHolder);
        InventoryTrackerSystem.trackTemporaryInventory(event.getInventory(), newTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSpecialOpen(InventoryType type, Player player, InventoryTag destination) {
        try {
            InventoryView view;
            if (destination.customTitle != null || destination.idType.equals("script")) {
                currentAltType = destination.getIdType();
                currentAltTitle = destination.customTitle;
                currentAltHolder = destination.getIdHolder();
                currentAltPlayer = player;
                currentAltLocation = player.getLocation();
                currentAltLocation.setX((double)currentAltLocation.getBlockX());
                currentAltLocation.setZ((double)currentAltLocation.getBlockZ());
                currentAltLocation.setY(-1000.0);
            }
            if (type == InventoryType.ANVIL) {
                view = PaperAPITools.instance.openAnvil(player, currentAltLocation);
            } else if (type == InventoryType.WORKBENCH) {
                view = player.openWorkbench(currentAltLocation, true);
            } else {
                return;
            }
            Inventory newInv = InventoryViewUtil.getTopInventory(view);
            newInv.setContents(destination.getContents());
        }
        finally {
            currentAltHolder = null;
            currentAltType = null;
            currentAltPlayer = null;
            currentAltLocation = null;
            currentAltTitle = null;
        }
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="actions") @ArgLinear @ArgSubType(value=Action.class) List<Action> actions, @ArgName(value="origin") @ArgRaw @ArgPrefixed @ArgDefaultNull String originString, @ArgName(value="destination") @ArgRaw @ArgPrefixed @ArgDefaultNull String destinationString, @ArgName(value="slot") @ArgPrefixed @ArgDefaultNull String slot, @ArgName(value="expiration") @ArgPrefixed @ArgDefaultNull ObjectTag expiration, @ArgName(value="data_action") @ArgRaw @ArgLinear @ArgDefaultNull String dataAction) {
        AbstractMap.SimpleEntry<Integer, InventoryTag> destinationEntry;
        if (slot == null) {
            if (actions.contains((Object)Action.ADJUST)) {
                throw new InvalidArgumentsRuntimeException("Inventory adjust must have an explicit slot!");
            }
            slot = "1";
        }
        TimeTag expire = null;
        if (actions.contains((Object)Action.FLAG) && expiration != null) {
            if (expiration.canBeType(DurationTag.class)) {
                TimeTag now = TimeTag.now();
                expire = new TimeTag(now.millis() + expiration.asType(DurationTag.class, scriptEntry.context).getMillis(), now.instant.getZone());
            } else if (expiration.canBeType(TimeTag.class)) {
                expire = expiration.asType(TimeTag.class, scriptEntry.context);
            } else {
                throw new InvalidArgumentsRuntimeException("Flag expiration is not a DurationTag or TimeTag!");
            }
        }
        AbstractMap.SimpleEntry<Integer, InventoryTag> originEntry = originString != null ? Conversion.getInventory(new Argument(originString), scriptEntry) : null;
        AbstractMap.SimpleEntry<Integer, InventoryTag> simpleEntry = destinationEntry = destinationString != null ? Conversion.getInventory(new Argument(destinationString), scriptEntry) : null;
        if (destinationEntry == null) {
            InventoryTag inv = Utilities.getEntryPlayer(scriptEntry).getInventory();
            if (inv == null) {
                throw new InvalidArgumentsRuntimeException("Must specify a Destination Inventory!");
            }
            destinationEntry = new AbstractMap.SimpleEntry<Integer, InventoryTag>(0, inv);
        }
        InventoryTag origin = originEntry != null ? originEntry.getValue() : null;
        InventoryTag destination = destinationEntry.getValue();
        int slotId = SlotHelper.nameToIndexFor(slot, destination.getInventory().getHolder());
        if (slotId < 0) {
            if (slotId == -1) {
                throw new InvalidArgumentsRuntimeException("The input '" + slot + "' is not a valid slot (unrecognized)!");
            }
            throw new InvalidArgumentsRuntimeException("The input '" + slot + "' is not a valid slot (negative values are invalid)!");
        }
        InventoryTag.trackTemporaryInventory(destination);
        if (origin != null) {
            InventoryTag.trackTemporaryInventory(origin);
        }
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        block15: for (Action action : actions) {
            switch (action.ordinal()) {
                case 0: {
                    EntityTag entity;
                    if ((destination.getInventoryType() == InventoryType.WORKBENCH || destination.getInventoryType() == InventoryType.ANVIL && Denizen.supportsPaper) && destination.getInventory().getLocation() == null) {
                        InventoryCommand.doSpecialOpen(destination.getInventoryType(), player.getPlayerEntity(), destination);
                        break;
                    }
                    ObjectTag objectTag = destination.getIdHolder();
                    if (objectTag instanceof EntityTag && (objectTag = (entity = (EntityTag)objectTag).getLivingEntity()) instanceof AbstractHorse) {
                        AbstractHorse horse = (AbstractHorse)objectTag;
                        NMSHandler.entityHelper.openHorseInventory(player.getPlayerEntity(), horse);
                        break;
                    }
                    player.getPlayerEntity().openInventory(destination.getInventory());
                    break;
                }
                case 1: {
                    player.getPlayerEntity().closeInventory();
                    break;
                }
                case 2: {
                    if (origin == null) {
                        throw new InvalidArgumentsRuntimeException("Missing origin argument!");
                    }
                    InventoryCommand.replace(origin, destination);
                    break;
                }
                case 3: {
                    if (origin == null) {
                        throw new InvalidArgumentsRuntimeException("Missing origin argument!");
                    }
                    InventoryCommand.replace(origin, destination);
                    origin.clear();
                    break;
                }
                case 4: {
                    if (origin == null) {
                        throw new InvalidArgumentsRuntimeException("Missing origin argument!");
                    }
                    InventoryTag temp = new InventoryTag(destination.getInventory().getContents());
                    InventoryCommand.replace(origin, destination);
                    InventoryCommand.replace(temp, origin);
                    break;
                }
                case 5: {
                    if (origin == null) {
                        throw new InvalidArgumentsRuntimeException("Missing origin argument!");
                    }
                    destination.setSlots(slotId, origin.getContents(), originEntry.getKey());
                    break;
                }
                case 6: {
                    if (origin == null) {
                        throw new InvalidArgumentsRuntimeException("Missing origin argument!");
                    }
                    ItemStack[] items = origin.getContents();
                    for (ItemStack invStack : destination.getInventory()) {
                        if (invStack == null) continue;
                        boolean keep = false;
                        for (ItemStack item : items) {
                            if (!invStack.isSimilar(item)) continue;
                            keep = true;
                            break;
                        }
                        if (keep) continue;
                        destination.getInventory().remove(invStack);
                    }
                    continue block15;
                }
                case 7: {
                    if (origin == null) {
                        throw new InvalidArgumentsRuntimeException("Missing origin argument!");
                    }
                    int oldCount = destination.count(null, false);
                    int newCount = -1;
                    while (oldCount != newCount) {
                        oldCount = newCount;
                        InventoryCommand.remove(destination.getInventory(), origin.getContents());
                        newCount = destination.count(null, false);
                    }
                    break;
                }
                case 8: {
                    if (origin == null) {
                        throw new InvalidArgumentsRuntimeException("Missing origin argument!");
                    }
                    int oldCount = destination.count(null, false);
                    int newCount = -1;
                    while (oldCount != newCount) {
                        oldCount = newCount;
                        newCount = destination.add(0, origin.getContents()).count(null, false);
                    }
                    break;
                }
                case 9: {
                    destination.clear();
                    break;
                }
                case 10: {
                    if (destination.idHolder instanceof PlayerTag) {
                        ((PlayerTag)destination.idHolder).getPlayerEntity().updateInventory();
                        break;
                    }
                    throw new InvalidArgumentsRuntimeException("Only player inventories can be force-updated!");
                }
                case 11: {
                    if (dataAction == null) {
                        throw new InvalidArgumentsRuntimeException("Inventory adjust must have a mechanism!");
                    }
                    ItemTag toAdjust = new ItemTag(destination.getInventory().getItem(slotId));
                    Argument mechanismArgument = new Argument(dataAction);
                    toAdjust.safeAdjust(new Mechanism(mechanismArgument.getPrefix().getValue(), mechanismArgument.object, scriptEntry.getContext()));
                    NMSHandler.itemHelper.setInventoryItem(destination.getInventory(), toAdjust.getItemStack(), slotId);
                    break;
                }
                case 12: {
                    if (dataAction == null) {
                        throw new InvalidArgumentsRuntimeException("Inventory flag must have a flag action!");
                    }
                    ItemTag toFlag = new ItemTag(destination.getInventory().getItem(slotId));
                    Argument flagArgument = new Argument(dataAction);
                    DataAction flagAction = DataActionHelper.parse((ActionableDataProvider)new FlagCommand.FlagActionProvider(), flagArgument, scriptEntry.context);
                    FlagCommand.FlagActionProvider provider = (FlagCommand.FlagActionProvider)flagAction.provider;
                    provider.expiration = expire;
                    provider.tracker = toFlag.getFlagTracker();
                    flagAction.execute(scriptEntry.context);
                    toFlag.reapplyTracker(provider.tracker);
                    NMSHandler.itemHelper.setInventoryItem(destination.getInventory(), toFlag.getItemStack(), slotId);
                }
            }
        }
    }

    public static void replace(InventoryTag origin, InventoryTag destination) {
        if (destination.getSize() < origin.getSize()) {
            destination.clear();
            destination.add(0, origin.getContents());
        } else {
            destination.setContents(origin.getContents());
        }
    }

    public static void remove(Inventory inventory, ItemStack[] items) {
        for (ItemStack item : items) {
            if (item == null) continue;
            inventory.removeItem(new ItemStack[]{item.clone()});
        }
    }

    public static enum Action {
        OPEN,
        CLOSE,
        COPY,
        MOVE,
        SWAP,
        SET,
        KEEP,
        EXCLUDE,
        FILL,
        CLEAR,
        UPDATE,
        ADJUST,
        FLAG;

    }
}

