/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.blocks;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.flags.MapTagBasedFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.shaded.net.adventure.nbt.CompoundBinaryTag;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Rail;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.RedstoneWire;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.block.data.type.Wall;

public class FullBlockData {
    public BlockData data;
    public CompoundBinaryTag tileEntityData;
    public MapTag flags;

    public static void init() {
        HashSet<Class> classesHandled = new HashSet<Class>();
        for (Material material : Material.values()) {
            BlockData data;
            if (!material.isBlock() || material.isLegacy() || !classesHandled.add((data = material.createBlockData()).getClass())) continue;
            FullBlockData.initBlockDataClass(data);
        }
    }

    private static void initBlockDataClass(BlockData data) {
        try {
            Class dataClass = data.getClass();
            HashMap<String, Method> setMethods = new HashMap<String, Method>();
            for (Method m : dataClass.getMethods()) {
                if (!m.getName().startsWith("set") || m.getParameterCount() != 1 || m.getReturnType() != Void.TYPE) continue;
                setMethods.put(m.getName(), m);
            }
            for (Method m : dataClass.getMethods()) {
                Method setter;
                if (!m.getName().startsWith("get") || m.getParameterCount() != 0 || !m.getReturnType().isEnum() || (setter = (Method)setMethods.get("set" + m.getName().substring("get".length()))) == null || setter.getParameterTypes()[0] != m.getReturnType()) continue;
                setter.setAccessible(true);
                m.setAccessible(true);
                Object curVal = m.invoke((Object)data, new Object[0]);
                setter.invoke((Object)data, curVal);
            }
        }
        catch (Throwable ex) {
            Debug.echoError("Errored while trying to pre-load BlockData class '" + data.getClass().getName() + "'");
            Debug.echoError(ex);
        }
    }

    public FullBlockData(Block block, boolean copyFlags) {
        this(block);
        if (copyFlags) {
            MapTagBasedFlagTracker flagMap = (MapTagBasedFlagTracker)new LocationTag(block.getLocation()).getFlagTracker();
            this.flags = new MapTag();
            for (String flag : flagMap.listAllFlags()) {
                this.flags.putObject(flag, (ObjectTag)flagMap.getRootMap(flag));
            }
            if (this.flags.isEmpty()) {
                this.flags = null;
            }
        }
    }

    public FullBlockData(Block block) {
        this(block.getBlockData());
        this.tileEntityData = NMSHandler.blockHelper.getNbtData(block);
    }

    public FullBlockData(BlockData data) {
        this.data = data;
    }

    public FullBlockData(BlockData data, CompoundBinaryTag tileEntityData, MapTag flags) {
        this.data = data;
        this.tileEntityData = tileEntityData;
        this.flags = flags;
    }

    public static BlockFace rotateFaceOne(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case NORTH_EAST: {
                return BlockFace.NORTH_WEST;
            }
            case NORTH_WEST: {
                return BlockFace.SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return BlockFace.SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return BlockFace.NORTH_EAST;
            }
            case NORTH_NORTH_EAST: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case NORTH_NORTH_WEST: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case SOUTH_SOUTH_WEST: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case SOUTH_SOUTH_EAST: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case EAST_NORTH_EAST: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case WEST_NORTH_WEST: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case WEST_SOUTH_WEST: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case EAST_SOUTH_EAST: {
                return BlockFace.NORTH_NORTH_EAST;
            }
        }
        return face;
    }

    public static Rail.Shape rotateRailShapeOne(Rail.Shape shape) {
        switch (shape) {
            case NORTH_SOUTH: {
                return Rail.Shape.EAST_WEST;
            }
            case EAST_WEST: {
                return Rail.Shape.NORTH_SOUTH;
            }
            case ASCENDING_EAST: {
                return Rail.Shape.ASCENDING_NORTH;
            }
            case ASCENDING_WEST: {
                return Rail.Shape.ASCENDING_SOUTH;
            }
            case ASCENDING_NORTH: {
                return Rail.Shape.ASCENDING_WEST;
            }
            case ASCENDING_SOUTH: {
                return Rail.Shape.ASCENDING_EAST;
            }
            case SOUTH_EAST: {
                return Rail.Shape.NORTH_EAST;
            }
            case SOUTH_WEST: {
                return Rail.Shape.SOUTH_EAST;
            }
            case NORTH_WEST: {
                return Rail.Shape.SOUTH_WEST;
            }
            case NORTH_EAST: {
                return Rail.Shape.NORTH_WEST;
            }
        }
        return shape;
    }

    public FullBlockData rotateOne() {
        if (this.data instanceof Orientable) {
            BlockData newData = this.data.clone();
            switch (((Orientable)this.data).getAxis()) {
                case X: {
                    ((Orientable)newData).setAxis(Axis.Z);
                    break;
                }
                case Z: {
                    ((Orientable)newData).setAxis(Axis.X);
                }
            }
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Rotatable) {
            BlockData newData = this.data.clone();
            ((Rotatable)newData).setRotation(FullBlockData.rotateFaceOne(((Rotatable)this.data).getRotation()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Directional) {
            BlockData newData = this.data.clone();
            ((Directional)newData).setFacing(FullBlockData.rotateFaceOne(((Directional)this.data).getFacing()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Rail) {
            BlockData newData = this.data.clone();
            ((Rail)newData).setShape(FullBlockData.rotateRailShapeOne(((Rail)this.data).getShape()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof MultipleFacing) {
            MultipleFacing newData = (MultipleFacing)this.data.clone();
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(face, false);
            }
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(FullBlockData.rotateFaceOne(face), true);
            }
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof RedstoneWire) {
            RedstoneWire newData = (RedstoneWire)this.data.clone();
            newData.setFace(BlockFace.NORTH, ((RedstoneWire)this.data).getFace(BlockFace.EAST));
            newData.setFace(BlockFace.WEST, ((RedstoneWire)this.data).getFace(BlockFace.NORTH));
            newData.setFace(BlockFace.EAST, ((RedstoneWire)this.data).getFace(BlockFace.SOUTH));
            newData.setFace(BlockFace.SOUTH, ((RedstoneWire)this.data).getFace(BlockFace.WEST));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Wall) {
            Wall newData = (Wall)this.data.clone();
            newData.setHeight(BlockFace.NORTH, ((Wall)this.data).getHeight(BlockFace.EAST));
            newData.setHeight(BlockFace.WEST, ((Wall)this.data).getHeight(BlockFace.NORTH));
            newData.setHeight(BlockFace.EAST, ((Wall)this.data).getHeight(BlockFace.SOUTH));
            newData.setHeight(BlockFace.SOUTH, ((Wall)this.data).getHeight(BlockFace.WEST));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        return this;
    }

    public static Door.Hinge flipDoorHinge(Door.Hinge hinge) {
        switch (hinge) {
            case LEFT: {
                return Door.Hinge.RIGHT;
            }
            case RIGHT: {
                return Door.Hinge.LEFT;
            }
        }
        return hinge;
    }

    public static Chest.Type flipChestType(Chest.Type type) {
        switch (type) {
            case LEFT: {
                return Chest.Type.RIGHT;
            }
            case RIGHT: {
                return Chest.Type.LEFT;
            }
        }
        return type;
    }

    public static Bisected.Half flipBisectedHalf(Bisected.Half half) {
        switch (half) {
            case TOP: {
                return Bisected.Half.BOTTOM;
            }
            case BOTTOM: {
                return Bisected.Half.TOP;
            }
        }
        return half;
    }

    public static BlockFace flipFaceX(BlockFace face) {
        switch (face) {
            case EAST: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.EAST;
            }
            case NORTH_EAST: {
                return BlockFace.NORTH_WEST;
            }
            case NORTH_WEST: {
                return BlockFace.NORTH_EAST;
            }
            case SOUTH_WEST: {
                return BlockFace.SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return BlockFace.SOUTH_WEST;
            }
            case NORTH_NORTH_EAST: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case NORTH_NORTH_WEST: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case SOUTH_SOUTH_WEST: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case SOUTH_SOUTH_EAST: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case EAST_NORTH_EAST: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case WEST_NORTH_WEST: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case WEST_SOUTH_WEST: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case EAST_SOUTH_EAST: {
                return BlockFace.WEST_SOUTH_WEST;
            }
        }
        return face;
    }

    public static Rail.Shape flipRailShapeX(Rail.Shape shape) {
        switch (shape) {
            case ASCENDING_EAST: {
                return Rail.Shape.ASCENDING_WEST;
            }
            case ASCENDING_WEST: {
                return Rail.Shape.ASCENDING_EAST;
            }
            case ASCENDING_NORTH: {
                return Rail.Shape.ASCENDING_NORTH;
            }
            case ASCENDING_SOUTH: {
                return Rail.Shape.ASCENDING_SOUTH;
            }
            case SOUTH_EAST: {
                return Rail.Shape.SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return Rail.Shape.SOUTH_EAST;
            }
            case NORTH_WEST: {
                return Rail.Shape.NORTH_EAST;
            }
            case NORTH_EAST: {
                return Rail.Shape.NORTH_WEST;
            }
        }
        return shape;
    }

    public static BlockFace flipStairFaceX(Stairs.Shape shape, BlockFace face) {
        switch (shape) {
            case INNER_RIGHT: 
            case OUTER_RIGHT: {
                switch (face) {
                    case NORTH: {
                        return BlockFace.WEST;
                    }
                    case EAST: {
                        return BlockFace.SOUTH;
                    }
                    case SOUTH: {
                        return BlockFace.EAST;
                    }
                    case WEST: {
                        return BlockFace.NORTH;
                    }
                }
            }
            case INNER_LEFT: 
            case OUTER_LEFT: {
                switch (face) {
                    case NORTH: {
                        return BlockFace.EAST;
                    }
                    case EAST: {
                        return BlockFace.NORTH;
                    }
                    case SOUTH: {
                        return BlockFace.WEST;
                    }
                    case WEST: {
                        return BlockFace.SOUTH;
                    }
                }
            }
            case STRAIGHT: {
                switch (face) {
                    case EAST: {
                        return BlockFace.WEST;
                    }
                    case WEST: {
                        return BlockFace.EAST;
                    }
                }
            }
        }
        return face;
    }

    public FullBlockData flipX() {
        if (this.data instanceof Rotatable) {
            BlockData newData = this.data.clone();
            ((Rotatable)newData).setRotation(FullBlockData.flipFaceX(((Rotatable)this.data).getRotation()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Stairs) {
            BlockData newData = this.data.clone();
            BlockFace face = ((Stairs)this.data).getFacing();
            Stairs.Shape shape = ((Stairs)this.data).getShape();
            ((Stairs)newData).setFacing(FullBlockData.flipStairFaceX(shape, face));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Directional) {
            BlockData newData = this.data.clone();
            ((Directional)newData).setFacing(FullBlockData.flipFaceX(((Directional)this.data).getFacing()));
            if (this.data instanceof Chest) {
                ((Chest)newData).setType(FullBlockData.flipChestType(((Chest)this.data).getType()));
            } else if (this.data instanceof Door) {
                switch (((Door)this.data).getFacing()) {
                    case NORTH: 
                    case SOUTH: {
                        ((Door)newData).setHinge(FullBlockData.flipDoorHinge(((Door)this.data).getHinge()));
                    }
                }
            }
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Rail) {
            BlockData newData = this.data.clone();
            ((Rail)newData).setShape(FullBlockData.flipRailShapeX(((Rail)this.data).getShape()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof MultipleFacing) {
            MultipleFacing newData = (MultipleFacing)this.data.clone();
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(face, false);
            }
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(FullBlockData.flipFaceX(face), true);
            }
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof RedstoneWire) {
            RedstoneWire newData = (RedstoneWire)this.data.clone();
            newData.setFace(BlockFace.NORTH, ((RedstoneWire)this.data).getFace(BlockFace.NORTH));
            newData.setFace(BlockFace.WEST, ((RedstoneWire)this.data).getFace(BlockFace.EAST));
            newData.setFace(BlockFace.EAST, ((RedstoneWire)this.data).getFace(BlockFace.WEST));
            newData.setFace(BlockFace.SOUTH, ((RedstoneWire)this.data).getFace(BlockFace.SOUTH));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Wall) {
            Wall newData = (Wall)this.data.clone();
            newData.setHeight(BlockFace.NORTH, ((Wall)this.data).getHeight(BlockFace.NORTH));
            newData.setHeight(BlockFace.WEST, ((Wall)this.data).getHeight(BlockFace.EAST));
            newData.setHeight(BlockFace.EAST, ((Wall)this.data).getHeight(BlockFace.WEST));
            newData.setHeight(BlockFace.SOUTH, ((Wall)this.data).getHeight(BlockFace.SOUTH));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        return this;
    }

    public static BlockFace flipFaceY(BlockFace face) {
        switch (face) {
            case DOWN: {
                return BlockFace.UP;
            }
            case UP: {
                return BlockFace.DOWN;
            }
        }
        return face;
    }

    public FullBlockData flipY() {
        if (this.data instanceof Bisected) {
            BlockData newData = this.data.clone();
            ((Bisected)newData).setHalf(FullBlockData.flipBisectedHalf(((Bisected)this.data).getHalf()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof MultipleFacing) {
            MultipleFacing newData = (MultipleFacing)this.data.clone();
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(face, false);
            }
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(FullBlockData.flipFaceY(face), true);
            }
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        return this;
    }

    public static BlockFace flipFaceZ(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.NORTH;
            }
            case NORTH_EAST: {
                return BlockFace.SOUTH_EAST;
            }
            case NORTH_WEST: {
                return BlockFace.SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return BlockFace.NORTH_WEST;
            }
            case SOUTH_EAST: {
                return BlockFace.NORTH_EAST;
            }
            case NORTH_NORTH_EAST: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case NORTH_NORTH_WEST: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case SOUTH_SOUTH_WEST: {
                return BlockFace.NORTH_NORTH_WEST;
            }
            case SOUTH_SOUTH_EAST: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case EAST_NORTH_EAST: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case WEST_NORTH_WEST: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case WEST_SOUTH_WEST: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case EAST_SOUTH_EAST: {
                return BlockFace.EAST_NORTH_EAST;
            }
        }
        return face;
    }

    public static Rail.Shape flipRailShapeZ(Rail.Shape shape) {
        switch (shape) {
            case ASCENDING_NORTH: {
                return Rail.Shape.ASCENDING_SOUTH;
            }
            case ASCENDING_SOUTH: {
                return Rail.Shape.ASCENDING_NORTH;
            }
            case SOUTH_EAST: {
                return Rail.Shape.NORTH_EAST;
            }
            case SOUTH_WEST: {
                return Rail.Shape.NORTH_WEST;
            }
            case NORTH_WEST: {
                return Rail.Shape.SOUTH_WEST;
            }
            case NORTH_EAST: {
                return Rail.Shape.SOUTH_EAST;
            }
        }
        return shape;
    }

    public static BlockFace flipStairFaceZ(Stairs.Shape shape, BlockFace face) {
        switch (shape) {
            case INNER_RIGHT: 
            case OUTER_RIGHT: {
                switch (face) {
                    case NORTH: {
                        return BlockFace.EAST;
                    }
                    case EAST: {
                        return BlockFace.NORTH;
                    }
                    case SOUTH: {
                        return BlockFace.WEST;
                    }
                    case WEST: {
                        return BlockFace.SOUTH;
                    }
                }
            }
            case INNER_LEFT: 
            case OUTER_LEFT: {
                switch (face) {
                    case NORTH: {
                        return BlockFace.WEST;
                    }
                    case EAST: {
                        return BlockFace.SOUTH;
                    }
                    case SOUTH: {
                        return BlockFace.EAST;
                    }
                    case WEST: {
                        return BlockFace.NORTH;
                    }
                }
            }
            case STRAIGHT: {
                switch (face) {
                    case NORTH: {
                        return BlockFace.SOUTH;
                    }
                    case SOUTH: {
                        return BlockFace.NORTH;
                    }
                }
            }
        }
        return face;
    }

    public FullBlockData flipZ() {
        if (this.data instanceof Rotatable) {
            BlockData newData = this.data.clone();
            ((Rotatable)newData).setRotation(FullBlockData.flipFaceZ(((Rotatable)this.data).getRotation()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Stairs) {
            BlockData newData = this.data.clone();
            BlockFace face = ((Stairs)this.data).getFacing();
            Stairs.Shape shape = ((Stairs)this.data).getShape();
            ((Stairs)newData).setFacing(FullBlockData.flipStairFaceZ(shape, face));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Directional) {
            BlockData newData = this.data.clone();
            ((Directional)newData).setFacing(FullBlockData.flipFaceZ(((Directional)this.data).getFacing()));
            if (this.data instanceof Chest) {
                ((Chest)newData).setType(FullBlockData.flipChestType(((Chest)this.data).getType()));
            } else if (this.data instanceof Door) {
                switch (((Door)this.data).getFacing()) {
                    case EAST: 
                    case WEST: {
                        ((Door)newData).setHinge(FullBlockData.flipDoorHinge(((Door)this.data).getHinge()));
                    }
                }
            }
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Rail) {
            BlockData newData = this.data.clone();
            ((Rail)newData).setShape(FullBlockData.flipRailShapeZ(((Rail)this.data).getShape()));
            return new FullBlockData(newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof MultipleFacing) {
            MultipleFacing newData = (MultipleFacing)this.data.clone();
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(face, false);
            }
            for (BlockFace face : ((MultipleFacing)this.data).getFaces()) {
                newData.setFace(FullBlockData.flipFaceZ(face), true);
            }
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof RedstoneWire) {
            RedstoneWire newData = (RedstoneWire)this.data.clone();
            newData.setFace(BlockFace.NORTH, ((RedstoneWire)this.data).getFace(BlockFace.SOUTH));
            newData.setFace(BlockFace.WEST, ((RedstoneWire)this.data).getFace(BlockFace.WEST));
            newData.setFace(BlockFace.EAST, ((RedstoneWire)this.data).getFace(BlockFace.EAST));
            newData.setFace(BlockFace.SOUTH, ((RedstoneWire)this.data).getFace(BlockFace.NORTH));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        if (this.data instanceof Wall) {
            Wall newData = (Wall)this.data.clone();
            newData.setHeight(BlockFace.NORTH, ((Wall)this.data).getHeight(BlockFace.SOUTH));
            newData.setHeight(BlockFace.WEST, ((Wall)this.data).getHeight(BlockFace.WEST));
            newData.setHeight(BlockFace.EAST, ((Wall)this.data).getHeight(BlockFace.EAST));
            newData.setHeight(BlockFace.SOUTH, ((Wall)this.data).getHeight(BlockFace.NORTH));
            return new FullBlockData((BlockData)newData, this.tileEntityData, this.flags);
        }
        return this;
    }

    public void set(Block block, boolean physics) {
        block.setBlockData(this.data, physics);
        if (this.tileEntityData != null) {
            NMSHandler.blockHelper.setNbtData(block, this.tileEntityData);
        }
        if (this.flags != null) {
            MapTagBasedFlagTracker flagMap = (MapTagBasedFlagTracker)new LocationTag(block.getLocation()).getFlagTracker();
            for (Map.Entry<StringHolder, ObjectTag> entry : this.flags.entrySet()) {
                flagMap.setRootMap(entry.getKey().str, entry.getValue().asType(MapTag.class, CoreUtilities.noDebugContext));
            }
        }
    }
}

