/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.inventory;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class InventoryViewUtil {
    private static final MethodHandle GET_TOP_INVENTORY = ReflectionHelper.getMethodHandle(InventoryView.class, "getTopInventory", new Class[0]);
    private static final MethodHandle GET_PLAYER = ReflectionHelper.getMethodHandle(InventoryView.class, "getPlayer", new Class[0]);
    private static final MethodHandle GET_TYPE = ReflectionHelper.getMethodHandle(InventoryView.class, "getType", new Class[0]);
    private static final MethodHandle GET_ITEM = ReflectionHelper.getMethodHandle(InventoryView.class, "getItem", Integer.TYPE);
    private static final MethodHandle GET_INVENTORY = ReflectionHelper.getMethodHandle(InventoryView.class, "getInventory", Integer.TYPE);

    private static <T> T get(MethodHandle methodHandle, InventoryView view) {
        try {
            return (T)methodHandle.invoke(view);
        }
        catch (Throwable e) {
            Debug.echoError(e);
            return null;
        }
    }

    private static <T> T get(MethodHandle methodHandle, InventoryView view, int num) {
        try {
            return (T)methodHandle.invoke(view, num);
        }
        catch (Throwable e) {
            Debug.echoError(e);
            return null;
        }
    }

    public static Inventory getTopInventory(InventoryView view) {
        return (Inventory)InventoryViewUtil.get(GET_TOP_INVENTORY, view);
    }

    public static HumanEntity getPlayer(InventoryView view) {
        return (HumanEntity)InventoryViewUtil.get(GET_PLAYER, view);
    }

    public static InventoryType getType(InventoryView view) {
        return (InventoryType)InventoryViewUtil.get(GET_TYPE, view);
    }

    public static ItemStack getItem(InventoryView view, int slot) {
        return (ItemStack)InventoryViewUtil.get(GET_ITEM, view, slot);
    }

    public static Inventory getInventory(InventoryView view, int slot) {
        return (Inventory)InventoryViewUtil.get(GET_INVENTORY, view, slot);
    }
}

