/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.ObjectType;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.codegen.TagNamer;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ObjectTagProcessor<T extends ObjectTag> {
    public HashMap<String, TagData<T, ? extends ObjectTag>> registeredObjectTags = new HashMap();
    public HashMap<String, MechanismData<T>> registeredMechanisms = new HashMap();
    public List<CustomMatcher<T>> custommatchers = new ArrayList<CustomMatcher<T>>();
    public Class<T> type;

    public void registerFutureTagDeprecation(String name, String ... deprecatedVariants) {
        TagData<T, ? extends ObjectTag> properTag = this.registeredObjectTags.get(name);
        for (String variant : deprecatedVariants) {
            TagRunnable.ObjectInterface<ObjectTag, ObjectTag> newRunnable = (attribute, object) -> {
                if (CoreConfiguration.futureWarningsEnabled) {
                    Debug.echoError(attribute.context, "Using deprecated form of tag '" + name + "': '" + variant + "'.");
                }
                return properTag.runner.run(attribute, object);
            };
            this.registeredObjectTags.put(variant, new TagData<ObjectTag, ObjectTag>(this, variant, newRunnable, properTag.returnType, false));
        }
    }

    public <R extends ObjectTag, P extends ObjectTag> void registerStaticTag(Class<R> returnType, Class<P> paramType, String name, TagRunnable.ObjectWithParamInterface<T, R, P> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, paramType, name, runnable, true, deprecatedVariants);
    }

    public <R extends ObjectTag, P extends ObjectTag> void registerTag(Class<R> returnType, Class<P> paramType, String name, TagRunnable.ObjectWithParamInterface<T, R, P> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, paramType, name, runnable, false, deprecatedVariants);
    }

    public <R extends ObjectTag, P extends ObjectTag> void registerTagInternal(Class<R> returnType, Class<P> paramType, String name, TagRunnable.ObjectWithParamInterface<T, R, P> runnable, boolean isStatic, String[] deprecatedVariants) {
        ObjectType paramObjType = ObjectFetcher.getType(paramType);
        this.registerTagInternal(returnType, name, (attribute, obj) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ObjectTag param = attribute.getParamObject();
            if (TagManager.isStaticParsing && paramObjType != null && !paramObjType.canConvertStatic) {
                return null;
            }
            Object result = param.asType(paramType, attribute.context);
            if (result == null) {
                if (!TagManager.isStaticParsing) {
                    attribute.echoError("Tag '<Y>" + name + "<W>' requires input of type '<Y>" + DebugInternals.getClassNameOpti(paramType) + "<W>' but received input '<LR>" + String.valueOf(param) + "<W>'.");
                }
                return null;
            }
            return runnable.run(attribute, obj, result);
        }, isStatic, deprecatedVariants);
    }

    public <R extends ObjectTag> void registerStaticTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<T, R> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, name, runnable, true, deprecatedVariants);
    }

    public <R extends ObjectTag> void registerTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<T, R> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, name, runnable, false, deprecatedVariants);
    }

    public <R extends ObjectTag> void registerTagInternal(Class<R> returnType, String name, TagRunnable.ObjectInterface<T, R> runnable, boolean isStatic, String[] deprecatedVariants) {
        TagRunnable.ObjectInterface namedRunnable = TagNamer.nameTagInterface(this.type, name, runnable);
        for (String variant : deprecatedVariants) {
            TagRunnable.ObjectInterface<ObjectTag, ObjectTag> newRunnable = TagNamer.nameTagInterface(this.type, variant, (attribute, object) -> {
                Debug.echoError(attribute.context, "Using deprecated form of tag '" + name + "': '" + variant + "'.");
                return namedRunnable.run(attribute, object);
            });
            this.registeredObjectTags.put(variant, new TagData<ObjectTag, ObjectTag>(this, variant, newRunnable, returnType, false));
        }
        this.registeredObjectTags.put(name, new TagData<T, R>(this, name, namedRunnable, returnType, isStatic));
    }

    public final ObjectTag getObjectAttribute(T object, Attribute attribute) {
        if (attribute == null) {
            if (CoreConfiguration.debugVerbose) {
                Debug.verboseLog("TagProcessor - Attribute null!");
            }
            return null;
        }
        attribute.lastValid = object;
        if (attribute.isComplete()) {
            if (CoreConfiguration.debugVerbose) {
                Debug.verboseLog("TagProcessor - Attribute complete! Self return!");
            }
            return object;
        }
        Attribute.AttributeComponent nextComponent = attribute.attributes[attribute.fulfilled];
        TagData<ObjectTag, ? extends ObjectTag> data = nextComponent.data;
        if (data == null) {
            data = this.registeredObjectTags.get(nextComponent.key);
        }
        if (data != null) {
            Object returned;
            if (CoreConfiguration.debugVerbose) {
                Debug.verboseLog("TagProcessor - Sub-tag found for " + nextComponent.key);
            }
            if ((returned = data.runner.run(attribute, object)) == null) {
                if (CoreConfiguration.debugVerbose) {
                    Debug.verboseLog("TagProcessor - result was null");
                }
                attribute.trackLastTagFailure();
                return null;
            }
            if (data.processor != null) {
                return data.processor.getObjectAttribute(returned, attribute.fulfill(1));
            }
            return returned.getObjectAttribute(attribute.fulfill(1));
        }
        ObjectTag returned = CoreUtilities.autoPropertyTagObject(object, attribute);
        if (returned == null) {
            returned = object.specialTagProcessing(attribute);
        }
        if (returned != null) {
            return returned;
        }
        return object.getNextObjectTypeDown().getObjectAttribute(attribute);
    }

    public final void processMechanism(T object, Mechanism mechanism) {
        MechanismData<T> mechData = this.registeredMechanisms.get(mechanism.getName());
        if (mechData == null) {
            CoreUtilities.autoPropertyMechanism(object, mechanism);
            return;
        }
        mechanism.fulfill();
        if (mechanism.isProperty && !mechData.allowProperty) {
            mechanism.echoError("Error: mechanism '" + mechData.name + "' may not be used as property input.");
            return;
        }
        mechData.runner.run(object, mechanism);
    }

    public void registerMechanism(String name, boolean allowProperty, Mechanism.GenericMechRunnerInterface<T> runner, String ... deprecatedVariants) {
        MechanismData data = new MechanismData();
        data.allowProperty = allowProperty;
        data.name = name;
        data.runner = runner;
        PropertyParser.allMechanismsEver.add(name);
        this.registeredMechanisms.put(name, data);
        for (String variant : deprecatedVariants) {
            MechanismData variantData = new MechanismData();
            variantData.allowProperty = allowProperty;
            variantData.name = variant;
            variantData.runner = (object, mechanism) -> {
                mechanism.echoError("Using deprecated form of mechanism '" + name + "': '" + variant + "'.");
                runner.run(object, mechanism);
            };
            this.registeredMechanisms.put(variant, variantData);
        }
    }

    public <P extends ObjectTag> void registerMechanism(String name, boolean allowProperty, Class<P> paramType, Mechanism.ObjectInputMechRunnerInterface<T, P> runner, String ... deprecatedVariants) {
        this.registerMechanism(name, allowProperty, (T object, Mechanism mechanism) -> {
            if (mechanism.value == null) {
                mechanism.echoError("Error: mechanism '" + name + "' must have input of type '" + DebugInternals.getClassNameOpti(paramType) + "', but none was given.");
                return;
            }
            Object input = mechanism.value.asType(paramType, mechanism.context);
            if (input == null) {
                mechanism.echoError("Error: mechanism '" + name + "' must have input of type '" + DebugInternals.getClassNameOpti(paramType) + "', but value '" + String.valueOf(mechanism.value) + "' cannot be converted to the required type.");
                return;
            }
            runner.run(object, mechanism, input);
        }, deprecatedVariants);
    }

    public static class TagData<T extends ObjectTag, R extends ObjectTag> {
        public String name;
        public TagRunnable.ObjectInterface<T, R> runner;
        public Class<R> returnType;
        public ObjectTagProcessor<R> processor;
        public ObjectTagProcessor<T> source;
        public boolean isStatic;

        public TagData(ObjectTagProcessor<T> source, String name, TagRunnable.ObjectInterface<T, R> runner, Class<R> returnType, boolean isStatic) {
            this.source = source;
            this.name = name;
            this.runner = runner;
            this.returnType = returnType;
            this.isStatic = isStatic;
            ObjectType<R> type = ObjectFetcher.getType(returnType);
            this.processor = type == null ? null : type.tagProcessor;
        }
    }

    public static class MechanismData<T extends ObjectTag> {
        public String name;
        public Mechanism.GenericMechRunnerInterface<T> runner;
        public boolean allowProperty;
    }

    @FunctionalInterface
    public static interface CustomMatcher<T extends ObjectTag> {
        public Boolean tryMatch(T var1, String var2);
    }
}

