/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.mcmmo;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.gmail.nossr50.api.ExperienceAPI;
import com.gmail.nossr50.api.PartyAPI;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import org.bukkit.entity.Player;

public class McMMOCommand
extends AbstractCommand {
    public McMMOCommand() {
        this.setName("mcmmo");
        this.setSyntax("mcmmo [add/remove/set] [levels/xp/xprate/vampirism/hardcore/leader] (skill:<skill>) (state:{toggle}/true/false) (quantity:<#>) (party:<party>)");
        this.setRequiredArguments(1, 6);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("state") && arg.matchesPrefix("state") && arg.matchesEnum(State.class)) {
                scriptEntry.addObject("state", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("party") && arg.matchesPrefix("party")) {
                scriptEntry.addObject("party", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("skill") && arg.matchesPrefix("skill")) {
                scriptEntry.addObject("skill", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("quantity") && arg.matchesPrefix(new String[]{"q", "qty", "quantity"}) && arg.matchesFloat()) {
                scriptEntry.addObject("quantity", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.class)) {
                scriptEntry.addObject("type", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Must specify a valid action!");
        }
        if (!scriptEntry.hasObject("type")) {
            throw new InvalidArgumentsException("Must specify a valid type!");
        }
        scriptEntry.defaultObject("state", new Object[]{new ElementTag("TOGGLE")}).defaultObject("quantity", new Object[]{new ElementTag(-1)});
    }

    public void execute(ScriptEntry scriptEntry) {
        block49: {
            ElementTag action = scriptEntry.getElement("action");
            ElementTag state = scriptEntry.getElement("state");
            ElementTag type = scriptEntry.getElement("type");
            ElementTag quantity = scriptEntry.getElement("quantity");
            ElementTag party = scriptEntry.getElement("party");
            ElementTag skill = scriptEntry.getElement("skill");
            PlayerTag player = Utilities.getEntryPlayer((ScriptEntry)scriptEntry);
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{action, type, state, quantity, party, skill});
            }
            block0 : switch (Action.valueOf(action.asString().toUpperCase()).ordinal()) {
                case 0: {
                    if (quantity.asDouble() >= 0.0 && skill != null && player != null) {
                        switch (Type.valueOf(type.asString().toUpperCase()).ordinal()) {
                            case 1: {
                                if (player.isOnline()) {
                                    ExperienceAPI.addLevel((Player)player.getPlayerEntity(), (String)skill.asString(), (int)quantity.asInt());
                                    break;
                                }
                                ExperienceAPI.addLevelOffline((String)player.getName(), (String)skill.asString(), (int)quantity.asInt());
                                break;
                            }
                            case 0: {
                                if (player.isOnline()) {
                                    ExperienceAPI.addRawXP((Player)player.getPlayerEntity(), (String)skill.asString(), (float)quantity.asFloat());
                                    break;
                                }
                                ExperienceAPI.addRawXPOffline((String)player.getName(), (String)skill.asString(), (float)quantity.asFloat());
                            }
                        }
                        break;
                    }
                    if (party == null || PartyManager.getParty((String)party.asString()) == null) break;
                    PartyAPI.addToParty((Player)player.getPlayerEntity(), (String)party.asString());
                    break;
                }
                case 1: {
                    if (quantity.asDouble() >= 0.0 && skill != null && player != null) {
                        switch (Type.valueOf(type.asString().toUpperCase()).ordinal()) {
                            case 1: {
                                if (player.isOnline()) {
                                    ExperienceAPI.setLevel((Player)player.getPlayerEntity(), (String)skill.asString(), (int)(ExperienceAPI.getLevel((Player)player.getPlayerEntity(), (String)skill.asString()) - quantity.asInt()));
                                    break;
                                }
                                ExperienceAPI.setLevelOffline((String)player.getName(), (String)skill.asString(), (int)(ExperienceAPI.getLevelOffline((String)player.getName(), (String)skill.asString()) - quantity.asInt()));
                                break;
                            }
                            case 0: {
                                if (player.isOnline()) {
                                    ExperienceAPI.removeXP((Player)player.getPlayerEntity(), (String)skill.asString(), (int)quantity.asInt());
                                    break;
                                }
                                ExperienceAPI.removeXPOffline((String)player.getName(), (String)skill.asString(), (int)quantity.asInt());
                            }
                        }
                        break;
                    }
                    if (player != null && player.isOnline() && party != null && PartyManager.getParty((String)party.asString()) != null) {
                        if (PartyAPI.getPartyLeader((String)party.asString()).equals(player.getName())) {
                            PartyManager.disbandParty((Party)PartyManager.getParty((String)party.asString()));
                            break;
                        }
                        PartyAPI.removeFromParty((Player)player.getPlayerEntity());
                        break;
                    }
                    if (player == null) break;
                    mcMMO.getDatabaseManager().removeUser(player.getName(), player.getUUID());
                    break;
                }
                case 2: {
                    if (quantity.asDouble() >= 0.0 && skill != null && player != null) {
                        switch (Type.valueOf(type.asString().toUpperCase()).ordinal()) {
                            case 1: {
                                if (player.isOnline()) {
                                    ExperienceAPI.setLevel((Player)player.getPlayerEntity(), (String)skill.asString(), (int)quantity.asInt());
                                    break;
                                }
                                ExperienceAPI.setLevelOffline((String)player.getName(), (String)skill.asString(), (int)quantity.asInt());
                                break;
                            }
                            case 0: {
                                if (player.isOnline()) {
                                    ExperienceAPI.setXP((Player)player.getPlayerEntity(), (String)skill.asString(), (int)quantity.asInt());
                                    break;
                                }
                                ExperienceAPI.setXPOffline((String)player.getName(), (String)skill.asString(), (int)quantity.asInt());
                            }
                        }
                        break;
                    }
                    switch (Type.valueOf(type.asString().toUpperCase()).ordinal()) {
                        case 4: {
                            if (party != null && PartyManager.getParty((String)party.asString()) != null) {
                                PartyAPI.setPartyLeader((String)party.asString(), (String)player.getName());
                                break block0;
                            }
                            break block49;
                        }
                        case 3: {
                            if (quantity.asInt() > 0) {
                                ExperienceConfig.getInstance().setExperienceGainsGlobalMultiplier((double)quantity.asInt());
                                break block0;
                            }
                            break block49;
                        }
                        case 6: {
                            if (skill == null) {
                                return;
                            }
                            PrimarySkillType skillType = PrimarySkillType.getSkill((String)skill.asString());
                            boolean isEnabled = mcMMO.p.getGeneralConfig().getHardcoreStatLossEnabled(skillType);
                            switch (State.valueOf(state.asString().toUpperCase()).ordinal()) {
                                case 2: {
                                    mcMMO.p.getGeneralConfig().setHardcoreStatLossEnabled(skillType, !isEnabled);
                                    break block0;
                                }
                                case 0: {
                                    mcMMO.p.getGeneralConfig().setHardcoreStatLossEnabled(skillType, true);
                                    break block0;
                                }
                                case 1: {
                                    mcMMO.p.getGeneralConfig().setHardcoreStatLossEnabled(skillType, false);
                                }
                            }
                            break block0;
                        }
                        case 5: {
                            if (skill == null) {
                                return;
                            }
                            PrimarySkillType skillType = PrimarySkillType.getSkill((String)skill.asString());
                            boolean isEnabled = mcMMO.p.getGeneralConfig().getHardcoreVampirismEnabled(skillType);
                            switch (State.valueOf(state.asString().toUpperCase()).ordinal()) {
                                case 2: {
                                    mcMMO.p.getGeneralConfig().setHardcoreVampirismEnabled(skillType, !isEnabled);
                                    break block0;
                                }
                                case 0: {
                                    mcMMO.p.getGeneralConfig().setHardcoreVampirismEnabled(skillType, true);
                                    break block0;
                                }
                                case 1: {
                                    mcMMO.p.getGeneralConfig().setHardcoreVampirismEnabled(skillType, false);
                                }
                            }
                            break block0;
                        }
                    }
                }
            }
        }
    }

    private static enum Action {
        ADD,
        REMOVE,
        SET;

    }

    private static enum State {
        TRUE,
        FALSE,
        TOGGLE;

    }

    private static enum Type {
        XP,
        LEVELS,
        TOGGLE,
        XPRATE,
        LEADER,
        VAMPIRISM,
        HARDCORE;

    }
}

