/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.clientizen.network;

import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.clientizen.ClientizenBridge;
import com.denizenscript.depenizen.bukkit.clientizen.network.ClientizenPacketIn;
import com.denizenscript.depenizen.bukkit.clientizen.network.ClientizenPacketOut;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public class NetworkManager
implements PluginMessageListener {
    private static NetworkManager instance;
    private static final Map<String, ClientizenPacketIn> IN_PACKETS;
    public static final String CHANNEL_NAMESPACE = "clientizen";
    public static final int MAX_PACKET_LENGTH;

    public static void init() {
        instance = new NetworkManager();
    }

    public static String channel(String path) {
        return "clientizen:" + path;
    }

    public static void registerInPacket(ClientizenPacketIn packet) {
        String channel = NetworkManager.channel(packet.getName());
        if (IN_PACKETS.containsKey(channel)) {
            Debug.echoError((String)("Tried registering in packet on channel '" + channel + "', but it is already registered!"));
            return;
        }
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)Depenizen.instance, channel, (PluginMessageListener)instance);
        IN_PACKETS.put(channel, packet);
    }

    public static void broadcast(ClientizenPacketOut packet) {
        for (UUID uuid : ClientizenBridge.clientizenPlayers) {
            NetworkManager.send(Bukkit.getPlayer((UUID)uuid), packet);
        }
    }

    public static void send(Player target, ClientizenPacketOut packet) {
        if (!Bukkit.getMessenger().isOutgoingChannelRegistered((Plugin)Depenizen.instance, packet.channel)) {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)Depenizen.instance, packet.channel);
        }
        ByteBuf buf = Unpooled.buffer();
        packet.writeTo(buf);
        target.sendPluginMessage((Plugin)Depenizen.instance, packet.channel, NetworkManager.bufToBytes(buf));
    }

    public static byte[] bufToBytes(ByteBuf buf) {
        return ByteBufUtil.getBytes((ByteBuf)buf, (int)buf.readerIndex(), (int)buf.readableBytes(), (boolean)false);
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        if (message.length > MAX_PACKET_LENGTH) {
            Debug.log((String)("Packet with length " + message.length + " received from " + player.getName() + ", which exceeds the maximum packet length of " + MAX_PACKET_LENGTH + " - ignoring."));
            return;
        }
        IN_PACKETS.get(channel).process(player, Unpooled.wrappedBuffer((byte[])message));
    }

    static {
        IN_PACKETS = new HashMap<String, ClientizenPacketIn>();
        MAX_PACKET_LENGTH = Depenizen.instance.getConfig().getInt("Clientizen.max packet length", 10000);
    }
}

