/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerClaimsPlotScriptEvent;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerCreatesTownScriptEvent;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerEntersTownScriptEvent;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerExitsTownScriptEvent;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerJoinsTownScriptEvent;
import com.denizenscript.depenizen.bukkit.events.towny.PlayerLeavesTownScriptEvent;
import com.denizenscript.depenizen.bukkit.events.towny.TownCreatedScriptEvent;
import com.denizenscript.depenizen.bukkit.objects.towny.NationTag;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.denizenscript.depenizen.bukkit.properties.towny.TownyCuboidProperties;
import com.denizenscript.depenizen.bukkit.properties.towny.TownyLocationProperties;
import com.denizenscript.depenizen.bukkit.properties.towny.TownyPlayerProperties;
import com.denizenscript.depenizen.bukkit.properties.towny.TownyWorldProperties;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;

public class TownyBridge
extends Bridge {
    @Override
    public void init() {
        ObjectFetcher.registerWithObjectFetcher(TownTag.class, TownTag.tagProcessor);
        ObjectFetcher.registerWithObjectFetcher(NationTag.class, NationTag.tagProcessor);
        PropertyParser.registerProperty(TownyPlayerProperties.class, PlayerTag.class);
        TownyLocationProperties.register();
        PropertyParser.registerProperty(TownyCuboidProperties.class, CuboidTag.class);
        PropertyParser.registerProperty(TownyWorldProperties.class, WorldTag.class);
        ScriptEvent.registerScriptEvent(PlayerClaimsPlotScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerCreatesTownScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerEntersTownScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerExitsTownScriptEvent.class);
        ScriptEvent.registerScriptEvent(TownCreatedScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerJoinsTownScriptEvent.class);
        ScriptEvent.registerScriptEvent(PlayerLeavesTownScriptEvent.class);
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                TownyBridge.this.townyTagEvent(event);
            }
        }, (String[])new String[]{"towny"});
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                TownyBridge.this.townTagEvent(event);
            }
        }, (String[])new String[]{"town"});
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                TownyBridge.this.nationTagEvent(event);
            }
        }, (String[])new String[]{"nation"});
    }

    public void townyTagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("list_towns")) {
            ListTag towns = new ListTag();
            if (attribute.hasParam()) {
                TownyWorld world = TownyAPI.getInstance().getDataSource().getWorld(attribute.getParam().replace("w@", ""));
                if (world == null) {
                    attribute.echoError("World specified is not a registered towny world!");
                    return;
                }
                for (Town town : world.getTowns().values()) {
                    towns.addObject((ObjectTag)new TownTag(town));
                }
            } else {
                for (Town town : TownyUniverse.getInstance().getTowns()) {
                    towns.addObject((ObjectTag)new TownTag(town));
                }
            }
            event.setReplacedObject(towns.getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("nations")) {
            ListTag nations = new ListTag();
            for (Nation nation : TownyUniverse.getInstance().getNations()) {
                nations.addObject((ObjectTag)new NationTag(nation));
            }
            event.setReplacedObject(nations.getObjectAttribute(attribute.fulfill(1)));
        }
    }

    public void townTagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes();
        if (attribute.hasParam()) {
            if (!TownTag.matches(attribute.getParam())) {
                attribute.echoError("Could not match '" + attribute.getParam() + "' to a valid town!");
                return;
            }
            TownTag town = (TownTag)attribute.paramAsType(TownTag.class);
            if (town != null) {
                event.setReplacedObject(town.getObjectAttribute(attribute.fulfill(1)));
            } else {
                attribute.echoError("Unknown town '" + attribute.getParam() + "' for town[] tag.");
            }
        }
    }

    public void nationTagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes();
        if (attribute.hasParam()) {
            if (!NationTag.matches(attribute.getParam())) {
                attribute.echoError("Could not match '" + attribute.getParam() + "' to a valid nation!");
                return;
            }
            NationTag nation = (NationTag)attribute.paramAsType(NationTag.class);
            if (nation != null) {
                event.setReplacedObject(nation.getObjectAttribute(attribute.fulfill(1)));
            } else {
                attribute.echoError("Unknown nation '" + attribute.getParam() + "' for nation[] tag.");
            }
        }
    }
}

