/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.noteblockapi;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.xxmicloxx.NoteBlockAPI.NoteBlockAPI;
import com.xxmicloxx.NoteBlockAPI.event.SongEndEvent;
import com.xxmicloxx.NoteBlockAPI.model.Song;
import com.xxmicloxx.NoteBlockAPI.songplayer.PositionSongPlayer;
import com.xxmicloxx.NoteBlockAPI.songplayer.RadioSongPlayer;
import com.xxmicloxx.NoteBlockAPI.songplayer.SongPlayer;
import com.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class NBSCommand
extends AbstractCommand
implements Holdable,
Listener {
    public static Map<SongPlayer, ScriptEntry> waitingForSongs = new HashMap<SongPlayer, ScriptEntry>();

    public NBSCommand() {
        this.setName("nbs");
        this.setSyntax("nbs [play/stop] (file:<file_path>) (targets:<entity>|...) (at:<location>) (distance:<#>/{16})");
        this.setRequiredArguments(1, 5);
        this.autoCompile();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Depenizen.instance);
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="action") Action action, @ArgName(value="file") @ArgPrefixed @ArgDefaultNull String file, @ArgName(value="targets") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> targets, @ArgName(value="at") @ArgPrefixed @ArgDefaultNull LocationTag location, @ArgName(value="distance") @ArgPrefixed @ArgDefaultText(value="16") int distance) {
        if (targets == null) {
            if (Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
                targets = List.of(Utilities.getEntryPlayer((ScriptEntry)scriptEntry));
            } else {
                scriptEntry.setFinished(true);
                throw new InvalidArgumentsRuntimeException("Must specify players that can hear the song!");
            }
        }
        switch (action.ordinal()) {
            case 0: {
                RadioSongPlayer sp;
                if (file == null) {
                    Debug.echoError((String)"File not specified!");
                    scriptEntry.setFinished(true);
                    return;
                }
                File songFile = new File(Denizen.getInstance().getDataFolder(), file + ".nbs");
                if (!Utilities.canReadFile((File)songFile)) {
                    Debug.echoError((String)"Cannot read from that file path due to security settings in Denizen/config.yml.");
                    scriptEntry.setFinished(true);
                    return;
                }
                Song s = NBSDecoder.parse((File)songFile);
                if (location == null) {
                    sp = new RadioSongPlayer(s);
                } else {
                    sp = new PositionSongPlayer(s);
                    ((PositionSongPlayer)sp).setTargetLocation((Location)location);
                    ((PositionSongPlayer)sp).setDistance(distance);
                }
                for (PlayerTag p : targets) {
                    sp.addPlayer(p.getPlayerEntity());
                }
                sp.setAutoDestroy(true);
                sp.setPlaying(true);
                if (scriptEntry.shouldWaitFor()) {
                    waitingForSongs.put((SongPlayer)sp, scriptEntry);
                    break;
                }
                scriptEntry.setFinished(true);
                break;
            }
            case 1: {
                for (PlayerTag p : targets) {
                    NoteBlockAPI.stopPlaying((Player)p.getPlayerEntity());
                }
                scriptEntry.setFinished(true);
            }
        }
    }

    @EventHandler
    public void onSongEnds(SongEndEvent event) {
        SongPlayer sp = event.getSongPlayer();
        ScriptEntry scriptEntry = waitingForSongs.remove(sp);
        if (scriptEntry != null) {
            scriptEntry.setFinished(true);
        }
    }

    public static enum Action {
        PLAY,
        STOP;

    }
}

