/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.vivecraft;

import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgRaw;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.depenizen.bukkit.bridges.ViveCraftBridge;
import com.denizenscript.depenizen.bukkit.objects.vivecraft.ViveCraftPlayerTag;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.vivecraft.VSE;
import org.vivecraft.VivePlayer;

public class ViveMirrorCommand
extends AbstractCommand {
    public ViveMirrorCommand() {
        this.setName("vivemirror");
        this.setSyntax("vivemirror [<npc>] [mirror:<vivecraftplayer>] (targets:{player}/<player>|...)");
        this.setRequiredArguments(2, 3);
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgLinear @ArgName(value="npc") @ArgRaw NPCTag npc, @ArgPrefixed @ArgName(value="mirror") ViveCraftPlayerTag mirror, @ArgPrefixed @ArgName(value="targets") @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> targets) {
        if (!(npc.getEntity() instanceof Player)) {
            throw new InvalidArgumentsRuntimeException("NPC must be a PLAYER type NPC.");
        }
        if (targets == null) {
            if (!Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
                throw new InvalidArgumentsRuntimeException("Missing player input.");
            }
            targets = Collections.singletonList(Utilities.getEntryPlayer((ScriptEntry)scriptEntry));
        }
        VivePlayer vp = new VivePlayer((Player)npc.getLivingEntity());
        VivePlayer copy = mirror.getVivePlayer();
        vp.worldScale = copy.worldScale;
        vp.heightScale = copy.heightScale;
        vp.hmdData = copy.hmdData;
        vp.controller0data = copy.controller0data;
        vp.controller1data = copy.controller1data;
        for (PlayerTag target : targets) {
            if (!ViveCraftBridge.isViveCraftPlayer(target.getPlayerEntity())) continue;
            target.getPlayerEntity().sendPluginMessage((Plugin)VSE.getPlugin(VSE.class), "vivecraft:data", vp.getUberPacket());
        }
    }
}

