/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.crackshot;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.shampaggon.crackshot.events.WeaponPreShootEvent;
import java.util.Arrays;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CrackShotPlayerFiresProjectileEvent
extends BukkitScriptEvent
implements Listener {
    public static CrackShotPlayerFiresProjectileEvent instance;
    public WeaponPreShootEvent event;

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase((String)determination);
        if (lower.startsWith("bullet_spread:")) {
            ElementTag newBulletSpread = new ElementTag(lower.substring("bullet_spread:".length()));
            if (!newBulletSpread.isDouble()) {
                Debug.echoError((String)"Determination for 'bullet_spread' must be a valid number.");
                return false;
            }
            this.event.setBulletSpread(newBulletSpread.asDouble());
            return true;
        }
        if (lower.startsWith("shot_sounds:")) {
            String newReloadSounds = determination.substring("shot_sounds:".length());
            if (CoreUtilities.equalsIgnoreCase((String)newReloadSounds, (String)"none")) {
                newReloadSounds = "";
            }
            this.event.setSounds(newReloadSounds);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("crackshot player fires projectile");
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "weapon" -> new ElementTag(this.event.getWeaponTitle());
            case "bullet_spread" -> new ElementTag(this.event.getBulletSpread());
            case "shot_sounds" -> new ListTag(Arrays.asList(this.event.getSounds().split(",")));
            case "left_click" -> new ElementTag(this.event.isLeftClick());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onFiresProjectile(WeaponPreShootEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

