/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.mcmmo;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.gmail.nossr50.events.experience.McMMOPlayerLevelUpEvent;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class mcMMOPlayerLevelUpScriptEvent
extends BukkitScriptEvent
implements Listener {
    public McMMOPlayerLevelUpEvent event;
    public PlayerTag player;
    public ElementTag skill;
    public int new_level;
    public int levels_gained;
    public String cause;

    public mcMMOPlayerLevelUpScriptEvent() {
        this.registerCouldMatcher("mcmmo player levels up <'skill'>");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String eSkill = path.eventArgLowerAt(4);
        if (!eSkill.equals("skill") && !eSkill.equals(CoreUtilities.toLowerCase((String)this.skill.asString()))) {
            return false;
        }
        if (!this.runInCheck(path, (Location)this.player.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag element;
        if (determinationObj instanceof ElementTag && (element = (ElementTag)determinationObj).isInt()) {
            this.levels_gained = element.asInt();
            this.event.setLevelsGained(this.levels_gained);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "skill": {
                return this.skill;
            }
            case "new_level": {
                return new ElementTag(this.new_level);
            }
            case "old_level": {
                return new ElementTag(this.new_level - this.levels_gained);
            }
            case "levels_gained": {
                return new ElementTag(this.levels_gained);
            }
            case "cause": {
                return new ElementTag(this.cause);
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onmcMMOPlayerLevelUp(McMMOPlayerLevelUpEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.levels_gained = event.getLevelsGained();
        this.new_level = event.getSkillLevel();
        this.cause = event.getXpGainReason().toString();
        this.skill = new ElementTag(event.getSkill().getName());
        this.event = event;
        this.fire((Event)event);
    }
}

