/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.mythicmobs;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.objects.mythicmobs.MythicMobsMobTag;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class MythicMobsDeathEvent
extends BukkitScriptEvent
implements Listener {
    public static MythicMobsDeathEvent instance;
    public MythicMobDeathEvent event;
    public MythicMobsMobTag mythicmob;
    public EntityTag entity;
    public EntityTag killer;

    public MythicMobsDeathEvent() {
        this.registerCouldMatcher("mythicmob <'mob'> dies|death|killed");
        this.registerSwitches(new String[]{"by"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String mob = path.eventArgLowerAt(1);
        if (!mob.equals("mob") && !MythicMobsDeathEvent.runGenericCheck((String)mob, (String)this.mythicmob.getMobType().getInternalName())) {
            return false;
        }
        if (path.eventArgLowerAt(3).equals("by") && (this.killer == null || !path.tryArgObject(4, (ObjectTag)this.killer))) {
            return false;
        }
        if (!path.tryObjectSwitch("by", (ObjectTag)this.killer)) {
            return false;
        }
        if (!(this.runInCheck(path, (Location)this.entity.getLocation()) || this.killer != null && this.runInCheck(path, (Location)this.killer.getLocation()))) {
            return false;
        }
        return super.matches(path);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        if (Argument.valueOf((String)determination).matchesArgumentList(ItemTag.class)) {
            ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
            for (ItemTag item : ListTag.valueOf((String)determination, (TagContext)this.getTagContext(path)).filter(ItemTag.class, (Debuggable)path.container, true)) {
                if (item == null) continue;
                newDrops.add(item.getItemStack());
            }
            this.event.setDrops(newDrops);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.killer);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "mob": {
                return this.mythicmob;
            }
            case "killer": {
                return this.killer;
            }
            case "entity": {
                return this.entity;
            }
            case "drops": {
                ListTag drops = new ListTag();
                for (ItemStack i : this.event.getDrops()) {
                    drops.addObject((ObjectTag)new ItemTag(i));
                }
                return drops;
            }
            case "level": {
                return new ElementTag(this.event.getMobLevel());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onMythicMobDeath(MythicMobDeathEvent event) {
        this.mythicmob = new MythicMobsMobTag(event.getMob());
        EntityTag entityTag = this.entity = event.getEntity() == null ? null : new EntityTag(event.getEntity());
        if (this.entity != null) {
            EntityTag.rememberEntity((Entity)this.entity.getBukkitEntity());
        }
        this.killer = event.getKiller() == null ? null : new EntityTag((Entity)event.getKiller());
        this.event = event;
        this.fire((Event)event);
        if (this.entity != null) {
            EntityTag.forgetEntity((Entity)this.entity.getBukkitEntity());
        }
    }
}

