/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.noteblockapi;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.xxmicloxx.NoteBlockAPI.event.SongEndEvent;
import java.nio.file.Path;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NoteBlockAPISongEndsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public SongEndEvent event;

    public NoteBlockAPISongEndsScriptEvent() {
        this.registerCouldMatcher("noteblockapi song (<'song'>) ends");
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        String songName = path.eventArgLowerAt(2);
        return songName.equals("ends") || songName.equals(CoreUtilities.toLowerCase((String)this.getSongFileName()));
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    public String getSongFileName() {
        try {
            Path songPath = this.event.getSongPlayer().getSong().getPath().toPath();
            Path denizenPath = Denizen.getInstance().getDataFolder().toPath();
            String finalPath = denizenPath.relativize(songPath).toString();
            if (finalPath.endsWith(".nbs")) {
                finalPath = finalPath.substring(0, finalPath.length() - ".nbs".length());
            }
            return finalPath;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public ObjectTag getContext(String name) {
        if (name.equals("song")) {
            return new ElementTag(this.getSongFileName());
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onSongEndEvent(SongEndEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

