/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.factions;

import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.MFlag;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.massivecore.money.Money;
import com.massivecraft.massivecore.ps.PS;
import java.util.Set;

public class FactionTag
implements ObjectTag {
    Faction faction = null;
    private String prefix = "Faction";

    @Fetchable(value="faction")
    public static FactionTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("faction@", "");
        Faction faction = FactionColl.get().getByName(string);
        if (faction != null) {
            return new FactionTag(faction);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return FactionTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public FactionTag(Faction faction) {
        if (faction != null) {
            this.faction = faction;
        } else {
            Debug.echoError((String)"Faction referenced is null!");
        }
    }

    public Faction getFaction() {
        return this.faction;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "faction@" + this.faction.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute.startsWith("balance")) {
            return new ElementTag(Money.get((Object)this.faction)).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("warp") && attribute.hasParam()) {
            warp = this.faction.getWarp((Object)attribute.getParam());
            if (warp != null) {
                return new LocationTag(warp.getLocation().asBukkitLocation()).getObjectAttribute(attribute.fulfill(1));
            }
        } else if (attribute.startsWith("home")) {
            warp = this.faction.getWarp((Object)"home");
            if (warp != null) {
                return new LocationTag(warp.getLocation().asBukkitLocation()).getObjectAttribute(attribute.fulfill(1));
            }
        } else {
            if (attribute.startsWith("id")) {
                return new ElementTag(this.faction.getId()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("isopen") || attribute.startsWith("is_open")) {
                return new ElementTag(this.faction.isOpen()).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("ispeaceful") || attribute.startsWith("is_peaceful")) {
                return new ElementTag(this.faction.getFlag(MFlag.getFlagPeaceful())).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("ispermanent") || attribute.startsWith("is_permanent")) {
                return new ElementTag(this.faction.getFlag(MFlag.getFlagPermanent())).getObjectAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("leader")) {
                if (this.faction.getLeader() != null) {
                    return new PlayerTag(this.faction.getLeader().getUuid()).getObjectAttribute(attribute.fulfill(1));
                }
            } else {
                if (attribute.startsWith("name")) {
                    return new ElementTag(this.faction.getName()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("playercount") || attribute.startsWith("player_count")) {
                    return new ElementTag(this.faction.getMPlayers().size()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("power")) {
                    return new ElementTag(this.faction.getPower()).getObjectAttribute(attribute.fulfill(1));
                }
                if (attribute.startsWith("relation")) {
                    FactionTag to = FactionTag.valueOf(attribute.getParam(), attribute.context);
                    if (to != null) {
                        return new ElementTag(this.faction.getRelationTo((RelationParticipator)to.getFaction()).toString()).getObjectAttribute(attribute.fulfill(1));
                    }
                } else if (attribute.startsWith("size")) {
                    return new ElementTag(this.faction.getLandCount()).getObjectAttribute(attribute.fulfill(1));
                }
            }
        }
        if (attribute.startsWith("claimed_chunks")) {
            Set chunks = BoardColl.get().getChunks(this.faction);
            ListTag dchunks = new ListTag();
            for (PS ps : chunks) {
                dchunks.addObject((ObjectTag)new ChunkTag(ps.asBukkitChunk()));
            }
            return dchunks.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_players")) {
            ListTag players = new ListTag();
            for (MPlayer ps : this.faction.getMPlayers()) {
                players.addObject((ObjectTag)new PlayerTag(ps.getUuid()));
            }
            return players.getObjectAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getObjectAttribute(attribute);
    }
}

