/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.vivecraft;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.QuaternionTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.ViveCraftBridge;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.vivecraft.VSE;
import org.vivecraft.VivePlayer;

public class ViveCraftPlayerTag
implements ObjectTag {
    public Player player;
    public VivePlayer vivePlayer;
    private String prefix;
    public static ObjectTagProcessor<ViveCraftPlayerTag> tagProcessor = new ObjectTagProcessor();

    public static ViveCraftPlayerTag valueOf(String uuid) {
        return ViveCraftPlayerTag.valueOf(uuid, null);
    }

    @Fetchable(value="vivecraft")
    public static ViveCraftPlayerTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        try {
            string = string.replace("vivecraft@", "");
            UUID uuid = UUID.fromString(string);
            PlayerTag player = new PlayerTag(uuid);
            if (!ViveCraftBridge.isViveCraftPlayer(player.getPlayerEntity())) {
                return null;
            }
            return new ViveCraftPlayerTag(player.getPlayerEntity());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean matches(String string) {
        return string.startsWith("vivecraft@");
    }

    public ViveCraftPlayerTag(Player player) {
        if (VSE.isVive((Player)player)) {
            this.vivePlayer = ViveCraftBridge.getViveCraftPlayer(player);
            this.player = player;
        } else {
            Debug.echoError((String)"ViceCraftPlayer referenced is null!");
        }
    }

    public VivePlayer getVivePlayer() {
        return this.vivePlayer;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "vivecraft@" + String.valueOf(this.player.getUniqueId());
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public static void register() {
        tagProcessor.registerTag(ElementTag.class, "active_hand", (attribute, object) -> new ElementTag(((MetadataValue)object.getPlayer().getMetadata("activehand").get(0)).asString()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_seated", (attribute, object) -> new ElementTag(((MetadataValue)object.getPlayer().getMetadata("seated").get(0)).asBoolean()), new String[0]);
        tagProcessor.registerTag(LocationTag.class, ElementTag.class, "position", (attribute, object, input) -> {
            Location location;
            switch (input.toString()) {
                case "head": {
                    location = (Location)((MetadataValue)object.getPlayer().getMetadata("head.pos").get(0)).value();
                    break;
                }
                case "left": {
                    location = (Location)((MetadataValue)object.getPlayer().getMetadata("lefthand.pos").get(0)).value();
                    break;
                }
                case "right": {
                    location = (Location)((MetadataValue)object.getPlayer().getMetadata("righthand.pos").get(0)).value();
                    break;
                }
                default: {
                    attribute.echoError("Attribute must be 'head', 'left' or 'right'");
                    return null;
                }
            }
            if (location == null) {
                attribute.echoError("Location is not valid. Did a plugin overwrite the data?");
                return null;
            }
            return new LocationTag(location);
        }, new String[0]);
        tagProcessor.registerTag(QuaternionTag.class, ElementTag.class, "rotation", (attribute, object, input) -> {
            float[] rotation;
            switch (input.toString()) {
                case "head": {
                    float[] fArray = (float[])((MetadataValue)object.getPlayer().getMetadata("head.rot").get(0)).value();
                    break;
                }
                case "left": {
                    float[] fArray = (float[])((MetadataValue)object.getPlayer().getMetadata("lefthand.rot").get(0)).value();
                    break;
                }
                case "right": {
                    float[] fArray = (float[])((MetadataValue)object.getPlayer().getMetadata("righthand.rot").get(0)).value();
                    break;
                }
                default: {
                    attribute.echoError("Invalid part specified, must be 'head', 'left' or 'right'");
                    float[] fArray = rotation = null;
                }
            }
            if (rotation == null) {
                attribute.echoError("Rotation is not valid. Did a plugin overwrite the data?");
                return null;
            }
            return new QuaternionTag((double)rotation[1], (double)rotation[2], (double)rotation[3], (double)rotation[0]);
        }, new String[0]);
    }
}

