/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldguard;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.WorldGuardBridge;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldGuardPlayerProperties
implements Property {
    public static final String[] handledTags = new String[]{"worldguard"};
    public static final String[] handledMechs = new String[0];
    Player player;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "WorldGuardPlayer";
    }

    public void adjust(Mechanism mechanism) {
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof PlayerTag && ((PlayerTag)object).isOnline();
    }

    public static WorldGuardPlayerProperties getFrom(ObjectTag object) {
        if (!WorldGuardPlayerProperties.describes(object)) {
            return null;
        }
        return new WorldGuardPlayerProperties((PlayerTag)object);
    }

    public WorldGuardPlayerProperties(PlayerTag player) {
        this.player = player.getPlayerEntity();
    }

    public Flag getFlag(String s) {
        return Flags.fuzzyMatchFlag((FlagRegistry)WorldGuard.getInstance().getFlagRegistry(), (String)s);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (!attribute.startsWith("worldguard") && !attribute.startsWith("wg")) {
            return null;
        }
        if ((attribute = attribute.fulfill(1)).startsWith("can_build") && attribute.hasParam()) {
            LocationTag location = (LocationTag)attribute.paramAsType(LocationTag.class);
            if (location == null) {
                return null;
            }
            WorldGuardPlugin worldGuard = (WorldGuardPlugin)WorldGuardBridge.instance.plugin;
            return new ElementTag(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().testBuild(BukkitAdapter.adapt((Location)location), worldGuard.wrapPlayer(this.player), new StateFlag[0])).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("test_flag")) {
            if (!attribute.hasParam()) {
                Debug.echoError((String)"The tag PlayerTag.worlduard.test_flag[...] must have a value.");
                return null;
            }
            Flag flag = this.getFlag(attribute.getParam());
            if (flag == null) {
                Debug.echoError((String)("The tag PlayerTag.worlduard.test_flag[...] has an invalid value: " + attribute.getParam()));
                return null;
            }
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            Location loc = this.player.getLocation();
            int args = 1;
            if (attribute.getAttribute(2).startsWith("at") && attribute.hasContext(2)) {
                loc = (Location)attribute.contextAsType(2, LocationTag.class);
                args = 2;
                if (loc == null) {
                    return null;
                }
            }
            WorldGuardPlugin worldGuard = (WorldGuardPlugin)WorldGuardBridge.instance.plugin;
            Object result = flag instanceof StateFlag ? new ElementTag(query.testState(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(this.player), new StateFlag[]{(StateFlag)flag})) : CoreUtilities.objectToTagForm((Object)query.queryValue(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(this.player), flag), (TagContext)attribute.context);
            return result.getObjectAttribute(attribute.fulfill(args));
        }
        return null;
    }
}

