/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee.packets.in;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketIn;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class RunCommandsPacketIn
extends BungeePacketIn {
    @Override
    public String getName() {
        return "RunCommands";
    }

    @Override
    public void process(ByteBuf data) {
        if (data.readableBytes() < 12) {
            BungeeBridge.instance.handler.fail("Invalid RunCommandsPacket (bytes available: " + data.readableBytes() + ")");
            return;
        }
        String commands = this.readString(data, "commands");
        String defs = this.readString(data, "defs");
        if (commands == null || defs == null) {
            return;
        }
        boolean shouldDebug = data.readByte() != 0;
        long uuidMost = data.readLong();
        long uuidLeast = data.readLong();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            PlayerTag linkedPlayer = null;
            if (uuidMost != 0L || uuidLeast != 0L) {
                UUID uuid = new UUID(uuidMost, uuidLeast);
                try {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (player != null) {
                        linkedPlayer = new PlayerTag(player);
                    }
                }
                catch (Exception player) {
                    // empty catch block
                }
            }
            List commandsSeparated = CoreUtilities.split((String)commands, (char)'\n');
            ArrayList<Object> rawEntries = new ArrayList<Object>();
            for (Object cmd : commandsSeparated) {
                if (((String)cmd).length() <= 0) continue;
                rawEntries.add(RunCommandsPacketIn.parseCommandsBack(RunCommandsPacketIn.unescape((String)cmd)));
            }
            List entries = ScriptBuilder.buildScriptEntries(rawEntries, null, (ScriptEntryData)new BukkitScriptEntryData(linkedPlayer, null));
            if (entries.isEmpty()) {
                return;
            }
            if (!shouldDebug) {
                for (ScriptEntry entry : entries) {
                    entry.internal.shouldDebugBool = false;
                }
            }
            InstantQueue queue = new InstantQueue("BUNGEE_");
            queue.addEntries(entries);
            List defSets = CoreUtilities.split((String)defs, (char)'\r');
            List defNames = CoreUtilities.split((String)((String)defSets.get(0)), (char)'\n');
            List defValues = CoreUtilities.split((String)((String)defSets.get(1)), (char)'\n');
            for (int i = 0; i < defNames.size(); ++i) {
                String name = RunCommandsPacketIn.unescape((String)defNames.get(i));
                if (name.length() <= 0) continue;
                String value = RunCommandsPacketIn.unescape((String)defValues.get(i));
                queue.addDefinition(name, value);
                Debug.echoDebug((Debuggable)((Debuggable)entries.get(0)), (String)("Adding definition '" + name + "' as " + value));
            }
            queue.start();
        });
    }

    public static String unescape(String text) {
        return text.replace("\\n", "\n").replace("\\r", "\r").replace("\\\\", "\\");
    }

    public static Object parseCommandsBack(String value) {
        List cmds = CoreUtilities.split((String)value, (char)'\r');
        if (cmds.size() == 1) {
            return cmds.get(0);
        }
        ArrayList<Object> resultSubList = new ArrayList<Object>();
        for (int i = 1; i < cmds.size(); ++i) {
            if (((String)cmds.get(i)).length() <= 0) continue;
            resultSubList.add(RunCommandsPacketIn.parseCommandsBack(RunCommandsPacketIn.unescape((String)cmds.get(i))));
        }
        HashMap<String, ArrayList<Object>> resultMap = new HashMap<String, ArrayList<Object>>();
        resultMap.put((String)cmds.get(0), resultSubList);
        return resultMap;
    }
}

